/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class TextMateHighlighter
extends SyntaxHighlighterBase {
    private static final PlainSyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new PlainSyntaxHighlighter();
    @Nullable
    private final Lexer myLexer;

    public TextMateHighlighter(@Nullable Lexer lexer) {
        this.myLexer = lexer;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.myLexer == null ? PLAIN_SYNTAX_HIGHLIGHTER.getHighlightingLexer() : this.myLexer;
        if (lexer == null) {
            TextMateHighlighter.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (!(tokenType instanceof TextMateElementType)) {
            TextAttributesKey[] textAttributesKeyArray = PLAIN_SYNTAX_HIGHLIGHTER.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                TextMateHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextMateService service = TextMateService.getInstance();
        Map<CharSequence, TextMateTextAttributesAdapter> customHighlightingColors = service.getCustomHighlightingColors();
        Set highlightingRules = ContainerUtil.union(customHighlightingColors.keySet(), TextMateTheme.INSTANCE.getRules());
        TextMateScope textMateScope = TextMateHighlighter.trimEmbeddedScope((TextMateElementType)tokenType);
        List selectors = ContainerUtil.reverse(new TextMateScopeComparator(textMateScope, Function.identity()).sortAndFilter(highlightingRules));
        TextAttributesKey[] textAttributesKeyArray = (TextAttributesKey[])ContainerUtil.map2Array((Collection)selectors, TextAttributesKey.class, rule -> {
            TextMateTextAttributesAdapter customTextAttributes = (TextMateTextAttributesAdapter)customHighlightingColors.get(rule);
            return customTextAttributes != null ? customTextAttributes.getTextAttributesKey(TextMateTheme.INSTANCE) : TextMateTheme.INSTANCE.getTextAttributesKey((CharSequence)rule);
        });
        if (textAttributesKeyArray == null) {
            TextMateHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    private static TextMateScope trimEmbeddedScope(TextMateElementType tokenType) {
        TextMateScope result = TextMateScope.EMPTY;
        for (TextMateScope current = tokenType.getScope(); current != null; current = current.getParent()) {
            CharSequence scopeName = current.getScopeName();
            result = result.add(scopeName);
            if (scopeName != null && Strings.contains((CharSequence)scopeName, (CharSequence)".embedded.")) break;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

