/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateCloneImplementation", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "fakeOverride", "cloneFun", "generateDelegationToDefaultImpl", "interfaceImplementation", "classOverride", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "transformMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInheritedDefaultMethodsOnClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,318:1\n26#2,4:319\n1#3:323\n1726#4,3:324\n404#5,10:327\n376#5,13:339\n72#6,2:337\n98#7,2:352\n*S KotlinDebug\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n*L\n42#1:319,4\n54#1:324,3\n70#1:327,10\n93#1:339,13\n70#1:337,2\n93#1:352,2\n*E\n"})
final class InheritedDefaultMethodsOnClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InheritedDefaultMethodsOnClassesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass)) {
            List $this$transformInPlace$iv = irClass.getDeclarations();
            boolean $i$f$transformInPlace = false;
            int i$iv = 0;
            int n = $this$transformInPlace$iv.size();
            while (i$iv < n) {
                void it;
                IrElement irElement;
                IrDeclaration irDeclaration2 = (IrDeclaration)$this$transformInPlace$iv.get(i$iv);
                int n2 = i$iv++;
                List list2 = $this$transformInPlace$iv;
                boolean bl = false;
                IrElement irElement2 = irElement = (IrElement)this.transformMemberDeclaration((IrDeclaration)it);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                list2.set(n2, (IrElement)((IrDeclaration)irElement2));
            }
        }
    }

    private final IrDeclaration transformMemberDeclaration(IrDeclaration declaration) {
        if (!(declaration instanceof IrSimpleFunction)) {
            return declaration;
        }
        if (((IrSimpleFunction)declaration).isFakeOverride() && Intrinsics.areEqual((Object)((IrSimpleFunction)declaration).getName().asString(), (Object)"clone")) {
            Object v2;
            IrSimpleFunction it;
            List overriddenFunctions;
            block9: {
                overriddenFunctions = IrUtilsKt.allOverridden((IrOverridableDeclaration)((IrOverridableDeclaration)declaration), (boolean)false);
                Iterable iterable = overriddenFunctions;
                for (Object t : iterable) {
                    it = (IrSimpleFunction)t;
                    boolean bl = false;
                    IrDeclarationWithName irDeclarationWithName = (IrDeclarationWithName)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)it));
                    FqName fqName2 = StandardNames.FqNames.cloneable.toSafe();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
                    if (!AdditionalIrUtilsKt.hasEqualFqName((IrDeclarationWithName)irDeclarationWithName, (FqName)fqName2)) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            IrSimpleFunction cloneFun = v2;
            if (cloneFun != null) {
                boolean bl;
                block10: {
                    Iterable $this$all$iv = overriddenFunctions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (IrSimpleFunction)element$iv;
                            boolean bl2 = false;
                            if (it.isFakeOverride() || Intrinsics.areEqual((Object)it, (Object)cloneFun)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return (IrDeclaration)this.generateCloneImplementation((IrSimpleFunction)declaration, cloneFun);
                }
            }
        }
        IrSimpleFunction irSimpleFunction = InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation((IrSimpleFunction)declaration, this.context.getState().getJvmDefaultMode());
        if (irSimpleFunction == null) {
            return declaration;
        }
        IrSimpleFunction implementation2 = irSimpleFunction;
        return (IrDeclaration)this.generateDelegationToDefaultImpl(implementation2, (IrSimpleFunction)declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateCloneImplementation(IrSimpleFunction fakeOverride, IrSimpleFunction cloneFun) {
        void $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        void $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        IrCall irCall;
        void this_$iv$iv;
        JvmIrBuilder jvmIrBuilder;
        boolean bl = fakeOverride.isFakeOverride();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrSimpleFunction irFunction = this.context.getCachedDeclarations().getDefaultImplsRedirection(fakeOverride);
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)fakeOverride));
        int classStartOffset = irClass.getStartOffset();
        JvmIrBuilder $this$generateCloneImplementation_u24lambda_u245 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.context, (IrSymbol)irFunction.getSymbol(), classStartOffset, classStartOffset);
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = $this$generateCloneImplementation_u24lambda_u245;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var15_17 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl3 = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244), (IrFunction)((IrFunction)cloneFun), null, (IrClassSymbol)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)cloneFun)).getSymbol());
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        void var21_23 = $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        boolean bl4 = false;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter)));
        Unit unit = Unit.INSTANCE;
        var21_23.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
        irSimpleFunction.setBody((IrBody)this_$iv$iv.doBuild());
        return irFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateDelegationToDefaultImpl(IrSimpleFunction interfaceImplementation, IrSimpleFunction classOverride) {
        void $this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        IrCall irCall;
        void $this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrSimpleFunction irFunction = this.context.getCachedDeclarations().getDefaultImplsRedirection(classOverride);
        IrSimpleFunction superMethod = (IrSimpleFunction)JvmIrUtilsKt.firstSuperMethodFromKotlin(irFunction, interfaceImplementation).getOwner();
        IrSimpleType superClassType = IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)superMethod)));
        IrSimpleFunction defaultImplFun = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), superMethod, false, 2, null);
        int classStartOffset = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)classOverride)).getStartOffset();
        JvmBackendContext backendContext = this.context;
        DeclarationIrBuilder $this$generateDelegationToDefaultImpl_u24lambda_u248 = declarationIrBuilder = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)irFunction.getSymbol()), (int)classStartOffset, (int)classStartOffset);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$generateDelegationToDefaultImpl_u24lambda_u248;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void var20_20 = this_$iv$iv;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateDelegationToDefaultImpl_u24lambda_u248;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl2 = false;
        Map<IrValueParameter, IrExpression> parameter2arguments2 = backendContext.getMultiFieldValueClassReplacements().mapFunctionMfvcStructures((IrBlockBuilder)$this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247, (IrFunction)defaultImplFun, (IrFunction)irFunction, (Function2<? super IrValueParameter, ? super IrType, ? extends IrExpression>)((Function2)new Function2<IrValueParameter, IrType, IrExpression>((IrBlockBuilder)$this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247, irFunction, superClassType){
            final /* synthetic */ IrBlockBuilder $this_irBlock;
            final /* synthetic */ IrSimpleFunction $irFunction;
            final /* synthetic */ IrSimpleType $superClassType;
            {
                this.$this_irBlock = $receiver;
                this.$irFunction = $irFunction;
                this.$superClassType = $superClassType;
                super(2);
            }

            @Nullable
            public final IrExpression invoke(@NotNull IrValueParameter sourceParameter, @NotNull IrType irType) {
                Intrinsics.checkNotNullParameter((Object)sourceParameter, (String)"sourceParameter");
                Intrinsics.checkNotNullParameter((Object)irType, (String)"<anonymous parameter 1>");
                IrGetValueImpl irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)this.$this_irBlock), (IrValueDeclaration)((IrValueDeclaration)sourceParameter));
                IrSimpleFunction irSimpleFunction = this.$irFunction;
                IrSimpleType irSimpleType = this.$superClassType;
                IrGetValueImpl it = irGetValueImpl;
                boolean bl = false;
                return !Intrinsics.areEqual((Object)sourceParameter, (Object)irSimpleFunction.getDispatchReceiverParameter()) ? (IrExpression)it : InheritedDefaultMethodsOnClassesLoweringKt.reinterpretAsDispatchReceiverOfType((IrExpression)it, (IrType)irSimpleType);
            }
        }));
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247), (IrSimpleFunctionSymbol)defaultImplFun.getSymbol(), (IrType)irFunction.getReturnType(), (int)0, (int)0, null, (int)28, null);
        void var27_27 = $this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247;
        boolean bl3 = false;
        int n = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)superMethod)).getTypeParameters().size();
        for (int index2 = 0; index2 < n; ++index2) {
            $this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247_u24lambda_u246.putTypeArgument(index2, JvmIrUtilsKt.createPlaceholderAnyNType($this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247.getContext().getIrBuiltIns()));
        }
        IrUtilsKt.passTypeArgumentsFrom((IrFunctionAccessExpression)((IrFunctionAccessExpression)$this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247_u24lambda_u246), (IrTypeParametersContainer)((IrTypeParametersContainer)irFunction), (int)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)superMethod)).getTypeParameters().size());
        for (Map.Entry<IrValueParameter, IrExpression> entry : parameter2arguments2.entrySet()) {
            IrValueParameter parameter = entry.getKey();
            IrExpression argument2 = entry.getValue();
            if (argument2 == null) continue;
            IrExpressionsKt.putArgument((IrFunctionAccessExpression)((IrFunctionAccessExpression)$this$generateDelegationToDefaultImpl_u24lambda_u248_u24lambda_u247_u24lambda_u246), (IrValueParameter)parameter, (IrExpression)argument2);
        }
        var27_27.unaryPlus((IrStatement)irCall);
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)this_$iv$iv.doBuild())));
        return irFunction;
    }
}

