/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.settingsSync.LocalHostNameProvider;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncCategoriesChangeListener;
import com.intellij.settingsSync.SettingsSyncEnabledStateListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncEventsStatistics;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncMigration;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSynchronizerKt;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.migration.SettingsRepositoryToSettingsSyncMigration;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0019\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000eH\u0003J\b\u0010!\u001a\u00020\u0010H\u0003R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer;", "Lcom/intellij/ide/ApplicationInitializedListener;", "Lcom/intellij/openapi/application/ApplicationActivationListener;", "Lcom/intellij/settingsSync/SettingsSyncEnabledStateListener;", "Lcom/intellij/settingsSync/SettingsSyncCategoriesChangeListener;", "()V", "autoSyncDelay", "", "getAutoSyncDelay", "()J", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "applicationActivated", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "applicationDeactivated", "categoriesStateChanged", "enabledStateChanged", "syncEnabled", "", "execute", "asyncScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeSyncing", "Ljava/lang/Runnable;", "initMode", "Lcom/intellij/settingsSync/SettingsSyncBridge$InitMode;", "setupSyncingByTimer", "stopSyncingByTimer", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/SettingsSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n10#2:139\n*S KotlinDebug\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/SettingsSynchronizer\n*L\n113#1:139\n*E\n"})
public final class SettingsSynchronizer
implements ApplicationInitializedListener,
ApplicationActivationListener,
SettingsSyncEnabledStateListener,
SettingsSyncCategoriesChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledExecutorService executorService;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ExtensionPointName<SettingsSyncMigration> MIGRATION_EP;

    public SettingsSynchronizer() {
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Settings Sync Update", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledEx\u2026Settings Sync Update\", 1)");
        this.executorService = scheduledExecutorService;
    }

    private final long getAutoSyncDelay() {
        return Registry.intValue((String)"settingsSync.autoSync.frequency.sec", (int)60);
    }

    @Nullable
    public Object execute(@NotNull CoroutineScope asyncScope, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SettingsSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (ApplicationManager.getApplication().isHeadlessEnvironment() || !SettingsSyncMainKt.isSettingsSyncEnabledByKey()) {
                    return;
                }
                SettingsSyncEvents.addEnabledStateChangeListener$default(SettingsSyncEvents.Companion.getInstance(), this.this$0, null, 2, null);
                if (SettingsSyncMainKt.isSettingsSyncEnabledInSettings()) {
                    SettingsSynchronizer.access$getExecutorService$p(this.this$0).schedule(SettingsSynchronizer.access$initializeSyncing(this.this$0, SettingsSyncBridge.InitMode.JustInit.INSTANCE), 0L, TimeUnit.SECONDS);
                    return;
                }
                if (!SettingsSyncSettings.Companion.getInstance().getMigrationFromOldStorageChecked()) {
                    Object v1;
                    block6: {
                        SettingsSyncSettings.Companion.getInstance().setMigrationFromOldStorageChecked(true);
                        Iterable $this$firstOrNull$iv = SettingsSynchronizer.access$getMIGRATION_EP$cp().getExtensionList();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            SettingsSyncMigration it = (SettingsSyncMigration)element$iv;
                            boolean bl = false;
                            Path path = PathManager.getConfigDir();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir()");
                            if (!it.isLocalDataAvailable(path)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    SettingsSyncMigration migration = v1;
                    if (migration != null) {
                        SettingsSynchronizer.access$getLOG$cp().info("Found migration from an old storage via " + migration.getClass().getSimpleName());
                        SettingsSynchronizer.access$getExecutorService$p(this.this$0).schedule(SettingsSynchronizer.access$initializeSyncing(this.this$0, new SettingsSyncBridge.InitMode.MigrateFromOldStorage(migration)), 0L, TimeUnit.SECONDS);
                        SettingsSyncEventsStatistics.Companion.getMIGRATED_FROM_OLD_PLUGIN().log();
                    } else {
                        SettingsRepositoryToSettingsSyncMigration.Companion.migrateIfNeeded(SettingsSynchronizer.access$getExecutorService$p(this.this$0));
                    }
                }
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        if (!(SettingsSyncMainKt.isSettingsSyncEnabledByKey() && SettingsSyncMainKt.isSettingsSyncEnabledInSettings() && SettingsSyncMain.Companion.isAvailable())) {
            return;
        }
        if (this.getAutoSyncDelay() > 0L && this.scheduledFuture == null) {
            this.scheduledFuture = this.setupSyncingByTimer();
        }
        if (Registry.is((String)"settingsSync.autoSync.on.focus", (boolean)true)) {
            Companion.syncSettings$intellij_settingsSync();
        }
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        this.stopSyncingByTimer();
    }

    private final Runnable initializeSyncing(SettingsSyncBridge.InitMode initMode) {
        return () -> SettingsSynchronizer.initializeSyncing$lambda$0(initMode, this);
    }

    @Override
    public void enabledStateChanged(boolean syncEnabled) {
        if (syncEnabled) {
            SettingsSyncEvents.Companion.getInstance().addCategoriesChangeListener(this);
        } else {
            SettingsSyncEvents.Companion.getInstance().removeCategoriesChangeListener(this);
            this.stopSyncingByTimer();
            SettingsSyncMain.Companion.getInstance().disableSyncing();
        }
    }

    @Override
    public void categoriesStateChanged() {
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.LogCurrentSettings.INSTANCE);
    }

    @RequiresEdt
    private final ScheduledFuture<?> setupSyncingByTimer() {
        long delay = this.getAutoSyncDelay();
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleWithFixedDelay(SettingsSynchronizer::setupSyncingByTimer$lambda$1, delay, delay, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executorService.schedule\u2026 delay, TimeUnit.SECONDS)");
        return scheduledFuture;
    }

    @RequiresEdt
    private final void stopSyncingByTimer() {
        if (this.scheduledFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    private static final void initializeSyncing$lambda$0(SettingsSyncBridge.InitMode $initMode, SettingsSynchronizer this$0) {
        Intrinsics.checkNotNullParameter((Object)$initMode, (String)"$initMode");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Initializing settings sync");
        SettingsSyncMain settingsSyncMain = SettingsSyncMain.Companion.getInstance();
        settingsSyncMain.getControls().getBridge().initialize$intellij_settingsSync($initMode);
        SettingsSyncEvents.Companion.getInstance().addCategoriesChangeListener(this$0);
        Companion.syncSettings$intellij_settingsSync();
        LocalHostNameProvider.Companion.initialize();
    }

    private static final void setupSyncingByTimer$lambda$1() {
        LOG.debug("Syncing settings by timer");
        Companion.syncSettings$intellij_settingsSync();
    }

    public static final /* synthetic */ ScheduledExecutorService access$getExecutorService$p(SettingsSynchronizer $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ Runnable access$initializeSyncing(SettingsSynchronizer $this, SettingsSyncBridge.InitMode initMode) {
        return $this.initializeSyncing(initMode);
    }

    public static final /* synthetic */ ExtensionPointName access$getMIGRATION_EP$cp() {
        return MIGRATION_EP;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        MIGRATION_EP = ExtensionPointName.Companion.create("com.intellij.settingsSyncMigration");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\r\u0010\r\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MIGRATION_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/settingsSync/SettingsSyncMigration;", "checkCrossIdeSyncStatusOnServer", "", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "checkCrossIdeSyncStatusOnServer$intellij_settingsSync", "syncSettings", "syncSettings$intellij_settingsSync", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public final void syncSettings$intellij_settingsSync() {
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.SyncRequest.INSTANCE);
        }

        public final void checkCrossIdeSyncStatusOnServer$intellij_settingsSync(@NotNull SettingsSyncRemoteCommunicator remoteCommunicator) {
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            try {
                boolean crossIdeSyncEnabled = remoteCommunicator.isFileExists("cross-ide-sync-enabled");
                if (crossIdeSyncEnabled != SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()) {
                    LOG.info("Cross-IDE sync status on server is: " + SettingsSynchronizerKt.enabledOrDisabled(crossIdeSyncEnabled) + ". Updating local settings with it.");
                    SettingsSyncLocalSettings.Companion.getInstance().setCrossIdeSyncEnabled(crossIdeSyncEnabled);
                }
            }
            catch (Throwable e) {
                LOG.error("Couldn't check if cross-ide-sync-enabled exists", e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

