/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.migration;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEventsStatistics;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.migration.SettingsRepositoryToSettingsSyncMigration;
import com.intellij.settingsSync.plugins.PluginManagerProxy;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J3\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u0001H\n0\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigration;", "", "()V", "getLocalDataIfAvailable", "Lcom/intellij/settingsSync/SettingsSnapshot;", "appConfigDir", "Ljava/nio/file/Path;", "isLocalDataAvailable", "", "processLocalData", "T", "processor", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readLocalData", "settingsRepositoryConfigPath", "showNotificationAboutUnbundling", "", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsRepositoryToSettingsSyncMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsRepositoryToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n10#2:165\n*S KotlinDebug\n*F\n+ 1 SettingsRepositoryToSettingsSyncMigration.kt\ncom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigration\n*L\n121#1:165\n*E\n"})
public final class SettingsRepositoryToSettingsSyncMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> SPECIAL_FILES;
    @NotNull
    private static final List<Pair<String, String>> OS_PREFIXES;

    @Nullable
    public final SettingsSnapshot getLocalDataIfAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        return (SettingsSnapshot)this.processLocalData(appConfigDir, (Function1)new Function1<Path, SettingsSnapshot>(this){
            final /* synthetic */ SettingsRepositoryToSettingsSyncMigration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final SettingsSnapshot invoke(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return SettingsRepositoryToSettingsSyncMigration.access$readLocalData(this.this$0, path);
            }
        });
    }

    public final boolean isLocalDataAvailable(@NotNull Path appConfigDir) {
        Intrinsics.checkNotNullParameter((Object)appConfigDir, (String)"appConfigDir");
        if (PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)"org.jetbrains.settingsRepository"))) {
            return false;
        }
        return this.processLocalData(appConfigDir, isLocalDataAvailable.1.INSTANCE) != null;
    }

    private final <T> T processLocalData(Path appConfigDir, Function1<? super Path, ? extends T> processor) {
        try {
            Path path = appConfigDir.resolve("settingsRepository");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
            Path path2 = path.resolve("repository");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
            Path configPath = path2;
            Path path3 = configPath.resolve(".git");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
            Path repositoryPath = path3;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(repositoryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return (T)processor.invoke((Object)configPath);
            }
            LOG.info("No data from settingsRepository in 'settingsRepository' folder => no migration needed");
        }
        catch (Exception e) {
            LOG.error("Could not read data from settings repository => no migration ", (Throwable)e);
        }
        return null;
    }

    private final SettingsSnapshot readLocalData(Path settingsRepositoryConfigPath) {
        Set fileStates2 = new LinkedHashSet();
        Files.list(settingsRepositoryConfigPath).forEach(arg_0 -> SettingsRepositoryToSettingsSyncMigration.readLocalData$lambda$0((Function1)new Function1<Path, Unit>(settingsRepositoryConfigPath, (Set<FileState>)fileStates2){
            final /* synthetic */ Path $settingsRepositoryConfigPath;
            final /* synthetic */ Set<FileState> $fileStates;
            {
                this.$settingsRepositoryConfigPath = $settingsRepositoryConfigPath;
                this.$fileStates = $fileStates;
                super(1);
            }

            public final void invoke(Path topLevelFile) {
                Object v0;
                block2: {
                    Iterable iterable = SettingsRepositoryToSettingsSyncMigration.access$getOS_PREFIXES$cp();
                    for (T t : iterable) {
                        Pair it = (Pair)t;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)topLevelFile, (String)"topLevelFile");
                        if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)topLevelFile), (String)((String)it.getFirst()), (boolean)false, (int)2, null)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                Pair prefix = v0;
                List list = SettingsRepositoryToSettingsSyncMigration.access$getSPECIAL_FILES$cp();
                Intrinsics.checkNotNullExpressionValue((Object)topLevelFile, (String)"topLevelFile");
                if (!list.contains(PathsKt.getName((Path)topLevelFile))) {
                    Files.walkFileTree(topLevelFile, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this.$settingsRepositoryConfigPath, (Pair<String, String>)prefix, topLevelFile, this.$fileStates){
                        final /* synthetic */ Path $settingsRepositoryConfigPath;
                        final /* synthetic */ Pair<String, String> $prefix;
                        final /* synthetic */ Path $topLevelFile;
                        final /* synthetic */ Set<FileState> $fileStates;
                        {
                            this.$settingsRepositoryConfigPath = $settingsRepositoryConfigPath;
                            this.$prefix = $prefix;
                            this.$topLevelFile = $topLevelFile;
                            this.$fileStates = $fileStates;
                        }

                        @NotNull
                        public FileVisitResult visitFile(@NotNull Path file, @Nullable BasicFileAttributes attrs) {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            if (!PathKt.isFile((Path)file)) {
                                return FileVisitResult.CONTINUE;
                            }
                            Path path = this.$settingsRepositoryConfigPath.relativize(file);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsRepositoryConfigPath.relativize(file)");
                            String relative = PathsKt.getInvariantSeparatorsPathString((Path)path);
                            String relativeWithFixedPrefix = this.$prefix != null ? StringsKt.replaceFirst$default((String)relative, (String)((String)this.$prefix.getFirst()), (String)((String)this.$prefix.getSecond()), (boolean)false, (int)4, null) : relative;
                            String fileSpec = this.$prefix != null || Intrinsics.areEqual((Object)file, (Object)this.$topLevelFile) ? "options/" + relativeWithFixedPrefix : relativeWithFixedPrefix;
                            byte[] byArray = Files.readAllBytes(file);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
                            byte[] content = byArray;
                            ((Collection)this.$fileStates).add(new FileState.Modified(fileSpec, content));
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
        }, arg_0));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), fileStates2, null, MapsKt.emptyMap(), SetsKt.emptySet());
    }

    private final void showNotificationAboutUnbundling(ScheduledExecutorService executorService) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.action.install.settings.repository", new Object[0]), SettingsRepositoryToSettingsSyncMigration::showNotificationAboutUnbundling$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(\n  \u2026ETTINGS_REPOSITORY)\n    }");
        NotificationAction installOldPluginAction = notificationAction;
        NotificationAction notificationAction2 = NotificationAction.createSimpleExpiring((String)SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.action.use.new.settings.sync", new Object[0]), () -> SettingsRepositoryToSettingsSyncMigration.showNotificationAboutUnbundling$lambda$3(executorService));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction2, (String)"createSimpleExpiring(\n  \u2026_NEW_SETTINGS_SYNC)\n    }");
        NotificationAction useNewSettingsSyncAction = notificationAction2;
        NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.title", new Object[0]), SettingsSyncBundle.INSTANCE.message("settings.repository.unbundled.notification.description", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)installOldPluginAction).addAction((AnAction)useNewSettingsSyncAction).notify(null);
    }

    private static final void readLocalData$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showNotificationAboutUnbundling$lambda$1() {
        PluginManagerProxy.Companion.getInstance().createInstaller(true).installPlugins(CollectionsKt.listOf((Object)PluginId.getId((String)"org.jetbrains.settingsRepository")));
        SettingsSyncEventsStatistics.Companion.getSETTINGS_REPOSITORY_NOTIFICATION_ACTION().log((Object)SettingsSyncEventsStatistics.SettingsRepositoryMigrationNotificationAction.INSTALL_SETTINGS_REPOSITORY);
    }

    private static final void showNotificationAboutUnbundling$lambda$3$lambda$2() {
        SettingsSyncMain.Companion.getInstance().getControls().getBridge().initialize$intellij_settingsSync(SettingsSyncBridge.InitMode.PushToServer.INSTANCE);
    }

    private static final void showNotificationAboutUnbundling$lambda$3(ScheduledExecutorService $executorService) {
        Intrinsics.checkNotNullParameter((Object)$executorService, (String)"$executorService");
        SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
        $executorService.submit(SettingsRepositoryToSettingsSyncMigration::showNotificationAboutUnbundling$lambda$3$lambda$2);
        SettingsSyncEventsStatistics.Companion.getSETTINGS_REPOSITORY_NOTIFICATION_ACTION().log((Object)SettingsSyncEventsStatistics.SettingsRepositoryMigrationNotificationAction.USE_NEW_SETTINGS_SYNC);
    }

    public static final /* synthetic */ SettingsSnapshot access$readLocalData(SettingsRepositoryToSettingsSyncMigration $this, Path settingsRepositoryConfigPath) {
        return $this.readLocalData(settingsRepositoryConfigPath);
    }

    public static final /* synthetic */ List access$getOS_PREFIXES$cp() {
        return OS_PREFIXES;
    }

    public static final /* synthetic */ List access$getSPECIAL_FILES$cp() {
        return SPECIAL_FILES;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsRepositoryToSettingsSyncMigration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        Object[] objectArray = new String[]{".git", "config.json"};
        SPECIAL_FILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"_mac", (Object)"mac"), TuplesKt.to((Object)"_windows", (Object)"windows"), TuplesKt.to((Object)"_linux", (Object)"linux"), TuplesKt.to((Object)"_freebsd", (Object)"freebsd"), TuplesKt.to((Object)"_unix", (Object)"unix")};
        OS_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/migration/SettingsRepositoryToSettingsSyncMigration$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "OS_PREFIXES", "", "Lkotlin/Pair;", "", "SPECIAL_FILES", "backupCurrentConfig", "", "migrateIfNeeded", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public final void migrateIfNeeded(@NotNull ScheduledExecutorService executorService) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            if (PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)"org.jetbrains.settingsRepository"))) {
                return;
            }
            SettingsRepositoryToSettingsSyncMigration settingsRepositoryMigration = new SettingsRepositoryToSettingsSyncMigration();
            Path path = PathManager.getConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir()");
            if (settingsRepositoryMigration.isLocalDataAvailable(path)) {
                LOG.info("Migrating from the Settings Repository");
                executorService.schedule(() -> Companion.migrateIfNeeded$lambda$0(settingsRepositoryMigration, executorService), 0L, TimeUnit.SECONDS);
            }
        }

        private final void backupCurrentConfig() {
            Path path = PathManager.getConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir()");
            Path configDir = path;
            File file = FileUtil.createTempDirectory((String)((Object)configDir.getFileName()).toString(), (String)("-backup-" + UUID.randomUUID()));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(conf\u2026up-\" + UUID.randomUUID())");
            File tempBackupDir = file;
            LOG.info("Backup config from " + configDir + " to " + tempBackupDir);
            FileUtil.copyDir((File)configDir.toFile(), (File)tempBackupDir);
            Path path2 = PathManager.getConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir()");
            new ConfigBackup(path2).moveToBackup(tempBackupDir);
        }

        private static final void migrateIfNeeded$lambda$0(SettingsRepositoryToSettingsSyncMigration $settingsRepositoryMigration, ScheduledExecutorService $executorService) {
            Intrinsics.checkNotNullParameter((Object)$settingsRepositoryMigration, (String)"$settingsRepositoryMigration");
            Intrinsics.checkNotNullParameter((Object)$executorService, (String)"$executorService");
            Path path = PathManager.getConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir()");
            SettingsSnapshot snapshot = $settingsRepositoryMigration.getLocalDataIfAvailable(path);
            if (snapshot != null) {
                Companion.backupCurrentConfig();
                TemplateSettings.getInstance();
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
                Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
                Path path2 = PathManager.getConfigDir();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir()");
                new SettingsSyncIdeMediatorImpl(componentStoreImpl, path2, (Function0<Boolean>)((Function0)migrateIfNeeded.1.1.INSTANCE)).applyToIde(snapshot, null);
                $settingsRepositoryMigration.showNotificationAboutUnbundling($executorService);
                SettingsSyncEventsStatistics.Companion.getMIGRATED_FROM_SETTINGS_REPOSITORY().log();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

