/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaCreatePropertyFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidPropertyKeyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "UnresolvedPropertyKey";
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(1);
        }
        return InvalidPropertyKeyInspection.checkElement((PsiElement)method, manager, isOnTheFly);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(3);
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        SmartList result = new SmartList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] descriptors = InvalidPropertyKeyInspection.checkElement((PsiElement)initializer.getBody(), manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll((Collection)result, (Object[])descriptors);
        }
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            InvalidPropertyKeyInspection.$$$reportNull$$$0(5);
        }
        SmartList result = new SmartList();
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)field.getInitializer());
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)field.getModifierList());
        if (field instanceof PsiEnumConstant) {
            InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, (List<? super ProblemDescriptor>)result, (PsiElement)((PsiEnumConstant)field).getArgumentList());
        }
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void appendProblems(InspectionManager manager, boolean isOnTheFly, List<? super ProblemDescriptor> result, PsiElement element) {
        ProblemDescriptor[] descriptors;
        if (element != null && (descriptors = InvalidPropertyKeyInspection.checkElement(element, manager, isOnTheFly)) != null) {
            Collections.addAll(result, descriptors);
        }
    }

    private static ProblemDescriptor @Nullable [] checkElement(PsiElement element, InspectionManager manager, boolean onTheFly) {
        UnresolvedPropertyVisitor visitor = new UnresolvedPropertyVisitor(manager, onTheFly);
        element.accept((PsiElementVisitor)visitor);
        Map<PsiElement, ProblemDescriptor> problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.values().toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UnresolvedPropertyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final InspectionManager myManager;
        private final Map<PsiElement, ProblemDescriptor> myProblems = new HashMap<PsiElement, ProblemDescriptor>();
        private final boolean onTheFly;

        UnresolvedPropertyVisitor(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.onTheFly = onTheFly;
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            PsiExpressionList argList;
            if (aClass == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(0);
            }
            if ((argList = aClass.getArgumentList()) != null) {
                argList.accept((PsiElementVisitor)this);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(1);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(2);
            }
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(3);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(4);
            }
            super.visitReferenceExpression(expression);
            if (UnresolvedPropertyVisitor.isComputedPropertyExpression((PsiExpression)expression)) {
                return;
            }
            PsiElement resolvedExpression = expression.resolve();
            if (resolvedExpression instanceof PsiField) {
                PsiExpression highlightedExpression;
                PsiExpression initializer;
                PsiField field = (PsiField)resolvedExpression;
                if (!field.hasModifierProperty("final")) {
                    return;
                }
                if (field.getContainingFile() == expression.getContainingFile()) {
                    highlightedExpression = initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)field.getInitializer());
                } else {
                    initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)PsiFieldImpl.getDetachedInitializer((PsiVariable)field));
                    highlightedExpression = expression;
                }
                String key = UnresolvedPropertyVisitor.computeStringValue(initializer);
                this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, key, highlightedExpression);
            } else if (resolvedExpression instanceof PsiLocalVariable) {
                this.checkLocalVariable((PsiLocalVariable)resolvedExpression, expression);
            }
        }

        private void checkLocalVariable(@NotNull PsiLocalVariable variable, PsiReferenceExpression expression) {
            PsiElement[] defs;
            PsiCodeBlock block;
            if (variable == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(5);
            }
            if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
                return;
            }
            for (PsiElement def : defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)expression)) {
                PsiAssignmentExpression assignment;
                if (def instanceof PsiLocalVariable) {
                    PsiExpression initializer = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiLocalVariable)def).getInitializer());
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(initializer), initializer);
                    continue;
                }
                if (!(def instanceof PsiReferenceExpression) || (assignment = ExpressionUtils.getAssignment((PsiElement)def.getParent())) == null || assignment.getLExpression() != def) continue;
                PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)assignment.getRExpression());
                if (rhs instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)rhs;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(thenExpression), thenExpression);
                    this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(elseExpression), elseExpression);
                    continue;
                }
                this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue(rhs), rhs);
            }
        }

        private static String computeStringValue(PsiExpression expression) {
            Object value;
            if (expression instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)expression).getValue()) instanceof String) {
                return (String)value;
            }
            return null;
        }

        private void visitPropertyKeyAnnotationParameter(PsiExpression expression, String key, PsiExpression highlightedExpression) {
            block8: {
                PsiElement manager;
                Ref resourceBundleName;
                block9: {
                    List propFiles;
                    block7: {
                        if (key == null) {
                            return;
                        }
                        resourceBundleName = new Ref();
                        if (JavaI18nUtil.isValidPropertyReference(this.myManager.getProject(), expression, key, (Ref<? super String>)resourceBundleName)) break block7;
                        String bundleName = (String)resourceBundleName.get();
                        if (bundleName == null) break block8;
                        UnresolvedPropertyVisitor.appendPropertyKeyNotFoundProblem(bundleName, key, highlightedExpression, this.myManager, this.myProblems, this.onTheFly);
                        break block8;
                    }
                    PsiElement bundleName = expression.getParent();
                    if (!(bundleName instanceof PsiNameValuePair)) break block9;
                    PsiNameValuePair nvp = (PsiNameValuePair)bundleName;
                    if (!Objects.equals(nvp.getName(), "resourceBundle")) break block8;
                    manager = PropertiesReferenceManager.getInstance((Project)expression.getProject());
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
                    if (module != null && (propFiles = manager.findPropertiesFiles(module, key)).isEmpty()) {
                        String description = JavaI18nBundle.message("inspection.invalid.resource.bundle.reference", key);
                        ProblemDescriptor problem = this.myManager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.onTheFly);
                        this.myProblems.putIfAbsent((PsiElement)expression, problem);
                    }
                    break block8;
                }
                manager = expression.getParent();
                if (manager instanceof PsiExpressionList) {
                    PsiExpressionList expressions = (PsiExpressionList)manager;
                    if (expression.getParent().getParent() instanceof PsiMethodCallExpression) {
                        if (!JavaI18nUtil.mustBePropertyKey(expression, null)) {
                            return;
                        }
                        SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(highlightedExpression, (String)resourceBundleName.get());
                        if (paramsCount.isEmpty() || paramsCount.size() != 1 && resourceBundleName.get() == null) {
                            return;
                        }
                        int maxParamCount = paramsCount.last();
                        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expressions.getParent();
                        PsiMethod method = methodCall.resolveMethod();
                        PsiExpression[] args = expressions.getExpressions();
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] != expression) continue;
                            if (i + maxParamCount < args.length || method == null || method.getParameterList().getParametersCount() != i + 2 || !Objects.requireNonNull(method.getParameterList().getParameter(i + 1)).isVarArgs() || UnresolvedPropertyVisitor.hasArrayTypeAt(i + 1, methodCall)) break;
                            this.myProblems.putIfAbsent((PsiElement)methodCall, this.myManager.createProblemDescriptor((PsiElement)methodCall, JavaI18nBundle.message("property.has.more.parameters.than.passed", key, maxParamCount, args.length - i - 1), this.onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
                            break;
                        }
                    }
                }
            }
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(6);
            }
            if (UnresolvedPropertyVisitor.isComputedPropertyExpression((PsiExpression)expression)) {
                return;
            }
            this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, UnresolvedPropertyVisitor.computeStringValue((PsiExpression)expression), (PsiExpression)expression);
        }

        private static void appendPropertyKeyNotFoundProblem(@NotNull String bundleName, @NotNull String key, @NotNull PsiExpression expression, @NotNull InspectionManager manager, @NotNull Map<PsiElement, ProblemDescriptor> problems, boolean onTheFly) {
            if (bundleName == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(7);
            }
            if (key == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(8);
            }
            if (expression == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(9);
            }
            if (manager == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(10);
            }
            if (problems == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(11);
            }
            String description = JavaI18nBundle.message("inspection.unresolved.property.key.reference.message", key);
            List<PropertiesFile> propertiesFiles = UnresolvedPropertyVisitor.filterNotInLibrary(expression.getProject(), I18nUtil.propertiesFilesByBundleName((String)bundleName, (PsiElement)expression));
            if (problems.containsKey(expression)) {
                return;
            }
            problems.put((PsiElement)expression, manager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)(propertiesFiles.isEmpty() ? null : new JavaCreatePropertyFix((PsiElement)expression, key, propertiesFiles)), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
        }

        @NotNull
        private static List<PropertiesFile> filterNotInLibrary(@NotNull Project project, @NotNull List<? extends PropertiesFile> propertiesFiles) {
            if (project == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(12);
            }
            if (propertiesFiles == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(13);
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>(propertiesFiles.size());
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (fileIndex.isInLibrary(propertiesFile.getVirtualFile())) continue;
                result.add(propertiesFile);
            }
            ArrayList<PropertiesFile> arrayList = result;
            if (arrayList == null) {
                UnresolvedPropertyVisitor.$$$reportNull$$$0(14);
            }
            return arrayList;
        }

        private static boolean hasArrayTypeAt(int i, PsiMethodCallExpression methodCall) {
            return methodCall != null && methodCall.getArgumentList().getExpressionTypes().length > i && methodCall.getArgumentList().getExpressionTypes()[i] instanceof PsiArrayType;
        }

        private static boolean isComputedPropertyExpression(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression && (expression == ((PsiConditionalExpression)parent).getThenExpression() || expression == ((PsiConditionalExpression)parent).getElseExpression())) {
                expression = (PsiExpression)parent;
                parent = expression.getParent();
            }
            return parent instanceof PsiExpression;
        }

        public Map<PsiElement, ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesFiles";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterNotInLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAnonymousClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassInitializer";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "checkLocalVariable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLiteralExpression";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "appendPropertyKeyNotFoundProblem";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "filterNotInLibrary";
                    break;
                }
                case 14: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 14 -> new IllegalStateException(string);
            };
        }
    }
}

