/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFoldingSettings;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleContextFoldingBuilder
extends FoldingBuilderEx {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!PropertiesFoldingSettings.getInstance().isFoldPlaceholdersToContext()) {
            if (FoldingDescriptor.EMPTY_ARRAY == null) {
                ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        for (IProperty property : ((PropertiesFile)root).getProperties()) {
            String value = property.getValue();
            if (value == null || !value.contains("{0}")) continue;
            ResourceBundleContextFoldingBuilder.fold(property, result);
        }
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    private static void fold(@NotNull IProperty property, @NotNull List<? super FoldingDescriptor> result) {
        if (property == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (result == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> ReferencesSearch.search((PsiElement)property.getPsiElement()).forEach(reference -> !ResourceBundleContextFoldingBuilder.tryToFoldReference(reference, property, result)), ResourceBundleContextFoldingBuilder.getOrCreateIndicator());
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
            progress.start();
        }
        progress.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(6);
        }
        return progressIndicator;
    }

    private static boolean tryToFoldReference(@NotNull PsiReference reference, @NotNull IProperty property, @NotNull List<? super FoldingDescriptor> result) {
        PsiElement[] arguments;
        if (reference == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (property == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (result == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(9);
        }
        int before = result.size();
        PsiElement referenceElement = reference.getElement();
        String key = property.getUnescapedKey();
        if (key == null) {
            return false;
        }
        PsiElement psiElement = property.getPsiElement();
        String text = psiElement.getText();
        PsiElement[] psiElementArray = arguments = referenceElement.getLanguage().getID().equals("kotlin") ? ResourceBundleContextFoldingBuilder.getKotlinArguments(referenceElement) : ResourceBundleContextFoldingBuilder.getJavaArguments(referenceElement);
        if (arguments == null) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement argument = arguments[i];
            String templateText = "{" + i + "}";
            int offset = text.indexOf(templateText, key.length());
            if (offset == -1) continue;
            int start = psiElement.getTextRange().getStartOffset();
            result.add((FoldingDescriptor)new FoldingDescriptor(psiElement, start + offset, start + offset + templateText.length(), null, argument.getText()));
        }
        return result.size() != before;
    }

    private static PsiElement[] getJavaArguments(@NotNull PsiElement referenceElement) {
        PsiExpression expression;
        if (referenceElement == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiExpression.class, (boolean)false)) == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return null;
        }
        Object[] arguments = ((PsiExpressionList)parent).getExpressions();
        int i = ArrayUtil.indexOf((Object[])arguments, (Object)expression);
        if (i == -1) {
            return null;
        }
        return (PsiElement[])Arrays.copyOfRange(arguments, i + 1, arguments.length, PsiElement[].class);
    }

    private static PsiElement[] getKotlinArguments(@NotNull PsiElement referenceElement) {
        PsiElement expression;
        if (referenceElement == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((expression = referenceElement.getParent()) == null) {
            return null;
        }
        ArrayList<PsiElement> arguments = new ArrayList<PsiElement>();
        for (PsiElement e = expression.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiComment || e instanceof LeafPsiElement) continue;
            arguments.add(e);
        }
        if (arguments.isEmpty()) {
            return null;
        }
        return arguments.toArray(PsiElement.EMPTY_ARRAY);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            ResourceBundleContextFoldingBuilder.$$$reportNull$$$0(13);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/ResourceBundleContextFoldingBuilder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleContextFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fold";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToFoldReference";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJavaArguments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinArguments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

