/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.debugger.engine.MockDebugProcess;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaRunner;
import com.intellij.debugger.engine.dfaassist.DfaAssist;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.mockJDI.MockStackFrame;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import com.sun.jdi.StackFrame;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class DfaAssistTest
extends LightPlatformCodeInsightTestCase {
    protected void doTest(String text, BiConsumer<? super MockVirtualMachine, ? super MockStackFrame> mockValues, String fileName) {
        this.doTest(text, mockValues, fileName, "");
    }

    protected void doTest(String text, BiConsumer<? super MockVirtualMachine, ? super MockStackFrame> mockValues, String fileName, @Nullable String context2) {
        String filteredText = text.replaceAll("/\\*\\w+\\*/", "");
        this.configureFromFileText(fileName, filteredText);
        PsiFile file2 = this.getFile();
        int offset = this.getEditor().getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        DfaAssistTest.assertNotNull((String)context2, (Object)element);
        MockVirtualMachine vm = new MockVirtualMachine();
        final MockStackFrame frame2 = new MockStackFrame(vm, element);
        mockValues.accept(vm, frame2);
        final Ref runnerRef = Ref.create();
        final MockDebugProcess process = new MockDebugProcess(this.getProject(), vm, this.getTestRootDisposable());
        final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element);
        process.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

            protected void action() {
                ThreadReferenceProxyImpl threadProxy = (ThreadReferenceProxyImpl)ContainerUtil.getFirstItem((Collection)process.getVirtualMachineProxy().allThreads());
                StackFrameProxyImpl frameProxy = new StackFrameProxyImpl(threadProxy, (StackFrame)frame2, 1);
                DebuggerDfaRunner runner = DfaAssist.createDfaRunner((StackFrameProxyEx)frameProxy, (SmartPsiElementPointer)pointer);
                runnerRef.set((Object)runner);
            }
        });
        DebuggerDfaRunner runner = (DebuggerDfaRunner)runnerRef.get();
        DfaAssistTest.assertNotNull((String)context2, (Object)runner);
        DfaResult dfaResult = runner.computeHints();
        Map hints = dfaResult.hints;
        String fileText = filteredText.replace("<caret>", "");
        EntryStream hintStream = EntryStream.of((Map)hints).mapKeys(ex -> ex.getTextRange().getEndOffset()).mapValues(hint -> "/*" + hint + "*/");
        EntryStream unreachableStream = StreamEx.of((Collection)dfaResult.unreachable).flatMapToEntry(range -> Map.of(range.getStartOffset(), "/*unreachable_start*/", range.getEndOffset(), "/*unreachable_end*/"));
        String result2 = ((StreamEx)((EntryStream)((EntryStream)hintStream.append((Stream)unreachableStream)).sorted(Map.Entry.comparingByKey())).prepend((Object)0, (Object)"").append((Object)fileText.length(), (Object)"").chain(StreamEx::of)).pairMap((prev, next) -> StreamEx.of((Object[])new String[]{fileText.substring((Integer)prev.getKey(), (Integer)next.getKey()), (String)next.getValue()})).flatMap(Function.identity()).joining();
        String expectedText = text.replace("<caret>", "");
        DfaAssistTest.assertEquals((String)context2, (String)expectedText, (String)result2);
    }
}

