/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.ThrowableRunnable;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class LoggedErrorProcessor {
    private static LoggedErrorProcessor ourInstance = new LoggedErrorProcessor();

    @NotNull
    static LoggedErrorProcessor getInstance() {
        LoggedErrorProcessor loggedErrorProcessor = ourInstance;
        if (loggedErrorProcessor == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(0);
        }
        return loggedErrorProcessor;
    }

    public static <T extends Throwable> void executeWith(@NotNull LoggedErrorProcessor newInstance, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (newInstance == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(2);
        }
        LoggedErrorProcessor oldInstance = LoggedErrorProcessor.getInstance();
        ourInstance = newInstance;
        try {
            runnable.run();
        }
        finally {
            ourInstance = oldInstance;
        }
    }

    @NotNull
    public static Throwable executeAndReturnLoggedError(@NotNull Runnable runnable) {
        if (runnable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(3);
        }
        final AtomicReference error2 = new AtomicReference();
        LoggedErrorProcessor.executeWith(new LoggedErrorProcessor(){

            @Override
            public boolean processError(@NotNull String category, @NotNull String message, Throwable t, String @NotNull [] details) {
                if (category == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (details == null) {
                    1.$$$reportNull$$$0(2);
                }
                Assert.assertNotNull((String)("Unexpected error without Throwable: " + message), (Object)t);
                if (!error2.compareAndSet(null, t)) {
                    Assert.fail((String)("Multiple errors were reported: " + ((Throwable)error2.get()).getMessage() + " and " + t.getMessage()));
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "category";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "details";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/LoggedErrorProcessor$1";
                objectArray[2] = "processError";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, () -> runnable.run());
        Throwable result2 = (Throwable)error2.get();
        Assert.assertNotNull((String)"No errors were logged", (Object)result2);
        Throwable throwable = result2;
        if (throwable == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(4);
        }
        return throwable;
    }

    public boolean processWarn(@NotNull String category, @NotNull String message, @Nullable Throwable t) {
        if (category == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(5);
        }
        if (message == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public Set<Action> processError(@NotNull String category, @NotNull String message, String @NotNull [] details, @Nullable Throwable t) {
        boolean process;
        if (category == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(7);
        }
        if (message == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(8);
        }
        if (details == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(9);
        }
        EnumSet<Action> enumSet = (process = this.processError(category, message, t, details)) ? Action.ALL : Action.NONE;
        if (enumSet == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(10);
        }
        return enumSet;
    }

    @Deprecated(forRemoval=true)
    public boolean processError(@NotNull String category, @NotNull String message, @Nullable Throwable t, String @NotNull [] details) {
        if (category == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(11);
        }
        if (message == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(12);
        }
        if (details == null) {
            LoggedErrorProcessor.$$$reportNull$$$0(13);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LoggedErrorProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndReturnLoggedError";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processError";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeWith";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeAndReturnLoggedError";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processWarn";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    public static enum Action {
        LOG,
        STDERR,
        RETHROW;

        public static final EnumSet<Action> ALL;
        public static final EnumSet<Action> NONE;

        static {
            ALL = EnumSet.allOf(Action.class);
            NONE = EnumSet.noneOf(Action.class);
        }
    }
}

