/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestSourceBasedTestCase
extends JavaProjectTestCase {
    private Path myTempDirectory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VirtualFile tempDir = this.getTempDir().createVirtualDir();
        this.myTempDirectory = tempDir.toNioPath();
        String testPath = this.getTestPath();
        if (testPath != null) {
            File testRoot = new File(this.getTestDataPath(), testPath);
            TestSourceBasedTestCase.assertTrue((String)testRoot.getAbsolutePath(), (boolean)testRoot.isDirectory());
            File currentTestRoot = new File(testRoot, this.getTestDirectoryName());
            TestSourceBasedTestCase.assertTrue((String)currentTestRoot.getAbsolutePath(), (boolean)currentTestRoot.isDirectory());
            FileUtil.copyDir((File)currentTestRoot, (File)this.myTempDirectory.resolve(this.getTestDirectoryName()).toFile());
            tempDir.refresh(false, true);
            ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFile contentRoot = tempDir.findChild(this.getTestDirectoryName());
                PsiTestUtil.addContentRoot(this.myModule, contentRoot);
                VirtualFile src = contentRoot.findChild("src");
                if (src != null) {
                    PsiTestUtil.addSourceRoot(this.myModule, src);
                }
            });
        }
        ProjectViewTestUtil.setupImpl(this.getProject(), true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath(((Object)((Object)this)).getClass());
    }

    @Nullable
    protected abstract String getTestPath();

    protected final VirtualFile getContentRoot() {
        return LocalFileSystem.getInstance().findFileByNioFile(this.myTempDirectory.resolve(this.getTestDirectoryName()));
    }

    @Override
    @NotNull
    protected String getTestDirectoryName() {
        String string = this.getTestName(true);
        if (string == null) {
            TestSourceBasedTestCase.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected final PsiDirectory getPackageDirectory(@NotNull String packageRelativePath) {
        if (packageRelativePath == null) {
            TestSourceBasedTestCase.$$$reportNull$$$0(1);
        }
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src/" + packageRelativePath));
    }

    protected final PsiDirectory getSrcDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src"));
    }

    protected final PsiDirectory getContentDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TestSourceBasedTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDirectoryName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TestSourceBasedTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

