/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.repository.Proxy;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.util.artifact.DefaultArtifactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUtils {
    private static String nullify(String string) {
        return string == null || string.length() <= 0 ? null : string;
    }

    private static Artifact toArtifact(org.sonatype.aether.graph.Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        Artifact result = RepositoryUtils.toArtifact(dependency.getArtifact());
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    public static Artifact toArtifact(org.sonatype.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        ArtifactHandler handler = RepositoryUtils.newHandler(artifact);
        DefaultArtifact result = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getProperty("type", artifact.getExtension()), RepositoryUtils.nullify(artifact.getClassifier()), handler);
        result.setFile(artifact.getFile());
        result.setResolved(artifact.getFile() != null);
        ArrayList<String> trail = new ArrayList<String>(1);
        trail.add(result.getId());
        result.setDependencyTrail(trail);
        return result;
    }

    public static void toArtifacts(Collection<Artifact> artifacts, Collection<? extends DependencyNode> nodes, List<String> trail, DependencyFilter filter) {
        for (DependencyNode dependencyNode : nodes) {
            Artifact artifact = RepositoryUtils.toArtifact(dependencyNode.getDependency());
            ArrayList<String> nodeTrail = new ArrayList<String>(trail.size() + 1);
            nodeTrail.addAll(trail);
            nodeTrail.add(artifact.getId());
            if (filter == null || filter.accept(dependencyNode, Collections.<DependencyNode>emptyList())) {
                artifact.setDependencyTrail(nodeTrail);
                artifacts.add(artifact);
            }
            RepositoryUtils.toArtifacts(artifacts, dependencyNode.getChildren(), nodeTrail, filter);
        }
    }

    public static org.sonatype.aether.artifact.Artifact toArtifact(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String version = artifact.getVersion();
        if (version == null && artifact.getVersionRange() != null) {
            version = artifact.getVersionRange().toString();
        }
        Map<String, String> props = null;
        if ("system".equals(artifact.getScope())) {
            String localPath = artifact.getFile() != null ? artifact.getFile().getPath() : "";
            props = Collections.singletonMap("localPath", localPath);
        }
        org.sonatype.aether.artifact.Artifact result = new org.sonatype.aether.util.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), version, props, RepositoryUtils.newArtifactType(artifact.getType(), artifact.getArtifactHandler()));
        result = result.setFile(artifact.getFile());
        return result;
    }

    public static org.sonatype.aether.graph.Dependency toDependency(Artifact artifact, Collection<Exclusion> exclusions) {
        if (artifact == null) {
            return null;
        }
        org.sonatype.aether.artifact.Artifact result = RepositoryUtils.toArtifact(artifact);
        ArrayList<org.sonatype.aether.graph.Exclusion> excl = null;
        if (exclusions != null) {
            excl = new ArrayList<org.sonatype.aether.graph.Exclusion>(exclusions.size());
            for (Exclusion exclusion : exclusions) {
                excl.add(RepositoryUtils.toExclusion(exclusion));
            }
        }
        return new org.sonatype.aether.graph.Dependency(result, artifact.getScope(), artifact.isOptional(), excl);
    }

    public static List<RemoteRepository> toRepos(List<ArtifactRepository> repos) {
        if (repos == null) {
            return null;
        }
        ArrayList<RemoteRepository> results = new ArrayList<RemoteRepository>(repos.size());
        for (ArtifactRepository repo : repos) {
            results.add(RepositoryUtils.toRepo(repo));
        }
        return results;
    }

    public static RemoteRepository toRepo(ArtifactRepository repo) {
        RemoteRepository result = null;
        if (repo != null) {
            result = new RemoteRepository(repo.getId(), repo.getLayout().getId(), repo.getUrl());
            result.setPolicy(true, RepositoryUtils.toPolicy(repo.getSnapshots()));
            result.setPolicy(false, RepositoryUtils.toPolicy(repo.getReleases()));
            result.setAuthentication(RepositoryUtils.toAuthentication(repo.getAuthentication()));
            result.setProxy(RepositoryUtils.toProxy(repo.getProxy()));
        }
        return result;
    }

    private static RepositoryPolicy toPolicy(ArtifactRepositoryPolicy policy) {
        RepositoryPolicy result = null;
        if (policy != null) {
            result = new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
        }
        return result;
    }

    private static org.sonatype.aether.repository.Authentication toAuthentication(Authentication auth) {
        org.sonatype.aether.repository.Authentication result = null;
        if (auth != null) {
            result = new org.sonatype.aether.repository.Authentication(auth.getUsername(), auth.getPassword());
        }
        return result;
    }

    private static org.sonatype.aether.repository.Proxy toProxy(Proxy proxy) {
        org.sonatype.aether.repository.Proxy result = null;
        if (proxy != null) {
            org.sonatype.aether.repository.Authentication auth = new org.sonatype.aether.repository.Authentication(proxy.getUserName(), proxy.getPassword());
            result = new org.sonatype.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        }
        return result;
    }

    public static ArtifactHandler newHandler(org.sonatype.aether.artifact.Artifact artifact) {
        String type = artifact.getProperty("type", artifact.getExtension());
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        handler.setExtension(artifact.getExtension());
        handler.setLanguage(artifact.getProperty("language", null));
        handler.setAddedToClasspath(Boolean.parseBoolean(artifact.getProperty("constitutesBuildPath", "")));
        handler.setIncludesDependencies(Boolean.parseBoolean(artifact.getProperty("includesDependencies", "")));
        return handler;
    }

    public static ArtifactType newArtifactType(String id, ArtifactHandler handler) {
        return new DefaultArtifactType(id, handler.getExtension(), handler.getClassifier(), handler.getLanguage(), handler.isAddedToClasspath(), handler.isIncludesDependencies());
    }

    public static org.sonatype.aether.graph.Dependency toDependency(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        org.sonatype.aether.util.artifact.DefaultArtifact artifact = new org.sonatype.aether.util.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<org.sonatype.aether.graph.Exclusion> exclusions = new ArrayList<org.sonatype.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(RepositoryUtils.toExclusion(exclusion));
        }
        org.sonatype.aether.graph.Dependency result = new org.sonatype.aether.graph.Dependency((org.sonatype.aether.artifact.Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result;
    }

    private static org.sonatype.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.sonatype.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    public static ArtifactTypeRegistry newArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
        return new MavenArtifactTypeRegistry(handlerManager);
    }

    static class MavenArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        private final ArtifactHandlerManager handlerManager;

        public MavenArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
            this.handlerManager = handlerManager;
        }

        public ArtifactType get(String stereotypeId) {
            ArtifactHandler handler = this.handlerManager.getArtifactHandler(stereotypeId);
            return RepositoryUtils.newArtifactType(stereotypeId, handler);
        }
    }
}

