/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.resolve.internal;

import java.util.Collection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven30DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.MavenDependencyResolver;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=DependencyResolver.class, hint="default")
class DefaultDependencyResolver
implements DependencyResolver,
Contextualizable {
    private PlexusContainer container;

    DefaultDependencyResolver() {
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Collection<Dependency> coordinates, Collection<Dependency> managedDependencies, TransformableFilter filter) throws DependencyResolverException {
        this.validateBuildingRequest(buildingRequest);
        try {
            return this.getMavenDependencyResolver(buildingRequest).resolveDependencies(coordinates, managedDependencies, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate coordinate, TransformableFilter filter) throws DependencyResolverException {
        this.validateParameters(buildingRequest, coordinate);
        try {
            return this.getMavenDependencyResolver(buildingRequest).resolveDependencies(coordinate, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Model model, TransformableFilter filter) throws DependencyResolverException {
        this.validateParameters(buildingRequest, model);
        try {
            return this.getMavenDependencyResolver(buildingRequest).resolveDependencies(model, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyResolverException(e.getMessage(), e);
        }
    }

    private boolean isMaven31() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.aether.artifact.Artifact");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, DependableCoordinate coordinate) {
        this.validateBuildingRequest(buildingRequest);
        if (coordinate == null) {
            throw new IllegalArgumentException("The parameter coordinate is not allowed to be null.");
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Model model) {
        this.validateBuildingRequest(buildingRequest);
        if (model == null) {
            throw new IllegalArgumentException("The parameter model is not allowed to be null.");
        }
    }

    private MavenDependencyResolver getMavenDependencyResolver(ProjectBuildingRequest buildingRequest) throws ComponentLookupException, DependencyResolverException {
        ArtifactHandlerManager artifactHandlerManager = this.container.lookup(ArtifactHandlerManager.class);
        if (this.isMaven31()) {
            org.eclipse.aether.RepositorySystem m31RepositorySystem = this.container.lookup(org.eclipse.aether.RepositorySystem.class);
            org.eclipse.aether.RepositorySystemSession session = (org.eclipse.aether.RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
            return new Maven31DependencyResolver(m31RepositorySystem, artifactHandlerManager, session, aetherRepositories);
        }
        RepositorySystem m30RepositorySystem = this.container.lookup(RepositorySystem.class);
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        return new Maven30DependencyResolver(m30RepositorySystem, artifactHandlerManager, session, aetherRepositories);
    }

    private void validateBuildingRequest(ProjectBuildingRequest buildingRequest) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
    }
}

