/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;

public final class Maven40AetherModelConverter
extends Maven40ModelConverter {
    @NotNull
    public static MavenModel convertModelWithAetherDependencyTree(Model model, List<String> sources, List<String> testSources, Collection<? extends org.apache.maven.artifact.Artifact> dependencies, Collection<? extends DependencyNode> dependencyTree, Collection<? extends org.apache.maven.artifact.Artifact> extensions, File localRepository) {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven40AetherModelConverter.convertPlugins(model));
        HashMap<org.apache.maven.artifact.Artifact, MavenArtifact> convertedArtifacts = new HashMap<org.apache.maven.artifact.Artifact, MavenArtifact>();
        result.setExtensions(Maven40AetherModelConverter.convertArtifacts(extensions, convertedArtifacts, localRepository));
        result.setDependencyTree(Maven40AetherModelConverter.convertAetherDependencyNodes(null, dependencyTree, convertedArtifacts, localRepository));
        result.setDependencies(Maven40AetherModelConverter.convertArtifacts(dependencies, convertedArtifacts, localRepository));
        result.setRemoteRepositories(Maven40AetherModelConverter.convertRepositories(model.getRepositories()));
        result.setProfiles(Maven40AetherModelConverter.convertProfiles(model.getProfiles()));
        result.setModules(model.getModules());
        Maven40AetherModelConverter.convertBuild(result.getBuild(), model.getBuild(), sources, testSources);
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven40AetherModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static List<MavenArtifactNode> convertAetherDependencyNodes(MavenArtifactNode parent, Collection<? extends DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode dependencyNode : nodes) {
            org.apache.maven.artifact.Artifact a = Maven40AetherModelConverter.toArtifact(dependencyNode.getDependency());
            MavenArtifact ma = Maven40AetherModelConverter.convertArtifact(a, nativeToConvertedMap, localRepository);
            Map data = dependencyNode.getData();
            String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)dependencyNode);
            String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)dependencyNode);
            MavenArtifactState state = MavenArtifactState.ADDED;
            MavenArtifact relatedArtifact = null;
            String scope = dependencyNode.getDependency().getScope();
            Object winner = data.get("conflict.winner");
            if (winner instanceof DependencyNode) {
                DependencyNode winnerNode = (DependencyNode)winner;
                scope = winnerNode.getDependency().getScope();
                org.apache.maven.artifact.Artifact winnerArtifact = Maven40AetherModelConverter.toArtifact(winnerNode.getDependency());
                relatedArtifact = Maven40AetherModelConverter.convertArtifact(winnerArtifact, nativeToConvertedMap, localRepository);
                nativeToConvertedMap.put(winnerArtifact, relatedArtifact);
                state = !Objects.equals(dependencyNode.getVersion().toString(), winnerNode.getVersion().toString()) ? MavenArtifactState.CONFLICT : MavenArtifactState.DUPLICATE;
            }
            ma.setScope(scope);
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, state, relatedArtifact, dependencyNode.getDependency().getScope(), premanagedVersion, premanagedScope);
            newNode.setDependencies(Maven40AetherModelConverter.convertAetherDependencyNodes(newNode, dependencyNode.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }

    @Nullable
    public static org.apache.maven.artifact.Artifact toArtifact(@Nullable Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact result = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
        if (result == null) {
            return null;
        }
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/maven/server/m40/utils/Maven40AetherModelConverter", "convertModelWithAetherDependencyTree"));
    }
}

