/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import git4idea.remote.GitRemoteUrlCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.GithubUserWithPermissions;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataServiceImpl;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0016R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R \u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00140\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0019R\u001a\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "remoteCoordinates", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "repositoryCoordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repoOwner", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;", "repositoryId", "", "defaultBranchName", "isFork", "", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lgit4idea/remote/GitRemoteUrlCoordinates;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/api/data/GHRepositoryOwnerName;Ljava/lang/String;Ljava/lang/String;Z)V", "assigneesValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "collaborators", "Ljava/util/concurrent/CompletableFuture;", "getCollaborators", "()Ljava/util/concurrent/CompletableFuture;", "collaboratorsValue", "Lorg/jetbrains/plugins/github/api/data/GithubUserWithPermissions;", "getDefaultBranchName", "()Ljava/lang/String;", "()Z", "issuesAssignees", "getIssuesAssignees", "labels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getLabels", "labelsValue", "potentialReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getPotentialReviewers", "getRemoteCoordinates", "()Lgit4idea/remote/GitRemoteUrlCoordinates;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRepositoryId", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "teams", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "getTeams", "teamsValue", "dispose", "", "resetData", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRRepositoryDataServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRRepositoryDataServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n766#2:102\n857#2,2:103\n1549#2:105\n1620#2,3:106\n*S KotlinDebug\n*F\n+ 1 GHPRRepositoryDataServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataServiceImpl\n*L\n66#1:102\n66#1:103,2\n67#1:105\n67#1:106,3\n*E\n"})
public final class GHPRRepositoryDataServiceImpl
implements GHPRRepositoryDataService {
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GitRemoteUrlCoordinates remoteCoordinates;
    @NotNull
    private final GHRepositoryCoordinates repositoryCoordinates;
    @NotNull
    private final GHRepositoryOwnerName repoOwner;
    @NotNull
    private final String repositoryId;
    @Nullable
    private final String defaultBranchName;
    private final boolean isFork;
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repoPath;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GithubUserWithPermissions>> collaboratorsValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GHTeam>> teamsValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GHUser>> assigneesValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GHLabel>> labelsValue;

    public GHPRRepositoryDataServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRemoteUrlCoordinates remoteCoordinates, @NotNull GHRepositoryCoordinates repositoryCoordinates, @NotNull GHRepositoryOwnerName repoOwner, @NotNull String repositoryId, @Nullable String defaultBranchName, boolean isFork) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)remoteCoordinates, (String)"remoteCoordinates");
        Intrinsics.checkNotNullParameter((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        Intrinsics.checkNotNullParameter((Object)repoOwner, (String)"repoOwner");
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        this.requestExecutor = requestExecutor;
        this.remoteCoordinates = remoteCoordinates;
        this.repositoryCoordinates = repositoryCoordinates;
        this.repoOwner = repoOwner;
        this.repositoryId = repositoryId;
        this.defaultBranchName = defaultBranchName;
        this.isFork = isFork;
        this.serverPath = this.getRepositoryCoordinates().getServerPath();
        this.repoPath = this.getRepositoryCoordinates().getRepositoryPath();
        this.requestExecutor.addListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.resetData();
            }
        }));
        this.collaboratorsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GithubUserWithPermissions>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<GithubUserWithPermissions> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Collaborators.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
            }
        });
        this.teamsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHTeam>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<GHTeam> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return !(GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0) instanceof GHRepositoryOwnerName.Organization) ? CollectionsKt.emptyList() : new SimpleGHGQLPagesLoader<T>(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GraphQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHTeam>>>(this.this$0){
                    final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHTeam>> invoke(@NotNull GraphQLRequestPagination it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GHGQLRequests.Organization.Team.INSTANCE.findAll(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoOwner$p(this.this$0).getLogin(), it);
                    }
                }, false, 0, 12, null).loadAll(indicator);
            }
        });
        this.assigneesValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHUser>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHUser> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Assignees.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubUser githubUser = (GithubUser)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getNodeId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeId");
                    String string2 = it.getLogin();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.login");
                    String string3 = it.getHtmlUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.htmlUrl");
                    String string4 = it.getAvatarUrl();
                    if (string4 == null) {
                        string4 = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.avatarUrl ?: \"\"");
                    collection.add(new GHUser(string, string2, string3, string4, null));
                }
                return (List)destination$iv$iv;
            }
        });
        this.labelsValue = LazyCancellableBackgroundProcessValue.Companion.create(progressManager, (Function1)new Function1<ProgressIndicator, List<? extends GHLabel>>(this){
            final /* synthetic */ GHPRRepositoryDataServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHLabel> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$map$iv = GithubApiPagesLoader.loadAll(GHPRRepositoryDataServiceImpl.access$getRequestExecutor$p(this.this$0), indicator, GithubApiRequests.Repos.Labels.pages(GHPRRepositoryDataServiceImpl.access$getServerPath$p(this.this$0), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRRepositoryDataServiceImpl.access$getRepoPath$p(this.this$0).getRepository()));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GithubIssueLabel githubIssueLabel = (GithubIssueLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getNodeId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeId");
                    String string2 = it.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.url");
                    String string3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                    String string4 = it.getColor();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.color");
                    collection.add(new GHLabel(string, string2, string3, string4));
                }
                return (List)destination$iv$iv;
            }
        });
    }

    @Override
    @NotNull
    public GitRemoteUrlCoordinates getRemoteCoordinates() {
        return this.remoteCoordinates;
    }

    @Override
    @NotNull
    public GHRepositoryCoordinates getRepositoryCoordinates() {
        return this.repositoryCoordinates;
    }

    @Override
    @NotNull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    @Nullable
    public String getDefaultBranchName() {
        return this.defaultBranchName;
    }

    @Override
    public boolean isFork() {
        return this.isFork;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getCollaborators() {
        CompletionStage completionStage = ((CompletableFuture)this.collaboratorsValue.getValue()).thenApply(arg_0 -> GHPRRepositoryDataServiceImpl._get_collaborators_$lambda$0(collaborators.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"collaboratorsValue.value\u2026rUrl ?: \"\", null) }\n    }");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHTeam>> getTeams() {
        Object object = this.teamsValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"teamsValue.value");
        return (CompletableFuture)object;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestRequestedReviewer>> getPotentialReviewers() {
        CompletionStage completionStage = ((CompletableFuture)this.collaboratorsValue.getValue()).thenCombine(this.getTeams(), GHPRRepositoryDataServiceImpl::_get_potentialReviewers_$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"collaboratorsValue.value\u2026                       })");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHUser>> getIssuesAssignees() {
        Object object = this.assigneesValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assigneesValue.value");
        return (CompletableFuture)object;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHLabel>> getLabels() {
        Object object = this.labelsValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"labelsValue.value");
        return (CompletableFuture)object;
    }

    @Override
    public void resetData() {
        this.collaboratorsValue.drop();
        this.teamsValue.drop();
        this.assigneesValue.drop();
        this.labelsValue.drop();
    }

    public void dispose() {
        this.resetData();
    }

    private static final List _get_collaborators_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _get_potentialReviewers_$lambda$3(List users, List teams) {
        void $this$mapTo$iv$iv;
        GithubUserWithPermissions it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)users, (String)"users");
        Iterable $this$filter$iv = users;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubUserWithPermissions)element$iv$iv;
            boolean bl = false;
            if (!it.getPermissions().isPush()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GithubUserWithPermissions)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getNodeId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nodeId");
            String string2 = it.getLogin();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.login");
            String string3 = it.getHtmlUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.htmlUrl");
            String string4 = it.getAvatarUrl();
            if (string4 == null) {
                string4 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.avatarUrl ?: \"\"");
            collection.add(new GHUser(string, string2, string3, string4, null));
        }
        Collection collection = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)teams, (String)"teams");
        return CollectionsKt.plus((Collection)collection, (Iterable)teams);
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoPath;
    }

    public static final /* synthetic */ GHRepositoryOwnerName access$getRepoOwner$p(GHPRRepositoryDataServiceImpl $this) {
        return $this.repoOwner;
    }
}

