/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHRepository;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0016\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "currentUser", "currentUserTeams", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "repo", "Lorg/jetbrains/plugins/github/api/data/GHRepository;", "(Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/api/data/GHUser;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lorg/jetbrains/plugins/github/api/data/GHUser;Ljava/util/List;Lorg/jetbrains/plugins/github/api/data/GHRepository;)V", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getCurrentUser", "()Lorg/jetbrains/plugins/github/api/data/GHUser;", "getGhostUser", "currentUserHasPermissionLevel", "", "level", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;", "isCurrentUser", "user", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "isMergeAllowed", "isMergeForbiddenForProject", "isRebaseMergeAllowed", "isSquashMergeAllowed", "isUserInAnyTeam", "slugs", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRSecurityServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRSecurityServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1747#2,3:31\n*S KotlinDebug\n*F\n+ 1 GHPRSecurityServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityServiceImpl\n*L\n23#1:31,3\n*E\n"})
public final class GHPRSecurityServiceImpl
implements GHPRSecurityService {
    @NotNull
    private final GithubSharedProjectSettings sharedProjectSettings;
    @NotNull
    private final GHUser ghostUser;
    @NotNull
    private final GithubAccount account;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final List<GHTeam> currentUserTeams;
    @NotNull
    private final GHRepository repo;

    public GHPRSecurityServiceImpl(@NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GHUser ghostUser, @NotNull GithubAccount account, @NotNull GHUser currentUser, @NotNull List<GHTeam> currentUserTeams2, @NotNull GHRepository repo) {
        Intrinsics.checkNotNullParameter((Object)sharedProjectSettings, (String)"sharedProjectSettings");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter(currentUserTeams2, (String)"currentUserTeams");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this.sharedProjectSettings = sharedProjectSettings;
        this.ghostUser = ghostUser;
        this.account = account;
        this.currentUser = currentUser;
        this.currentUserTeams = currentUserTeams2;
        this.repo = repo;
    }

    @Override
    @NotNull
    public GHUser getGhostUser() {
        return this.ghostUser;
    }

    @Override
    @NotNull
    public GithubAccount getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public GHUser getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public boolean isCurrentUser(@NotNull GithubUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return Intrinsics.areEqual((Object)user.getNodeId(), (Object)this.getCurrentUser().getId());
    }

    @Override
    public boolean currentUserHasPermissionLevel(@NotNull GHRepositoryPermissionLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        GHRepositoryPermissionLevel gHRepositoryPermissionLevel = this.repo.getViewerPermission();
        return (gHRepositoryPermissionLevel != null ? gHRepositoryPermissionLevel.ordinal() : -1) >= level.ordinal();
    }

    @Override
    public boolean isUserInAnyTeam(@NotNull List<String> slugs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(slugs, (String)"slugs");
            Iterable $this$any$iv = this.currentUserTeams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHTeam it = (GHTeam)element$iv;
                    boolean bl2 = false;
                    if (!slugs.contains(it.getSlug())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isMergeAllowed() {
        return this.repo.getMergeCommitAllowed();
    }

    @Override
    public boolean isRebaseMergeAllowed() {
        return this.repo.getRebaseMergeAllowed();
    }

    @Override
    public boolean isSquashMergeAllowed() {
        return this.repo.getSquashMergeAllowed();
    }

    @Override
    public boolean isMergeForbiddenForProject() {
        return this.sharedProjectSettings.getPullRequestMergeForbidden();
    }
}

