/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.components;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtAnalysisSessionMixIn;
import org.jetbrains.kotlin.analysis.api.components.KtReferenceShortener;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenOption;
import org.jetbrains.kotlin.analysis.api.lifetime.KtInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KtInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001JF\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tH\u0016J<\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/api/components/KtReferenceShortenerMixIn;", "Lorg/jetbrains/kotlin/analysis/api/components/KtAnalysisSessionMixIn;", "collectPossibleReferenceShortenings", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "selection", "Lcom/intellij/openapi/util/TextRange;", "classShortenOption", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenOption;", "callableShortenOption", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "collectPossibleReferenceShorteningsInElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKtReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/components/KtReferenceShortenerMixIn\n+ 2 KtLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerKt\n+ 3 KtLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenKt\n*L\n1#1,130:1\n20#2:131\n16#2:132\n17#2,5:140\n20#2:145\n16#2:146\n17#2,5:154\n32#3,7:133\n32#3,7:147\n*S KotlinDebug\n*F\n+ 1 KtReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/components/KtReferenceShortenerMixIn\n*L\n97#1:131\n97#1:132\n97#1:140,5\n111#1:145\n111#1:146\n111#1:154,5\n97#1:133,7\n111#1:147,7\n*E\n"})
public interface KtReferenceShortenerMixIn
extends KtAnalysisSessionMixIn {
    @NotNull
    default public ShortenCommand collectPossibleReferenceShortenings(@NotNull KtFile file2, @NotNull TextRange selection, @NotNull Function1<? super KtClassLikeSymbol, ? extends ShortenOption> classShortenOption, @NotNull Function1<? super KtCallableSymbol, ? extends ShortenOption> callableShortenOption) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(classShortenOption, (String)"classShortenOption");
        Intrinsics.checkNotNullParameter(callableShortenOption, (String)"callableShortenOption");
        KtLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KtLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KtLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KtInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KtInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this.getAnalysisSession().getReferenceShortener$analysis_api().collectShortenings(file2, selection, classShortenOption, callableShortenOption);
    }

    public static /* synthetic */ ShortenCommand collectPossibleReferenceShortenings$default(KtReferenceShortenerMixIn ktReferenceShortenerMixIn, KtFile ktFile, TextRange textRange, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectPossibleReferenceShortenings");
        }
        if ((n & 2) != 0) {
            TextRange textRange2 = ktFile.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            textRange = textRange2;
        }
        if ((n & 4) != 0) {
            function1 = ShortenOption.Companion.getDefaultClassShortenOption();
        }
        if ((n & 8) != 0) {
            function12 = ShortenOption.Companion.getDefaultCallableShortenOption();
        }
        return ktReferenceShortenerMixIn.collectPossibleReferenceShortenings(ktFile, textRange, function1, function12);
    }

    @NotNull
    default public ShortenCommand collectPossibleReferenceShorteningsInElement(@NotNull KtElement element3, @NotNull Function1<? super KtClassLikeSymbol, ? extends ShortenOption> classShortenOption, @NotNull Function1<? super KtCallableSymbol, ? extends ShortenOption> callableShortenOption) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(classShortenOption, (String)"classShortenOption");
        Intrinsics.checkNotNullParameter(callableShortenOption, (String)"callableShortenOption");
        KtLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KtLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KtLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KtInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KtInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        KtReferenceShortener ktReferenceShortener = this.getAnalysisSession().getReferenceShortener$analysis_api();
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        TextRange textRange = element3.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return ktReferenceShortener.collectShortenings(ktFile, textRange, classShortenOption, callableShortenOption);
    }

    public static /* synthetic */ ShortenCommand collectPossibleReferenceShorteningsInElement$default(KtReferenceShortenerMixIn ktReferenceShortenerMixIn, KtElement ktElement, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectPossibleReferenceShorteningsInElement");
        }
        if ((n & 2) != 0) {
            function1 = ShortenOption.Companion.getDefaultClassShortenOption();
        }
        if ((n & 4) != 0) {
            function12 = ShortenOption.Companion.getDefaultCallableShortenOption();
        }
        return ktReferenceShortenerMixIn.collectPossibleReferenceShorteningsInElement(ktElement, function1, function12);
    }
}

