/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationWithFile;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.fir.ContextCollectingDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContextForProvider;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/fir/PersistenceContextCollector;", "", "()V", "collectContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextForProvider;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nContextCollectingDiagnosticCollectorVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextCollectingDiagnosticCollectorVisitor.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/fir/PersistenceContextCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 ContextCollectingDiagnosticCollectorVisitor.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/fir/PersistenceContextCollector\n*L\n76#1:84,2\n*E\n"})
public final class PersistenceContextCollector {
    @NotNull
    public static final PersistenceContextCollector INSTANCE = new PersistenceContextCollector();

    private PersistenceContextCollector() {
    }

    @NotNull
    public final CheckerContextForProvider collectContext(@NotNull SessionHolder sessionHolder, @NotNull FirFile firFile, @NotNull FirDeclaration declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirClassLikeDeclaration) {
            bl = ((FirClassLikeDeclaration)declaration2).getSymbol().getClassId().isLocal();
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            bl = ((FirCallableDeclaration)declaration2).getSymbol().getCallableId().isLocal();
        } else if (firDeclaration instanceof FirDanglingModifierList) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass((FirDanglingModifierList)declaration2);
            bl = coneClassLikeLookupTag != null && (coneClassLikeLookupTag = coneClassLikeLookupTag.getClassId()) != null ? coneClassLikeLookupTag.isLocal() : false;
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            bl = FirDeclarationUtilKt.getClassId(DeclarationUtilsKt.containingClass((FirAnonymousInitializer)declaration2)).isLocal();
        } else if (firDeclaration instanceof FirScript) {
            bl = false;
        } else {
            throw new IllegalStateException(("Unsupported declaration " + UtilsKt.renderWithType(declaration2)).toString());
        }
        boolean isLocal2 = bl;
        if (!(!isLocal2)) {
            boolean $i$a$-require-PersistenceContextCollector$collectContext$22 = false;
            String $i$a$-require-PersistenceContextCollector$collectContext$22 = "Cannot collect context for local declaration " + UtilsKt.renderWithType(declaration2);
            throw new IllegalArgumentException($i$a$-require-PersistenceContextCollector$collectContext$22.toString());
        }
        FirDesignationWithFile designation2 = FirDesignationKt.collectDesignation(declaration2, firFile);
        Iterable $this$forEach$iv = designation2.getPath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClass firClass = (FirRegularClass)element$iv;
            boolean bl2 = false;
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firClass, FirResolvePhase.BODY_RESOLVE);
        }
        return ContextCollectingDiagnosticCollectorVisitor.Companion.collect(sessionHolder, designation2);
    }
}

