/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.utils.caches;

import com.intellij.openapi.util.ModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/utils/caches/CachedValue;", "T", "", "value", "timestamps", "", "", "(Ljava/lang/Object;Ljava/util/List;)V", "getTimestamps", "()Ljava/util/List;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "isUpToDate", "", "dependencies", "Lcom/intellij/openapi/util/ModificationTracker;", "analysis-internal-utils"})
final class CachedValue<T> {
    private final T value;
    @NotNull
    private final List<Long> timestamps;

    public CachedValue(T value2, @NotNull List<Long> timestamps) {
        Intrinsics.checkNotNullParameter(timestamps, (String)"timestamps");
        this.value = value2;
        this.timestamps = timestamps;
    }

    public final T getValue() {
        return this.value;
    }

    @NotNull
    public final List<Long> getTimestamps() {
        return this.timestamps;
    }

    public final boolean isUpToDate(@NotNull List<? extends ModificationTracker> dependencies2) {
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        if (!(this.timestamps.size() == dependencies2.size())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        int n = this.timestamps.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (dependencies2.get(i2).getModificationCount() == ((Number)this.timestamps.get(i2)).longValue()) continue;
            return false;
        }
        return true;
    }
}

