/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataObjectContentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDataObjectContentChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirDataObjectContentChecker INSTANCE = new FirDataObjectContentChecker();

    private FirDataObjectContentChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block12: {
            KtSourceElement source;
            block11: {
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        FirElement firElement = declaration2;
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OVERRIDE_KEYWORD");
                        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
                            return;
                        }
                        source = declaration2.getSource();
                        if (source == null || source.getKind() instanceof KtFakeSourceElementKind) {
                            return;
                        }
                        Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                        FirClass firClass = object instanceof FirClass ? (FirClass)object : null;
                        if (firClass == null) {
                            return;
                        }
                        FirClass containingClass = firClass;
                        if (containingClass.getClassKind() != ClassKind.OBJECT) break block9;
                        FirElement firElement2 = containingClass;
                        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.DATA_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"DATA_KEYWORD");
                        if (FirKeywordUtilsKt.hasModifier(firElement2, ktModifierKeywordToken2)) break block10;
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)declaration2.getName(), (Object)OperatorNameConventions.HASH_CODE) && declaration2.getValueParameters().isEmpty()) break block11;
                if (!Intrinsics.areEqual((Object)declaration2.getName(), (Object)OperatorNameConventions.EQUALS)) break block12;
                FirPureAbstractElement firPureAbstractElement = (FirValueParameter)CollectionsKt.singleOrNull(declaration2.getValueParameters());
                boolean bl = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTypeUtilsKt.isNullableAny((FirTypeRef)firPureAbstractElement) : false;
                if (!bl) break block12;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }
}

