/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.UtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\n\u00100\u001a\u0004\u0018\u00010 H\u0002J\u0012\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0010\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020:H\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001e\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/mpp/CallableSymbolMarker;", "()V", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getCallableId", "()Lorg/jetbrains/kotlin/name/CallableId;", "dispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "getDispatchReceiverType", "()Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "rawStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "getRawStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "receiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "getReceiverParameter", "()Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "resolvedContextReceivers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirContextReceiver;", "getResolvedContextReceivers", "()Ljava/util/List;", "resolvedReceiverTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "getResolvedReceiverTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolvedReturnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getResolvedReturnType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolvedReturnTypeRef", "getResolvedReturnTypeRef", "resolvedStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "getResolvedStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "typeParameterSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameterSymbols", "calculateReceiverTypeRef", "ensureType", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getDeprecation", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "toString", "", "tree"})
@SourceDebugExtension(value={"SMAP\nFirCallableSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallableSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1549#2:109\n1620#2,3:110\n*S KotlinDebug\n*F\n+ 1 FirCallableSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol\n*L\n69#1:109\n69#1:110,3\n*E\n"})
public abstract class FirCallableSymbol<D extends FirCallableDeclaration>
extends FirBasedSymbol<D>
implements CallableSymbolMarker {
    @NotNull
    public abstract CallableId getCallableId();

    @NotNull
    public final FirResolvedTypeRef getResolvedReturnTypeRef() {
        this.ensureType(((FirCallableDeclaration)this.getFir()).getReturnTypeRef());
        FirTypeRef returnTypeRef = ((FirCallableDeclaration)this.getFir()).getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            UtilsKt.errorInLazyResolve(this, "returnTypeRef", Reflection.getOrCreateKotlinClass(returnTypeRef.getClass()), Reflection.getOrCreateKotlinClass(FirResolvedTypeRef.class));
            throw null;
        }
        return (FirResolvedTypeRef)returnTypeRef;
    }

    @NotNull
    public final ConeKotlinType getResolvedReturnType() {
        return FirTypeUtilsKt.getConeType(this.getResolvedReturnTypeRef());
    }

    @Nullable
    public final FirResolvedTypeRef getResolvedReceiverTypeRef() {
        return this.calculateReceiverTypeRef();
    }

    private final FirResolvedTypeRef calculateReceiverTypeRef() {
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)this.getFir()).getReceiverParameter();
        if (firReceiverParameter == null) {
            return null;
        }
        FirReceiverParameter receiverParameter = firReceiverParameter;
        this.ensureType(receiverParameter.getTypeRef());
        FirTypeRef receiverTypeRef = receiverParameter.getTypeRef();
        if (!(receiverTypeRef instanceof FirResolvedTypeRef)) {
            UtilsKt.errorInLazyResolve(this, "receiverTypeRef", Reflection.getOrCreateKotlinClass(receiverTypeRef.getClass()), Reflection.getOrCreateKotlinClass(FirResolvedTypeRef.class));
            throw null;
        }
        return (FirResolvedTypeRef)receiverTypeRef;
    }

    @Nullable
    public final FirReceiverParameter getReceiverParameter() {
        this.calculateReceiverTypeRef();
        return ((FirCallableDeclaration)this.getFir()).getReceiverParameter();
    }

    @NotNull
    public final List<FirContextReceiver> getResolvedContextReceivers() {
        if (((FirCallableDeclaration)this.getFir()).getContextReceivers().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.TYPES);
        return ((FirCallableDeclaration)this.getFir()).getContextReceivers();
    }

    @NotNull
    public final FirResolvedDeclarationStatus getResolvedStatus() {
        return UtilsKt.resolvedStatus((FirMemberDeclaration)this.getFir());
    }

    @NotNull
    public final FirDeclarationStatus getRawStatus() {
        return ((FirCallableDeclaration)this.getFir()).getStatus();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> getTypeParameterSymbols() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((FirCallableDeclaration)this.getFir()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ConeSimpleKotlinType getDispatchReceiverType() {
        return ((FirCallableDeclaration)this.getFir()).getDispatchReceiverType();
    }

    @NotNull
    public final Name getName() {
        return this.getCallableId().getCallableName();
    }

    @Nullable
    public final DeprecationsPerUseSite getDeprecation(@NotNull ApiVersion apiVersion2) {
        Intrinsics.checkNotNullParameter((Object)apiVersion2, (String)"apiVersion");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return ((FirCallableDeclaration)this.getFir()).getDeprecationsProvider().getDeprecationsInfo(apiVersion2);
    }

    private final void ensureType(FirTypeRef typeRef) {
        FirTypeRef firTypeRef;
        FirTypeRef firTypeRef2 = firTypeRef = typeRef;
        if (!(firTypeRef2 == null ? true : firTypeRef2 instanceof FirResolvedTypeRef)) {
            if (firTypeRef instanceof FirImplicitTypeRef) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.TYPES);
            }
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ' ' + this.getCallableId();
    }
}

