/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtNonErrorClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"getInlineArgumentSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isArrayGeneratorConstructorCall", "", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "isInlinedArgument", "checkNonLocalReturn", "kotlin.base.analysis"})
public final class InlineUtilsKt {
    @ApiStatus.Internal
    public static final boolean isInlinedArgument(@NotNull KtAnalysisSession $this$isInlinedArgument, @NotNull KtFunction argument2, boolean checkNonLocalReturn) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlinedArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        KtValueParameterSymbol ktValueParameterSymbol = InlineUtilsKt.getInlineArgumentSymbol($this$isInlinedArgument, argument2);
        if (ktValueParameterSymbol == null) {
            return false;
        }
        KtValueParameterSymbol parameterSymbol = ktValueParameterSymbol;
        if (parameterSymbol.isNoinline() || checkNonLocalReturn && parameterSymbol.isCrossinline()) {
            return false;
        }
        KtType parameterType = parameterSymbol.getReturnType();
        return !$this$isInlinedArgument.isMarkedNullable(parameterType) && ($this$isInlinedArgument.isFunctionType(parameterType) || $this$isInlinedArgument.isSuspendFunctionType(parameterType));
    }

    private static final KtValueParameterSymbol getInlineArgumentSymbol(KtAnalysisSession $this$getInlineArgumentSymbol, KtFunction argument2) {
        if (!(argument2 instanceof KtFunctionLiteral) && !(argument2 instanceof KtNamedFunction)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)argument2));
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression parentCallExpression = ktCallExpression;
        KtLifetimeOwner ktLifetimeOwner = $this$getInlineArgumentSymbol.resolveCall((KtElement)parentCallExpression);
        if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
            return null;
        }
        KtLifetimeOwner parentCall2 = ktLifetimeOwner;
        KtFunctionLikeSymbol symbol2 = (KtFunctionLikeSymbol)KtCallKt.getSymbol(((KtCallableMemberCall)parentCall2).getPartiallyAppliedSymbol());
        if (symbol2 instanceof KtFunctionSymbol && ((KtFunctionSymbol)symbol2).isInline() || InlineUtilsKt.isArrayGeneratorConstructorCall($this$getInlineArgumentSymbol, symbol2)) {
            KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCallExpression, (KtExpression)argument2);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument valueArgument = ktValueArgument;
            KtVariableLikeSignature ktVariableLikeSignature = (KtVariableLikeSignature)((Map)((KtFunctionCall)parentCall2).getArgumentMapping()).get(valueArgument.getArgumentExpression());
            return ktVariableLikeSignature != null ? (KtValueParameterSymbol)ktVariableLikeSignature.getSymbol() : null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayGeneratorConstructorCall(KtAnalysisSession $this$isArrayGeneratorConstructorCall, KtFunctionLikeSymbol symbol2) {
        if (symbol2 instanceof KtConstructorSymbol) {
            ClassId classId = ((KtConstructorSymbol)symbol2).getContainingClassIdIfNonLocal();
            if (!Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray()) && !StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().containsKey(classId)) {
                if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(classId)) return false;
            }
            boolean bl = true;
            boolean isArrayClass = bl;
            if (!isArrayClass) return false;
            if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($this$isArrayGeneratorConstructorCall, symbol2)) return false;
            return true;
        }
        if (!(symbol2 instanceof KtFunctionSymbol)) return false;
        if (!symbol2.isExtension()) return false;
        KtType receiverType2 = KtCallableSymbolKt.getReceiverType(symbol2);
        if (!(receiverType2 instanceof KtNonErrorClassType)) return false;
        if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(((KtNonErrorClassType)receiverType2).getClassId())) return false;
        CallableId callableId = symbol2.getCallableIdIfNonLocal();
        if (!Intrinsics.areEqual((Object)(callableId != null ? callableId.getPackageName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($this$isArrayGeneratorConstructorCall, symbol2)) return false;
        return true;
    }

    private static final boolean isArrayGeneratorConstructorCall$checkParameters(KtAnalysisSession $this_isArrayGeneratorConstructorCall, KtFunctionLikeSymbol symbol2) {
        return symbol2.getValueParameters().size() == 2 && $this_isArrayGeneratorConstructorCall.isInt(symbol2.getValueParameters().get(0).getReturnType()) && $this_isArrayGeneratorConstructorCall.isFunctionType(symbol2.getValueParameters().get(1).getReturnType());
    }
}

