/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiProviders;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.KotlinModuleStateTrackerProvider;
import org.jetbrains.kotlin.idea.base.fir.analysisApiProviders.FirIdeModificationTrackerService;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeKotlinModificationTrackerFactory;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinModificationTrackerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modificationTrackerService", "Lorg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeModificationTrackerService;", "kotlin.jvm.PlatformType", "createLibrariesWideModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "createModuleStateTracker", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "createModuleWithoutDependenciesOutOfBlockModificationTracker", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSourceModule;", "createProjectWideOutOfBlockModificationTracker", "incrementModificationsCount", "", "includeBinaryTrackers", "", "kotlin.base.fir.analysis-api-providers"})
public final class FirIdeKotlinModificationTrackerFactory
extends KotlinModificationTrackerFactory {
    @NotNull
    private final Project project;
    private final FirIdeModificationTrackerService modificationTrackerService;

    public FirIdeKotlinModificationTrackerFactory(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.modificationTrackerService = (FirIdeModificationTrackerService)this.project.getService(FirIdeModificationTrackerService.class);
    }

    @Override
    @NotNull
    public ModificationTracker createProjectWideOutOfBlockModificationTracker() {
        return (ModificationTracker)this.modificationTrackerService.getProjectOutOfBlockModificationTracker();
    }

    @Override
    @NotNull
    public ModificationTracker createModuleWithoutDependenciesOutOfBlockModificationTracker(@NotNull KtSourceModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.modificationTrackerService.getModuleOutOfBlockModificationTracker(KotlinProjectStructureUtils.getIdeaModule(module2));
    }

    @Override
    @NotNull
    public ModificationTracker createLibrariesWideModificationTracker() {
        ModificationTracker modificationTracker = JavaLibraryModificationTracker.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getInstance(project)");
        return modificationTracker;
    }

    @Override
    @NotNull
    public KtModuleStateTracker createModuleStateTracker(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return KotlinModuleStateTrackerProvider.Companion.getInstance(this.project).getModuleStateTrackerFor(module2);
    }

    @Override
    @TestOnly
    public void incrementModificationsCount(boolean includeBinaryTrackers) {
        if (includeBinaryTrackers) {
            ModificationTracker modificationTracker = this.createLibrariesWideModificationTracker();
            Intrinsics.checkNotNull((Object)modificationTracker, (String)"null cannot be cast to non-null type com.intellij.java.library.JavaLibraryModificationTracker");
            ((JavaLibraryModificationTracker)modificationTracker).incModificationCount();
        }
        this.modificationTrackerService.increaseModificationCountForAllModules();
        KotlinModuleStateTrackerProvider.Companion.getInstance(this.project).incrementModificationCountForAllModules(includeBinaryTrackers);
    }
}

