/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.indices.names.ListOfNamesDataExternalizer;
import org.jetbrains.kotlin.idea.vfilefinder.FqNameKeyDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinPartialPackageNamesIndex;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b'\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000b\u001a\u00020\fH$J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000e\u001a\u00020\u000fH$J \u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0012H$J\"\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "dependsOnFileContent", "", "getDeclarationNamesByKtFile", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDeclarationNamesByMetadata", "kotlinJvmBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getKeyDescriptor", "Lorg/jetbrains/kotlin/idea/vfilefinder/FqNameKeyDescriptor;", "getPackageAndNamesFromBuiltIns", "", "fileContent", "getPackageAndNamesFromMetadata", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "traceKeyHashToVirtualFileMapping", "kotlin.base.indices"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNameByPackageShortNameIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameByPackageShortNameIndex.kt\norg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n10#2:87\n1#3:88\n*S KotlinDebug\n*F\n+ 1 NameByPackageShortNameIndex.kt\norg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex\n*L\n35#1:87\n*E\n"})
public abstract class NameByPackageShortNameIndex
extends FileBasedIndexExtension<FqName, List<? extends Name>> {
    @NotNull
    private final Logger LOG;

    public NameByPackageShortNameIndex() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinPartialPackageNamesIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
    }

    @NotNull
    protected abstract List<Name> getDeclarationNamesByKtFile(@NotNull KtFile var1);

    @NotNull
    protected abstract List<Name> getDeclarationNamesByMetadata(@NotNull KotlinJvmBinaryClass var1);

    @NotNull
    protected abstract Map<FqName, List<Name>> getPackageAndNamesFromBuiltIns(@NotNull FileContent var1);

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FqNameKeyDescriptor getKeyDescriptor() {
        return FqNameKeyDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<List<Name>> getValueExternalizer() {
        return ListOfNamesDataExternalizer.INSTANCE;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{KotlinFileType.INSTANCE, JavaClassFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    @NotNull
    public DataIndexer<FqName, List<Name>, FileContent> getIndexer() {
        return arg_0 -> NameByPackageShortNameIndex.getIndexer$lambda$0(this, arg_0);
    }

    private final Map<FqName, List<Name>> getPackageAndNamesFromMetadata(FileContent fileContent) {
        FqName fqName2;
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"fileContent.file");
        KotlinClassFinder.Result result2 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent(virtualFile2, fileContent.getContent());
        if (result2 == null) {
            return MapsKt.emptyMap();
        }
        KotlinClassFinder.Result result3 = result2;
        KotlinClassFinder.Result.KotlinClass kotlinClass = result3 instanceof KotlinClassFinder.Result.KotlinClass ? (KotlinClassFinder.Result.KotlinClass)result3 : null;
        if (kotlinClass == null) {
            return MapsKt.emptyMap();
        }
        KotlinClassFinder.Result.KotlinClass kotlinClass2 = kotlinClass;
        KotlinJvmBinaryClass binaryClass = kotlinClass2.getKotlinJvmBinaryClass();
        String string2 = binaryClass.getClassHeader().getPackageName();
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            fqName2 = new FqName(p0);
        } else {
            FqName fqName3 = binaryClass.getClassId().getPackageFqName();
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"binaryClass.classId.packageFqName");
        }
        FqName packageName2 = fqName2;
        if (binaryClass.getClassHeader().getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS) {
            return MapsKt.emptyMap();
        }
        if (binaryClass.getClassId().isLocal()) {
            return MapsKt.emptyMap();
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)packageName2, (Object)CollectionsKt.distinct((Iterable)this.getDeclarationNamesByMetadata(binaryClass))));
    }

    private static final Map getIndexer$lambda$0(NameByPackageShortNameIndex this$0, FileContent fileContent) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        try {
            Map map2;
            object = fileContent.getFileType();
            if (Intrinsics.areEqual((Object)object, (Object)JavaClassFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromMetadata(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinBuiltInFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromBuiltIns(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinFileType.INSTANCE)) {
                PsiFile psiFile2 = fileContent.getPsiFile();
                KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (ktFile == null) {
                    return MapsKt.emptyMap();
                }
                KtFile ktFile2 = ktFile;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)ktFile2.getPackageFqName(), (Object)CollectionsKt.distinct((Iterable)this$0.getDeclarationNamesByKtFile(ktFile2))));
            } else {
                map2 = MapsKt.emptyMap();
            }
            object = map2;
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this$0.LOG.warn("Error `(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")` while indexing file " + fileContent.getFileName() + " using " + this$0.getName() + " index. Probably the file is broken.");
            object = MapsKt.emptyMap();
        }
        return object;
    }
}

