/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0001\u001a\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a!\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0007\u00a8\u0006\u0014"}, d2={"containsLineBreakInRange", "", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getLineCount", "", "Lcom/intellij/psi/PsiElement;", "getLineCountInRange", "getLineEndOffset", "Lcom/intellij/psi/PsiFile;", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "getLineNumber", "start", "getLineStartOffset", "skipWhitespace", "(Lcom/intellij/psi/PsiFile;IZ)Ljava/lang/Integer;", "isMultiLine", "isOneLiner", "kotlin.base.psi"})
@SourceDebugExtension(value={"SMAP\nPsiLinesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiLinesUtils.kt\norg/jetbrains/kotlin/idea/base/psi/PsiLinesUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class PsiLinesUtilsKt {
    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffset, (String)"<this>");
        return PsiLinesUtilsKt.getLineStartOffset($this$getLineStartOffset, line, true);
    }

    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line, boolean skipWhitespace) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffset, (String)"<this>");
        Document document = $this$getLineStartOffset.getViewProvider().getDocument();
        if (document == null) {
            document = PsiDocumentManager.getInstance((Project)$this$getLineStartOffset.getProject()).getDocument($this$getLineStartOffset);
        }
        if ((doc = document) != null && line >= 0 && line < doc.getLineCount()) {
            int startOffset = doc.getLineStartOffset(line);
            PsiElement psiElement2 = $this$getLineStartOffset.findElementAt(startOffset);
            if (psiElement2 == null) {
                return startOffset;
            }
            PsiElement element3 = psiElement2;
            if (skipWhitespace && (element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment)) {
                Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
                PsiElement psiElement3 = PsiTreeUtil.skipSiblingsForward((PsiElement)element3, (Class[])classArray);
                return psiElement3 != null ? Integer.valueOf(PsiUtilsKt.getStartOffset((PsiElement)psiElement3)) : Integer.valueOf(startOffset);
            }
            return startOffset;
        }
        return null;
    }

    @Nullable
    public static final Integer getLineEndOffset(@NotNull PsiFile $this$getLineEndOffset, int line) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndOffset, (String)"<this>");
        Document document2 = $this$getLineEndOffset.getViewProvider().getDocument();
        if (document2 == null) {
            document2 = PsiDocumentManager.getInstance((Project)$this$getLineEndOffset.getProject()).getDocument($this$getLineEndOffset);
        }
        Document document3 = document = document2;
        return document3 != null ? Integer.valueOf(document3.getLineEndOffset(line)) : null;
    }

    public static final int getLineNumber(@NotNull PsiElement $this$getLineNumber, boolean start2) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineNumber, (String)"<this>");
        Document document = $this$getLineNumber.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            document = PsiDocumentManager.getInstance((Project)$this$getLineNumber.getProject()).getDocument($this$getLineNumber.getContainingFile());
        }
        Document document2 = document;
        int index = start2 ? PsiUtilsKt.getStartOffset((PsiElement)$this$getLineNumber) : PsiUtilsKt.getEndOffset((PsiElement)$this$getLineNumber);
        Document document3 = document2;
        if (index > (document3 != null ? document3.getTextLength() : 0)) {
            return 0;
        }
        Document document4 = document2;
        return document4 != null ? document4.getLineNumber(index) : 0;
    }

    public static /* synthetic */ int getLineNumber$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return PsiLinesUtilsKt.getLineNumber(psiElement2, bl);
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)$this$getLineCount, (String)"<this>");
        PsiFile psiFile2 = $this$getLineCount.getContainingFile();
        if (psiFile2 != null) {
            PsiFile file2 = psiFile2;
            boolean bl = false;
            v1 = PsiDocumentManager.getInstance((Project)$this$getLineCount.getProject()).getDocument(file2);
        } else {
            v1 = doc = null;
        }
        if (doc != null) {
            TextRange spaceRange;
            TextRange textRange = $this$getLineCount.getTextRange();
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            if ((spaceRange = textRange).getEndOffset() <= doc.getTextLength() && spaceRange.getStartOffset() < spaceRange.getEndOffset()) {
                int startLine = doc.getLineNumber(spaceRange.getStartOffset());
                int endLine = doc.getLineNumber(spaceRange.getEndOffset());
                return endLine - startLine + 1;
            }
        }
        String string2 = $this$getLineCount.getText();
        if (string2 == null) {
            throw new IllegalStateException("Cannot count number of lines".toString());
        }
        return StringUtil.getLineBreakCount((CharSequence)string2) + 1;
    }

    public static final boolean isMultiLine(@NotNull PsiElement $this$isMultiLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiLine, (String)"<this>");
        return PsiLinesUtilsKt.getLineCount($this$isMultiLine) > 1;
    }

    public static final boolean isOneLiner(@NotNull PsiElement $this$isOneLiner) {
        Intrinsics.checkNotNullParameter((Object)$this$isOneLiner, (String)"<this>");
        return PsiLinesUtilsKt.getLineCount($this$isOneLiner) == 1;
    }

    public static final int getLineCountInRange(@NotNull Document $this$getLineCountInRange, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineCountInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return Math.abs($this$getLineCountInRange.getLineNumber(textRange.getStartOffset()) - $this$getLineCountInRange.getLineNumber(textRange.getEndOffset()));
    }

    public static final boolean containsLineBreakInRange(@NotNull Document $this$containsLineBreakInRange, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLineBreakInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return PsiLinesUtilsKt.getLineCountInRange($this$containsLineBreakInRange, textRange) != 0;
    }
}

