/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.project.ModuleIndex;
import org.jetbrains.kotlin.idea.caches.project.ModuleIndexImpl;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleModificationTracker;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\t\u00a8\u0006\n"}, d2={"getDependents", "", "Lcom/intellij/openapi/module/Module;", "module", "getModuleIndex", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleIndex;", "project", "Lcom/intellij/openapi/project/Project;", "getDependentModules", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nModuleIndexCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleIndexCache.kt\norg/jetbrains/kotlin/idea/caches/project/ModuleIndexCacheKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1611#2:96\n1855#2:97\n1856#2:99\n1612#2:100\n1446#2,5:101\n1#3:98\n*S KotlinDebug\n*F\n+ 1 ModuleIndexCache.kt\norg/jetbrains/kotlin/idea/caches/project/ModuleIndexCacheKt\n*L\n27#1:96\n27#1:97\n27#1:99\n27#1:100\n28#1:101,5\n27#1:98\n*E\n"})
public final class ModuleIndexCacheKt {
    @NotNull
    public static final Set<ModuleSourceInfo> getDependentModules(@NotNull ModuleSourceInfo $this$getDependentModules) {
        Intrinsics.checkNotNullParameter((Object)$this$getDependentModules, (String)"<this>");
        Set<Module> dependents = ModuleIndexCacheKt.getDependents($this$getDependentModules.getModule());
        return switch (WhenMappings.$EnumSwitchMapping$0[IdeaModuleInfoUtils.getSourceType($this$getDependentModules).ordinal()]) {
            case 1 -> {
                void $this$mapNotNullTo$iv;
                Iterable var2_2 = dependents;
                Collection destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator var7_12 = $this$forEach$iv$iv.iterator();
                while (var7_12.hasNext()) {
                    ModuleTestSourceInfo it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = var7_12.next();
                    boolean $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
                    Module it = (Module)element$iv;
                    boolean $i$a$-mapNotNullTo-ModuleIndexCacheKt$getDependentModules$1 = false;
                    if (KotlinProjectStructureUtils.getTestSourceInfo(it) == null) continue;
                    boolean $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
                    destination$iv.add(it$iv);
                }
                yield (Set)destination$iv;
            }
            case 2 -> {
                void var3_5;
                void $this$flatMapTo$iv;
                Iterable $this$mapNotNullTo$iv = dependents;
                Collection destination$iv = new HashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Module it = (Module)element$iv;
                    boolean $i$a$-flatMapTo-ModuleIndexCacheKt$getDependentModules$2 = false;
                    Iterable list$iv = KotlinProjectStructureUtils.getSourceModuleInfos(it);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                yield (Set)var3_5;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Set<Module> getDependents(Module module2) {
        HashSet<Module> result2 = new HashSet<Module>();
        result2.add(module2);
        HashSet<Module> processedExporting = new HashSet<Module>();
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        ModuleIndex index = ModuleIndexCacheKt.getModuleIndex(project2);
        ArrayDeque<Module> walkingQueue = new ArrayDeque<Module>(10);
        walkingQueue.addLast(module2);
        while ((Module)walkingQueue.pollFirst() != null) {
            Module current;
            processedExporting.add(current);
            result2.addAll(index.plainUsages(current));
            for (Module dependent : index.exportingUsages(current)) {
                result2.add(dependent);
                if (!processedExporting.add(dependent)) continue;
                walkingQueue.addLast(dependent);
            }
        }
        return result2;
    }

    private static final ModuleIndex getModuleIndex(Project project2) {
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> ModuleIndexCacheKt.getModuleIndex$lambda$2(project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getManager(project).getC\u2026Instance(project)\n    )\n}");
        return (ModuleIndex)object;
    }

    private static final CachedValueProvider.Result getModuleIndex$lambda$2(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create()");
        MultiMap plainUsages = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"create()");
        MultiMap exportingUsages = multiMap2;
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>($project, (MultiMap<Module, Module>)exportingUsages, (MultiMap<Module, Module>)plainUsages){
            final /* synthetic */ Project $project;
            final /* synthetic */ MultiMap<Module, Module> $exportingUsages;
            final /* synthetic */ MultiMap<Module, Module> $plainUsages;
            {
                this.$project = $project;
                this.$exportingUsages = $exportingUsages;
                this.$plainUsages = $plainUsages;
                super(0);
            }

            public final void invoke() {
                for (Module module2 : ModuleManager.Companion.getInstance(this.$project).getModules()) {
                    OrderEntry[] orderEntryArray;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module2).getOrderEntries(), (String)"getInstance(module).orderEntries");
                    for (OrderEntry orderEntry : orderEntryArray) {
                        Module referenced;
                        if (!(orderEntry instanceof ModuleOrderEntry) || ((ModuleOrderEntry)orderEntry).getModule() == null) continue;
                        MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? this.$exportingUsages : this.$plainUsages;
                        map2.putValue((Object)referenced, (Object)module2);
                    }
                }
            }
        }));
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance($project)};
        return new CachedValueProvider.Result((Object)new ModuleIndexImpl((MultiMap<Module, Module>)plainUsages, (MultiMap<Module, Module>)exportingUsages), objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.TEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.PRODUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

