/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.RestoreReferencesDialog;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J,\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J&\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/ReviewAddedImports;", "", "()V", "importsToBeDeleted", "", "", "getImportsToBeDeleted", "()Ljava/util/Collection;", "setImportsToBeDeleted", "(Ljava/util/Collection;)V", "importsToBeReviewed", "getImportsToBeReviewed", "setImportsToBeReviewed", "removeImports", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importsToRemove", "reviewAddedImports", "editor", "Lcom/intellij/openapi/editor/Editor;", "imported", "Ljava/util/TreeSet;", "reviewImports", "importedClasses", "", "showHint", "info", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReviewAddedImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewAddedImports.kt\norg/jetbrains/kotlin/idea/codeInsight/ReviewAddedImports\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n76#2:107\n76#2:108\n11065#3:109\n11400#3,3:110\n1603#4,9:113\n1855#4:122\n1856#4:125\n1612#4:126\n1#5:123\n1#5:124\n*S KotlinDebug\n*F\n+ 1 ReviewAddedImports.kt\norg/jetbrains/kotlin/idea/codeInsight/ReviewAddedImports\n*L\n44#1:107\n71#1:108\n85#1:109\n85#1:110,3\n97#1:113,9\n97#1:122\n97#1:125\n97#1:126\n97#1:124\n*E\n"})
public final class ReviewAddedImports {
    @NotNull
    public static final ReviewAddedImports INSTANCE = new ReviewAddedImports();
    @NotNull
    private static Collection<String> importsToBeReviewed = CollectionsKt.emptyList();
    @NotNull
    private static Collection<String> importsToBeDeleted = CollectionsKt.emptyList();

    private ReviewAddedImports() {
    }

    @TestOnly
    @NotNull
    public final Collection<String> getImportsToBeReviewed() {
        return importsToBeReviewed;
    }

    public final void setImportsToBeReviewed(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        importsToBeReviewed = collection;
    }

    @TestOnly
    @NotNull
    public final Collection<String> getImportsToBeDeleted() {
        return importsToBeDeleted;
    }

    public final void setImportsToBeDeleted(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        importsToBeDeleted = collection;
    }

    public final void reviewAddedImports(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtFile file2, @NotNull TreeSet<String> imported) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 1 && !imported.isEmpty()) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                importsToBeReviewed = imported;
                this.removeImports(project2, file2, importsToBeDeleted);
                return;
            }
            Object[] objectArray = new Object[]{imported.size()};
            String notificationText = KotlinBundle.htmlMessage("copy.paste.reference.notification", objectArray);
            ApplicationManager.getApplication().invokeLater(() -> ReviewAddedImports.reviewAddedImports$lambda$1(editor2, notificationText, project2, file2, imported), ModalityState.nonModal());
        }
    }

    private final void showHint(Editor editor2, @Nls String info2, HyperlinkListener hyperlinkListener) {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)info2, (HyperlinkListener)hyperlinkListener, null, null));
        int flags = 10;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, flags, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void reviewImports(Project project2, KtFile file2, Set<String> importedClasses) {
        RestoreReferencesDialog dialog2 = new RestoreReferencesDialog(project2, ArrayUtil.toObjectArray((Collection)importedClasses));
        dialog2.setTitle(KotlinBundle.message("dialog.import.on.paste.title3", new Object[0]));
        if (dialog2.showAndGet()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = dialog2.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"dialog.selectedElements");
            Object[] objectArray2 = objectArray;
            KtFile ktFile = file2;
            Project project3 = project2;
            ReviewAddedImports reviewAddedImports = this;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var13_16 = item$iv$iv = $this$mapTo$iv$iv[j];
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                collection.add((String)it);
            }
            collection = (List)destination$iv$iv;
            reviewAddedImports.removeImports(project3, ktFile, CollectionsKt.toSortedSet((Iterable)collection));
        }
    }

    private final void removeImports(Project project2, KtFile file2, Collection<String> importsToRemove) {
        if (importsToRemove.isEmpty()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)KotlinBundle.message("revert.applied.imports.command", new Object[0]), null, () -> ReviewAddedImports.removeImports$lambda$5(file2, importsToRemove), (PsiFile[])new PsiFile[0]);
    }

    private static final void reviewAddedImports$lambda$1$lambda$0(Project $project, KtFile $file, TreeSet $imported, HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$imported, (String)"$imported");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            INSTANCE.reviewImports($project, $file, $imported);
        }
    }

    private static final void reviewAddedImports$lambda$1(Editor $editor, String $notificationText, Project $project, KtFile $file, TreeSet $imported) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$notificationText, (String)"$notificationText");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$imported, (String)"$imported");
        INSTANCE.showHint($editor, $notificationText, arg_0 -> ReviewAddedImports.reviewAddedImports$lambda$1$lambda$0($project, $file, $imported, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeImports$lambda$5(KtFile $file, Collection $importsToRemove) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$importsToRemove, (String)"$importsToRemove");
        Iterable $this$mapNotNull$iv = $file.getImportDirectives();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportPath importPath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            boolean bl2 = false;
            if (it.getImportedFqName() == null) {
                importPath = null;
            } else {
                FqName importedFqName;
                Intrinsics.checkNotNullExpressionValue((Object)importedFqName, (String)"it.importedFqName ?: return@mapNotNull null");
                if ($importsToRemove.contains(importedFqName.asString())) {
                    importPath = null;
                } else {
                    Name name2;
                    FqName fqName2 = importedFqName;
                    boolean bl3 = it.isAllUnder();
                    if (it.getAliasName() != null) {
                        void alias;
                        boolean bl4 = bl3;
                        FqName fqName3 = fqName2;
                        boolean bl5 = false;
                        Name name3 = Name.identifier((String)alias);
                        fqName2 = fqName3;
                        bl3 = bl4;
                        name2 = name3;
                    } else {
                        name2 = null;
                    }
                    Name name4 = name2;
                    boolean bl6 = bl3;
                    FqName fqName4 = fqName2;
                    importPath = new ImportPath(fqName4, bl6, name4);
                }
            }
            if (importPath == null) continue;
            ImportPath it$iv$iv = importPath;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newImports = (List)destination$iv$iv;
        KotlinImportOptimizer.Companion.replaceImports($file, newImports);
    }
}

