/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelperKt;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

public class KotlinFunctionLiteralSurrounder
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(Project project2, Editor editor2, PsiElement container2, PsiElement[] statements2) {
        if ((statements2 = MoveDeclarationsOutHelperKt.move(container2, statements2, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project2, editor2, KotlinSurrounderUtils.SURROUND_WITH_ERROR());
            return null;
        }
        KtPsiFactory psiFactory = new KtPsiFactory(project2);
        KtCallExpression callExpression2 = (KtCallExpression)psiFactory.createExpression("run {\n}");
        callExpression2 = (KtCallExpression)container2.addAfter((PsiElement)callExpression2, statements2[statements2.length - 1]);
        container2.addBefore(psiFactory.createWhiteSpace(), (PsiElement)callExpression2);
        KtLambdaExpression bodyExpression = ((KtLambdaArgument)callExpression2.getLambdaArguments().get(0)).getLambdaExpression();
        assert (bodyExpression != null) : "Body expression should exists for " + callExpression2.getText();
        KtBlockExpression blockExpression2 = bodyExpression.getBodyExpression();
        assert (blockExpression2 != null) : "JetBlockExpression should exists for " + callExpression2.getText();
        KotlinSurrounderUtils.addStatementsInBlock(blockExpression2, statements2);
        container2.deleteChildRange(statements2[0], statements2[statements2.length - 1]);
        callExpression2 = (KtCallExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)callExpression2);
        assert (callExpression2 != null);
        KtExpression literalName = callExpression2.getCalleeExpression();
        assert (literalName != null) : "Run expression should have callee expression " + callExpression2.getText();
        return literalName.getTextRange();
    }

    public String getTemplateDescription() {
        return "run { }";
    }
}

