/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtFunctionLikeSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.idea.completion.impl.k2.KotlinCompletionImplK2Bundle;
import org.jetbrains.kotlin.idea.completion.lookups.CompletionShortNamesRenderer;
import org.jetbrains.kotlin.idea.completion.lookups.TailTextProvider;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0002R\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u0004*\u00020\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ&\u0010\n\u001a\u00020\u0004*\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u0010*\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0012\u0010\u0012\u001a\u00020\u0010*\u00020\b2\u0006\u0010\r\u001a\u00020\u0014\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/TailTextProvider;", "", "()V", "asStringForTailText", "", "Lorg/jetbrains/kotlin/name/FqName;", "getContainerPresentation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;)Ljava/lang/String;", "getTailText", "signature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "usePackageFqName", "", "addTypeParameters", "insertLambdaBraces", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/types/KtFunctionalType;", "kotlin.completion.impl-k2"})
@SourceDebugExtension(value={"SMAP\nTailTextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TailTextProvider.kt\norg/jetbrains/kotlin/idea/completion/lookups/TailTextProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class TailTextProvider {
    @NotNull
    public static final TailTextProvider INSTANCE = new TailTextProvider();

    private TailTextProvider() {
    }

    @NotNull
    public final String getTailText(@NotNull KtAnalysisSession $this$getTailText, @NotNull KtCallableSignature<?> signature2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$getTailText, (String)"<this>");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        StringBuilder $this$getTailText_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (signature2 instanceof KtFunctionLikeSignature) {
            if (INSTANCE.insertLambdaBraces($this$getTailText, (KtFunctionLikeSignature)signature2)) {
                $this$getTailText_u24lambda_u242.append(" {...}");
            } else {
                $this$getTailText_u24lambda_u242.append(CompletionShortNamesRenderer.INSTANCE.renderFunctionParameters($this$getTailText, (KtFunctionLikeSignature)signature2));
            }
        }
        KtType ktType = KtCallableSymbolKt.getReceiverType(signature2.getSymbol());
        if (ktType != null) {
            KtType receiverType2 = ktType;
            boolean bl2 = false;
            String renderedType = $this$getTailText.render(receiverType2, CompletionShortNamesRenderer.INSTANCE.getRendererVerbose(), Variance.INVARIANT);
            Object[] objectArray = new Object[]{renderedType};
            $this$getTailText_u24lambda_u242.append(KotlinCompletionImplK2Bundle.INSTANCE.message("presentation.tail.for.0", objectArray));
        }
        String string2 = INSTANCE.getContainerPresentation($this$getTailText, (KtCallableSymbol)signature2.getSymbol());
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$getTailText_u24lambda_u242.append(it);
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public final String getTailText(@NotNull KtAnalysisSession $this$getTailText, @NotNull KtClassLikeSymbol symbol2, boolean usePackageFqName, boolean addTypeParameters) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$getTailText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        StringBuilder $this$getTailText_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ClassId classId = symbol2.getClassIdIfNonLocal();
        if (classId != null) {
            ClassId classId2 = classId;
            boolean bl2 = false;
            if (addTypeParameters && !((Collection)symbol2.getTypeParameters()).isEmpty()) {
                $this$getTailText_u24lambda_u244.append(CollectionsKt.joinToString$default((Iterable)symbol2.getTypeParameters(), (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)getTailText.2.1.1.INSTANCE, (int)24, null));
            }
            FqName fqName2 = usePackageFqName ? classId2.getPackageFqName() : classId2.asSingleFqName().parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"if (usePackageFqName) cl\u2026asSingleFqName().parent()");
            FqName fqName3 = fqName2;
            $this$getTailText_u24lambda_u244.append(" (");
            $this$getTailText_u24lambda_u244.append(INSTANCE.asStringForTailText(fqName3));
            $this$getTailText_u24lambda_u244.append(")");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static /* synthetic */ String getTailText$default(TailTextProvider tailTextProvider, KtAnalysisSession ktAnalysisSession, KtClassLikeSymbol ktClassLikeSymbol, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return tailTextProvider.getTailText(ktAnalysisSession, ktClassLikeSymbol, bl, bl2);
    }

    private final String getContainerPresentation(KtAnalysisSession _context_receiver_0, KtCallableSymbol $this$getContainerPresentation) {
        Object object;
        CallableId callableId = $this$getContainerPresentation.getCallableIdIfNonLocal();
        if (callableId == null) {
            return null;
        }
        CallableId callableId2 = callableId;
        FqName className = callableId2.getClassName();
        String packagePresentation = this.asStringForTailText(callableId2.getPackageName());
        if (!$this$getContainerPresentation.isExtension() && className != null) {
            object = null;
        } else if (!$this$getContainerPresentation.isExtension()) {
            object = " (" + packagePresentation + ")";
        } else {
            Object object2 = className;
            if (object2 == null || (object2 = object2.asString()) == null) {
                object2 = packagePresentation;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"className?.asString() ?: packagePresentation");
            Object containerPresentation = object2;
            Object[] objectArray = new Object[]{containerPresentation};
            object = KotlinCompletionImplK2Bundle.INSTANCE.message("presentation.tail.in.0", objectArray);
        }
        return object;
    }

    private final String asStringForTailText(FqName $this$asStringForTailText) {
        String string2;
        if ($this$asStringForTailText.isRoot()) {
            string2 = "<root>";
        } else {
            String string3 = $this$asStringForTailText.asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString()");
        }
        return string2;
    }

    public final boolean insertLambdaBraces(@NotNull KtAnalysisSession $this$insertLambdaBraces, @NotNull KtFunctionLikeSignature<?> symbol2) {
        Intrinsics.checkNotNullParameter((Object)$this$insertLambdaBraces, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        KtVariableLikeSignature singleParam = (KtVariableLikeSignature)CollectionsKt.singleOrNull(symbol2.getValueParameters());
        return singleParam != null && !((KtValueParameterSymbol)singleParam.getSymbol()).getHasDefaultValue() && singleParam.getReturnType() instanceof KtFunctionalType;
    }

    public final boolean insertLambdaBraces(@NotNull KtAnalysisSession $this$insertLambdaBraces, @NotNull KtFunctionalType symbol2) {
        Intrinsics.checkNotNullParameter((Object)$this$insertLambdaBraces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        KtType singleParam = (KtType)CollectionsKt.singleOrNull(symbol2.getParameterTypes());
        return singleParam != null && singleParam instanceof KtFunctionalType;
    }
}

