/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0016B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002%\b\u0002\u0010\u0010\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\t\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/core/RestoreCaret;", "T", "Lcom/intellij/psi/PsiElement;", "", "beforeElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "beforeElementTextLength", "", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "relativeOffset", "restoreCaret", "", "afterElement", "defaultOffset", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "Companion", "kotlin.fir.frontend-independent"})
public final class RestoreCaret<T extends PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Editor editor;
    private final int relativeOffset;
    private final int beforeElementTextLength;

    public RestoreCaret(@NotNull T beforeElement, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter(beforeElement, (String)"beforeElement");
        this.editor = editor2;
        this.beforeElementTextLength = beforeElement.getTextLength();
        this.relativeOffset = Companion.findRelativeOffset((PsiElement)beforeElement, this.editor);
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    public final void restoreCaret(@NotNull T afterElement, @Nullable Function1<? super T, Integer> defaultOffset) {
        int offset2;
        Intrinsics.checkNotNullParameter(afterElement, (String)"afterElement");
        if (this.editor == null) {
            return;
        }
        Project project2 = this.editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project3).createSmartPsiElementPointer(afterElement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(project).cre\u2026mentPointer(afterElement)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project3).commitDocument(document2);
        PsiDocumentManager.getInstance((Project)project3).doPostponedOperationsAndUnblockDocument(document2);
        PsiElement psiElement2 = pointer.getElement();
        if (psiElement2 == null) {
            return;
        }
        PsiElement afterElementChanged = psiElement2;
        int n = this.relativeOffset != -1 && afterElementChanged.getTextLength() == this.beforeElementTextLength ? PsiUtilsKt.getStartOffset((PsiElement)afterElementChanged) + this.relativeOffset : (offset2 = defaultOffset != null ? ((Number)defaultOffset.invoke((Object)afterElementChanged)).intValue() : -1);
        if (offset2 == -1) {
            return;
        }
        if (document2.getTextLength() > offset2) {
            this.editor.getCaretModel().moveToOffset(offset2);
        }
    }

    public static /* synthetic */ void restoreCaret$default(RestoreCaret restoreCaret, PsiElement psiElement2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        restoreCaret.restoreCaret(psiElement2, function1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/RestoreCaret$Companion;", "", "()V", "findRelativeOffset", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.fir.frontend-independent"})
    public static final class Companion {
        private Companion() {
        }

        public final int findRelativeOffset(@NotNull PsiElement element3, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (editor2 != null) {
                List list2 = editor2.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
                Caret singleCaret = (Caret)CollectionsKt.singleOrNull((List)list2);
                if (singleCaret != null) {
                    int relative;
                    int caretOffset = singleCaret.getOffset();
                    TextRange textRange = element3.getTextRange();
                    if (textRange.getStartOffset() <= caretOffset && caretOffset <= textRange.getEndOffset() && (relative = caretOffset - PsiUtilsKt.getStartOffset((PsiElement)element3)) >= 0) {
                        return relative;
                    }
                }
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

