/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.SLRUMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.CheckCanceledLock;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptTemplatesProviderAdapter;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.StandardScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000289B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001aH\u0016J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\b\u0010(\u001a\u00020\nH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020+2\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020 H\u0002J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u0011J\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configurations", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "", "definitionsBySource", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "failedContributorsHashes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "scriptDefinitionsCache", "Lcom/intellij/util/containers/SLRUMap;", "", "scriptDefinitionsCacheLock", "Lorg/jetbrains/kotlin/idea/base/util/CheckCanceledLock;", "sourcesToReload", "", "dispose", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "getAllDefinitions", "getDefaultDefinition", "getSources", "isReady", "", "isScratchFile", "kotlinScriptingSettingsSafe", "Lorg/jetbrains/kotlin/idea/core/script/settings/KotlinScriptingSettings;", "loadScriptDefinitions", "reloadDefinitionsBy", "source", "reloadScriptDefinitions", "reloadScriptDefinitionsIfNeeded", "reorderScriptDefinitions", "updateDefinitions", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "safeGetDefinitions", "Companion", "UpdateDefinitionsResult", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CheckCancelledLockUtils.kt\norg/jetbrains/kotlin/idea/base/util/CheckCanceledLock\n+ 4 CheckCancelledLockUtils.kt\norg/jetbrains/kotlin/idea/base/util/CheckCancelledLockUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor$Companion\n*L\n1#1,496:1\n1#2:497\n1#2:516\n1#2:530\n1#2:558\n1#2:572\n1#2:588\n1#2:604\n41#3,7:498\n41#3,7:505\n41#3,7:632\n13#4,4:512\n18#4,9:517\n13#4,4:526\n18#4,9:531\n13#4,4:554\n18#4,9:559\n13#4,4:568\n18#4,9:573\n13#4,4:584\n18#4,6:589\n25#4,2:598\n13#4,4:600\n18#4,9:605\n1549#5:540\n1620#5,3:541\n1549#5:544\n1620#5,3:545\n1271#5,2:548\n1285#5,4:550\n1855#5,2:582\n1855#5,2:595\n1045#5:597\n1726#5,3:614\n800#5,11:618\n766#5:629\n857#5,2:630\n414#6:617\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager\n*L\n131#1:516\n141#1:530\n180#1:558\n188#1:572\n200#1:588\n227#1:604\n100#1:498,7\n110#1:505,7\n256#1:632,7\n131#1:512,4\n131#1:517,9\n141#1:526,4\n141#1:531,9\n180#1:554,4\n180#1:559,9\n188#1:568,4\n188#1:573,9\n200#1:584,4\n200#1:589,6\n200#1:598,2\n227#1:600,4\n227#1:605,9\n162#1:540\n162#1:541,3\n164#1:544\n164#1:545,3\n177#1:548,2\n177#1:550,4\n194#1:582,2\n202#1:595,2\n205#1:597\n228#1:614,3\n235#1:618,11\n246#1:629\n246#1:630,2\n235#1:617\n*E\n"})
public final class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReentrantReadWriteLock definitionsLock;
    @NotNull
    private final Map<ScriptDefinitionsSource, List<ScriptDefinition>> definitionsBySource;
    @Nullable
    private volatile List<? extends ScriptDefinition> definitions;
    @NotNull
    private final Set<ScriptDefinitionsSource> sourcesToReload;
    @NotNull
    private final HashSet<Integer> failedContributorsHashes;
    @NotNull
    private final CheckCanceledLock scriptDefinitionsCacheLock;
    @NotNull
    private final SLRUMap<String, ScriptDefinition> scriptDefinitionsCache;
    @Nullable
    private volatile CompositeScriptConfigurationManager configurations;

    public ScriptDefinitionsManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.definitionsLock = new ReentrantReadWriteLock();
        this.definitionsBySource = new LinkedHashMap();
        this.sourcesToReload = new LinkedHashSet();
        this.failedContributorsHashes = new HashSet();
        this.scriptDefinitionsCacheLock = new CheckCanceledLock();
        this.scriptDefinitionsCache = new SLRUMap(10, 10);
        this.configurations = ScriptConfigurationManager.Companion.compositeScriptConfigurationManager(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        ScriptDefinition scriptDefinition;
        ScriptDefinition scriptDefinition2;
        ScriptDefinition scriptDefinition3;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String string2 = script.getLocationId();
        if (string2 == null) {
            return null;
        }
        String locationId = string2;
        if (this.nonScriptId(locationId)) {
            return null;
        }
        Object object = this.configurations;
        if (object != null && (scriptDefinition3 = object.tryGetScriptDefinitionFast(locationId)) != null) {
            ScriptDefinition fastPath = scriptDefinition3;
            boolean bl = false;
            return fastPath;
        }
        if (!this.isReady()) {
            return null;
        }
        CheckCanceledLock this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock = false;
        while (!this_$iv.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl = false;
            scriptDefinition2 = (ScriptDefinition)((Object)this.scriptDefinitionsCache.get((Object)locationId));
        }
        finally {
            this_$iv.getLock().unlock();
        }
        object = scriptDefinition2;
        if (object != null) {
            Object cached2 = object;
            boolean bl = false;
            return cached2;
        }
        if (this.isScratchFile(script)) {
            scriptDefinition = this.getDefaultDefinition();
        } else {
            scriptDefinition = super.findDefinition(script);
            if (scriptDefinition == null) {
                return null;
            }
        }
        ScriptDefinition definition2 = scriptDefinition;
        this_$iv = this.scriptDefinitionsCacheLock;
        $i$f$withLock = false;
        while (!this_$iv.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl = false;
            this.scriptDefinitionsCache.put((Object)locationId, (Object)definition2);
            scriptDefinition2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.getLock().unlock();
        }
        return definition2;
    }

    private final boolean isScratchFile(SourceCode script) {
        VirtualFile virtualFile2;
        if (script instanceof VirtualFileScriptSource) {
            virtualFile2 = ((VirtualFileScriptSource)script).getVirtualFile();
        } else {
            String string2 = script.getLocationId();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(it);
            } else {
                virtualFile2 = null;
            }
        }
        VirtualFile virtualFile3 = virtualFile2;
        return virtualFile3 != null && ScratchFileService.getInstance().getRootType(virtualFile3) instanceof ScratchRootType;
    }

    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ScriptDefinition scriptDefinition = this.findDefinition(ScriptHostUtilKt.toScriptSource(new File(fileName)));
        return scriptDefinition != null ? scriptDefinition.getLegacyDefinition() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        block18: {
            UpdateDefinitionsResult updateDefinitionsResult;
            int n;
            ReentrantReadWriteLock.WriteLock wl$iv;
            int n2;
            int readCount$iv;
            ReentrantReadWriteLock.ReadLock rl$iv;
            block15: {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
                boolean $i$f$writeWithCheckCanceled = false;
                rl$iv = $this$writeWithCheckCanceled$iv.readLock();
                readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
                int n3 = 0;
                while (n3 < readCount$iv) {
                    int it$iv = n3++;
                    n2 = 0;
                    rl$iv.unlock();
                }
                wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
                while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                    ProgressManager.checkCanceled();
                }
                boolean bl = false;
                if (this.definitions != null) break block15;
                this.sourcesToReload.add(source);
                for (n2 = 0; n2 < readCount$iv; ++n2) {
                    rl$iv.lock();
                }
                wl$iv.unlock();
                return;
            }
            try {
                if (!this.definitionsBySource.containsKey(source)) {
                    throw new IllegalStateException(("Unknown script definition source: " + source).toString());
                }
                Unit it$iv = Unit.INSTANCE;
            }
            catch (Throwable it$iv) {
                throw it$iv;
            }
            finally {
                n2 = 0;
                while (n2 < readCount$iv) {
                    int it$iv = n2++;
                    n = 0;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            List<ScriptDefinition> safeGetDefinitions = this.safeGetDefinitions(source);
            ScriptDefinitionsManager $this$reloadDefinitionsBy_u24lambda_u247 = this;
            boolean bl = false;
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = $this$reloadDefinitionsBy_u24lambda_u247.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv2 = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv2 = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            n = 0;
            while (n < readCount$iv2) {
                int it$iv = n++;
                boolean bl2 = false;
                rl$iv2.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv2 = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv2.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl3 = false;
                $this$reloadDefinitionsBy_u24lambda_u247.definitionsBySource.put(source, safeGetDefinitions);
                $this$reloadDefinitionsBy_u24lambda_u247.definitions = (List)AddToStdlibKt.flattenTo((Iterable)$this$reloadDefinitionsBy_u24lambda_u247.definitionsBySource.values(), (Collection)new ArrayList());
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < readCount$iv2) {
                    int it$iv = n4++;
                    boolean bl4 = false;
                    rl$iv2.lock();
                }
                wl$iv2.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$reloadDefinitionsBy_u24lambda_u247.updateDefinitions();
            if (updateDefinitionsResult2 == null) break block18;
            updateDefinitionsResult2.apply();
        }
    }

    @Override
    @NotNull
    protected Sequence<ScriptDefinition> getCurrentDefinitions() {
        KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
        if (kotlinScriptingSettings == null) {
            return SequencesKt.emptySequence();
        }
        KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
        List<? extends ScriptDefinition> list2 = this.definitions;
        if (list2 == null) {
            ScriptDefinitionsManager $this$_get_currentDefinitions__u24lambda_u248 = this;
            boolean bl = false;
            $this$_get_currentDefinitions__u24lambda_u248.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list3 = $this$_get_currentDefinitions__u24lambda_u248.definitions;
            list2 = list3;
            Intrinsics.checkNotNull(list3);
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<ScriptDefinition, Boolean>(scriptingSettings){
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;
            {
                this.$scriptingSettings = $scriptingSettings;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ScriptDefinition it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$scriptingSettings.isScriptDefinitionEnabled(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinitionsSource> getSources() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object[] objectArray = this.project.getExtensionArea().getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME()).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea.ge\u2026vider.EP_NAME).extensions");
        Iterable $this$map$iv = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ScriptTemplatesProvider scriptTemplatesProvider = (ScriptTemplatesProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(ScriptDefinitionsManagerKt.asSource(new ScriptTemplatesProviderAdapter((ScriptTemplatesProvider)it)));
        }
        List fromDeprecatedEP = (List)destination$iv$iv;
        Object[] objectArray2 = ScriptDefinitionContributor.Companion.getEP_NAME().getPoint((AreaInstance)this.project).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"ScriptDefinitionContribu\u2026Point(project).extensions");
        Iterable $this$map$iv2 = ArraysKt.toList((Object[])objectArray2);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptDefinitionContributor bl = (ScriptDefinitionContributor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(ScriptDefinitionsManagerKt.asSource((ScriptDefinitionContributor)it));
        }
        List fromNewEp = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Iterable)fromDeprecatedEP), (Object)CollectionsKt.last((List)fromNewEp));
    }

    public final void reloadScriptDefinitionsIfNeeded() {
        Unit unit2 = this.definitions;
        if (unit2 == null) {
            this.loadScriptDefinitions();
            unit2 = Unit.INSTANCE;
        }
    }

    public final void reloadScriptDefinitions() {
        this.loadScriptDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadScriptDefinitions() {
        ArrayList it$iv4;
        UpdateDefinitionsResult updateDefinitionsResult;
        int n;
        if (this.project.isDisposed()) {
            return;
        }
        Iterable $this$associateWith$iv = this.getSources();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ScriptDefinitionsSource scriptDefinitionsSource = (ScriptDefinitionsSource)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            n = 0;
            List<ScriptDefinition> list2 = this.safeGetDefinitions((ScriptDefinitionsSource)it);
            map2.put(t, list2);
        }
        Map newDefinitionsBySource = result$iv;
        ScriptDefinitionsManager $this$loadScriptDefinitions_u24lambda_u2413 = this;
        boolean bl = false;
        ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = $this$loadScriptDefinitions_u24lambda_u2413.definitionsLock;
        boolean $i$f$writeWithCheckCanceled = false;
        ReentrantReadWriteLock.ReadLock rl$iv22 = $this$writeWithCheckCanceled$iv.readLock();
        int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
        n = 0;
        while (n < readCount$iv) {
            int it$iv2 = n++;
            boolean bl2 = false;
            rl$iv22.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
        while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl3 = false;
            $this$loadScriptDefinitions_u24lambda_u2413.definitionsBySource.putAll(newDefinitionsBySource);
            $this$loadScriptDefinitions_u24lambda_u2413.definitions = (List)AddToStdlibKt.flattenTo((Iterable)$this$loadScriptDefinitions_u24lambda_u2413.definitionsBySource.values(), (Collection)new ArrayList());
            Unit it$iv2 = Unit.INSTANCE;
        }
        finally {
            int n2 = 0;
            while (n2 < readCount$iv) {
                int it$iv3 = n2++;
                boolean bl4 = false;
                rl$iv22.lock();
            }
            wl$iv.unlock();
        }
        UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$loadScriptDefinitions_u24lambda_u2413.updateDefinitions();
        if (updateDefinitionsResult2 != null) {
            updateDefinitionsResult2.apply();
        }
        Object $this$writeWithCheckCanceled$iv2 = this.definitionsLock;
        boolean $i$f$writeWithCheckCanceled2 = false;
        ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).readLock();
        int readCount$iv2 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).getReadHoldCount() : 0;
        int rl$iv22 = 0;
        while (rl$iv22 < readCount$iv2) {
            int it$iv4 = rl$iv22++;
            boolean bl5 = false;
            rl$iv.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv2 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv2).writeLock();
        while (!wl$iv2.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            ArrayList arrayList;
            Set<ScriptDefinitionsSource> set2;
            boolean bl6 = false;
            Set<ScriptDefinitionsSource> it = set2 = this.sourcesToReload;
            boolean bl7 = false;
            Set<ScriptDefinitionsSource> set3 = !((Collection)it).isEmpty() ? set2 : null;
            if (set3 != null) {
                it = set3;
                boolean bl8 = false;
                ArrayList copy = new ArrayList(it);
                it.clear();
                arrayList = copy;
            } else {
                arrayList = null;
            }
            it$iv4 = arrayList;
        }
        finally {
            int n3 = 0;
            while (n3 < readCount$iv2) {
                int it$iv5 = n3++;
                boolean bl9 = false;
                rl$iv.lock();
            }
            wl$iv2.unlock();
        }
        ArrayList arrayList = it$iv4;
        if (arrayList != null) {
            void $this$forEach$iv;
            $this$writeWithCheckCanceled$iv2 = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptDefinitionsSource p0 = (ScriptDefinitionsSource)element$iv;
                boolean bl10 = false;
                this.reloadDefinitionsBy(p0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reorderScriptDefinitions() {
        block11: {
            UpdateDefinitionsResult updateDefinitionsResult;
            KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
            if (kotlinScriptingSettings == null) {
                return;
            }
            KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
            ScriptDefinitionsManager $this$reorderScriptDefinitions_u24lambda_u2421 = this;
            boolean bl = false;
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = $this$reorderScriptDefinitions_u24lambda_u2421.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            int n = 0;
            while (n < readCount$iv) {
                int it$iv = n++;
                boolean bl2 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                Unit unit2;
                boolean bl3 = false;
                List<? extends ScriptDefinition> list2 = $this$reorderScriptDefinitions_u24lambda_u2421.definitions;
                if (list2 != null) {
                    List<? extends ScriptDefinition> list3 = list2;
                    boolean bl4 = false;
                    Iterable $this$forEach$iv = list3;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                        boolean bl5 = false;
                        it.setOrder(scriptingSettings.getScriptDefinitionOrder(it));
                    }
                    Iterable $this$sortedBy$iv = list3;
                    boolean $i$f$sortedBy = false;
                    $this$reorderScriptDefinitions_u24lambda_u2421.definitions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            ScriptDefinition p0 = (ScriptDefinition)((Object)a);
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(p0.getOrder());
                            p0 = (ScriptDefinition)((Object)b);
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrder()));
                        }
                    });
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Unit unit3 = unit2;
            }
            finally {
                int n2 = 0;
                while (n2 < readCount$iv) {
                    int it$iv = n2++;
                    boolean bl6 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = $this$reorderScriptDefinitions_u24lambda_u2421.updateDefinitions();
            if (updateDefinitionsResult2 == null) break block11;
            updateDefinitionsResult2.apply();
        }
    }

    private final KotlinScriptingSettings kotlinScriptingSettingsSafe() {
        boolean bl;
        boolean bl2 = bl = !this.definitionsLock.isWriteLockedByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "kotlinScriptingSettingsSafe should be called out if the write lock to avoid deadlocks";
            throw new AssertionError((Object)string2);
        }
        return (KotlinScriptingSettings)ActionsKt.runReadAction((Function0)((Function0)new Function0<KotlinScriptingSettings>(this){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final KotlinScriptingSettings invoke() {
                return !ScriptDefinitionsManager.access$getProject$p(this.this$0).isDisposed() ? KotlinScriptingSettings.Companion.getInstance(ScriptDefinitionsManager.access$getProject$p(this.this$0)) : null;
            }
        }));
    }

    @NotNull
    public final List<ScriptDefinition> getAllDefinitions() {
        List<ScriptDefinition> list2 = this.definitions;
        if (list2 == null) {
            ScriptDefinitionsManager $this$getAllDefinitions_u24lambda_u2423 = this;
            boolean bl = false;
            $this$getAllDefinitions_u24lambda_u2423.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list3 = $this$getAllDefinitions_u24lambda_u2423.definitions;
            list2 = list3;
            Intrinsics.checkNotNull(list3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        boolean bl;
        block11: {
            Set<ScriptDefinitionsSource> it$iv2;
            if (this.definitions == null) {
                return false;
            }
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            int n = 0;
            while (n < readCount$iv) {
                int it$iv2 = n++;
                boolean bl2 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl3 = false;
                it$iv2 = this.definitionsBySource.keySet();
            }
            finally {
                int n2 = 0;
                while (n2 < readCount$iv) {
                    int it$iv3 = n2++;
                    boolean bl4 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            Set<ScriptDefinitionsSource> keys = it$iv2;
            Iterable $this$all$iv = keys;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ScriptDefinitionsSource source = (ScriptDefinitionsSource)element$iv;
                    boolean bl5 = false;
                    ScriptDefinitionContributor scriptDefinitionContributor = source instanceof ScriptDefinitionContributor ? (ScriptDefinitionContributor)((Object)source) : null;
                    if (!(scriptDefinitionContributor != null ? !scriptDefinitionContributor.isReady() : false)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        ScriptDefinitionContributor.Companion companion = ScriptDefinitionContributor.Companion;
        Project project$iv = this.project;
        boolean $i$f$find = false;
        List list2 = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.getPoint(project).extensionList");
        Iterable $this$filterIsInstance$iv$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof StandardScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor = (StandardScriptDefinitionContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        if (standardScriptDefinitionContributor == null) {
            throw new IllegalStateException("StandardScriptDefinitionContributor should be registered in plugin.xml".toString());
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor2 = standardScriptDefinitionContributor;
        return new ScriptDefinition.FromLegacy(this.getScriptingHostConfiguration(), (KotlinScriptDefinition)((Object)CollectionsKt.last(standardScriptDefinitionContributor2.getDefinitions())), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final UpdateDefinitionsResult updateDefinitions() {
        void $this$filterTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = !this.definitionsLock.isWriteLockedByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = false;
            String $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = "updateDefinitions should be called out the write lock";
            throw new AssertionError((Object)$i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22);
        }
        if (this.project.isDisposed()) {
            return null;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Iterable $this$filter$iv = SequencesKt.toSet(this.getKnownFilenameExtensions());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType fileTypeByExtension;
            boolean notKnown;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager.getFileTypeByFileName("xxx." + it), (String)"fileTypeManager.getFileTypeByFileName(\"xxx.$it\")");
            boolean bl4 = notKnown = !Intrinsics.areEqual((Object)fileTypeByExtension, (Object)KotlinFileType.INSTANCE);
            if (notKnown) {
                ScriptUtilsKt.scriptingWarnLog("extension " + it + " file type [" + fileTypeByExtension.getName() + "] is not registered as " + KotlinFileType.INSTANCE.getName());
            }
            if (!notKnown) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set newExtensions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.clearCache();
        CheckCanceledLock this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock = false;
        while (!this_$iv.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl5 = false;
            this.scriptDefinitionsCache.clear();
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.getLock().unlock();
        }
        return new UpdateDefinitionsResult(this.project, newExtensions);
    }

    private final List<ScriptDefinition> safeGetDefinitions(ScriptDefinitionsSource $this$safeGetDefinitions) {
        if (!this.failedContributorsHashes.contains($this$safeGetDefinitions.hashCode())) {
            try {
                return SequencesKt.toList($this$safeGetDefinitions.getDefinitions());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.failedContributorsHashes.add($this$safeGetDefinitions.hashCode());
                Object object = t.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = t.getMessage();
                }
                ScriptUtilsKt.scriptingErrorLog("Cannot load script definitions from " + $this$safeGetDefinitions + ": " + (String)object, t);
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
        this.definitionsBySource.clear();
        this.definitions = null;
        this.failedContributorsHashes.clear();
        this.scriptDefinitionsCache.clear();
        this.configurations = null;
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptDefinitionsManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,496:1\n29#2,3:497\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n*L\n307#1:497,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ScriptDefinitionsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "", "project", "Lcom/intellij/openapi/project/Project;", "newExtensions", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getNewExtensions", "()Ljava/util/Set;", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.base.scripting"})
    private static final class UpdateDefinitionsResult {
        @NotNull
        private final Project project;
        @NotNull
        private final Set<String> newExtensions;

        public UpdateDefinitionsResult(@NotNull Project project2, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            this.project = project2;
            this.newExtensions = newExtensions;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Set<String> getNewExtensions() {
            return this.newExtensions;
        }

        public final void apply() {
            if (!((Collection)this.newExtensions).isEmpty()) {
                ScriptUtilsKt.scriptingWarnLog("extensions " + this.newExtensions + " is about to be registered as " + KotlinFileType.INSTANCE.getName());
                ApplicationManager.getApplication().invokeLater(() -> UpdateDefinitionsResult.apply$lambda$0(this));
            }
            ScriptConfigurationManager.Companion.getInstance(this.project).updateScriptDefinitionReferences();
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Set<String> component2() {
            return this.newExtensions;
        }

        @NotNull
        public final UpdateDefinitionsResult copy(@NotNull Project project2, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            return new UpdateDefinitionsResult(project2, newExtensions);
        }

        public static /* synthetic */ UpdateDefinitionsResult copy$default(UpdateDefinitionsResult updateDefinitionsResult, Project project2, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = updateDefinitionsResult.project;
            }
            if ((n & 2) != 0) {
                set2 = updateDefinitionsResult.newExtensions;
            }
            return updateDefinitionsResult.copy(project2, set2);
        }

        @NotNull
        public String toString() {
            return "UpdateDefinitionsResult(project=" + this.project + ", newExtensions=" + this.newExtensions + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + ((Object)this.newExtensions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof UpdateDefinitionsResult)) {
                return false;
            }
            UpdateDefinitionsResult updateDefinitionsResult = (UpdateDefinitionsResult)other2;
            if (!Intrinsics.areEqual((Object)this.project, (Object)updateDefinitionsResult.project)) {
                return false;
            }
            return Intrinsics.areEqual(this.newExtensions, updateDefinitionsResult.newExtensions);
        }

        private static final void apply$lambda$0(UpdateDefinitionsResult this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0, fileTypeManager){
                final /* synthetic */ UpdateDefinitionsResult this$0;
                final /* synthetic */ FileTypeManager $fileTypeManager;
                {
                    this.this$0 = $receiver;
                    this.$fileTypeManager = $fileTypeManager;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.this$0.getNewExtensions();
                    FileTypeManager fileTypeManager = this.$fileTypeManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        fileTypeManager.associateExtension((FileType)KotlinFileType.INSTANCE, it);
                    }
                }
            }));
        }
    }
}

