/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.surroundWith;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public final class KotlinSurrounderUtils {
    @NlsContexts.DialogTitle
    public static String SURROUND_WITH() {
        return KotlinIdeaCoreBundle.message("surround.with.title", new Object[0]);
    }

    @NlsContexts.DialogMessage
    public static String SURROUND_WITH_ERROR() {
        return KotlinIdeaCoreBundle.message("surround.with.error.cannot.perform.action", new Object[0]);
    }

    private KotlinSurrounderUtils() {
    }

    public static void addStatementsInBlock(@NotNull KtBlockExpression block2, @NotNull PsiElement[] statements2) {
        if (block2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(0);
        }
        if (statements2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(1);
        }
        PsiElement lBrace = block2.getFirstChild();
        block2.addRangeAfter(statements2[0], statements2[statements2.length - 1], lBrace);
    }

    public static void showErrorHint(@NotNull Project project2, @NotNull Editor editor2, @NlsContexts.DialogMessage @NotNull String message2) {
        if (project2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(3);
        }
        if (message2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(4);
        }
        KotlinSurrounderUtils.showErrorHint(project2, editor2, message2, KotlinSurrounderUtils.SURROUND_WITH(), null);
    }

    public static void showErrorHint(@NotNull Project project2, @NotNull Editor editor2, @NlsContexts.DialogMessage @NotNull String message2, @NlsContexts.DialogTitle @NotNull String title, @Nullable String helpId) {
        if (project2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(6);
        }
        if (message2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(7);
        }
        if (title == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(message2);
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)title, (String)helpId);
    }

    public static boolean isUsedAsStatement(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(9);
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsStatement((KtExpression)expression2, (BindingContext)context2);
    }

    public static boolean isUsedAsExpression(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(10);
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsExpression((KtElement)expression2, (BindingContext)context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/surroundWith/KotlinSurrounderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addStatementsInBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

