/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointTypeKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "createJavaBreakpoint", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaMethodBreakpointProperties;", "getPriority", "isKtFileWithCommonOrJvmPlatform", "kotlin.jvm-debugger.core"})
public final class KotlinFunctionBreakpointType
extends JavaMethodBreakpointType
implements KotlinBreakpointType {
    public KotlinFunctionBreakpointType() {
        super("kotlin-function", KotlinDebuggerCoreBundle.message("function.breakpoint.tab.title", new Object[0]));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinFunctionBreakpoint createJavaBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return new KotlinFunctionBreakpoint(project2, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.isKtFileWithCommonOrJvmPlatform(file2, project2) && KotlinFunctionBreakpointTypeKt.isFunctionBreakpointApplicable(file2, line, project2);
    }

    private final boolean isKtFileWithCommonOrJvmPlatform(VirtualFile file2, Project project2) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return false;
        }
        KtFile psiFile3 = ktFile;
        TargetPlatform platform2 = TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile3);
        return TargetPlatformKt.isCommon((TargetPlatform)platform2) || JvmPlatformKt.isJvm((TargetPlatform)platform2);
    }
}

