/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.CapturedAsFieldValueData;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.CapturedValuesSearcherKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ExistingVariable;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ExistingVariables;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.LabeledThisData;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ThisLabelUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "", "()V", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "Container", "Ordinary", "This", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$This;", "kotlin.jvm-debugger.core"})
abstract class PendingValue {
    private PendingValue() {
    }

    @Nullable
    public abstract DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables var1);

    public /* synthetic */ PendingValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "value", "Lcom/sun/jdi/ObjectReference;", "(Lcom/sun/jdi/ObjectReference;)V", "getValue", "()Lcom/sun/jdi/ObjectReference;", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "getChildren", "", "isApplicable", "", "Lcom/sun/jdi/Field;", "kotlin.jvm-debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCapturedValuesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedValuesSearcher.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n1603#2,9:137\n1855#2:146\n1856#2:148\n1612#2:149\n1#3:147\n*S KotlinDebug\n*F\n+ 1 CapturedValuesSearcher.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container\n*L\n49#1:134\n49#1:135,2\n50#1:137,9\n50#1:146\n50#1:148\n50#1:149\n50#1:147\n*E\n"})
    public static final class Container
    extends PendingValue {
        @NotNull
        private final ObjectReference value;

        public Container(@NotNull ObjectReference value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            super(null);
            this.value = value2;
        }

        @NotNull
        public final ObjectReference getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PendingValue> getChildren() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            ReferenceType referenceType = this.value.referenceType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"value.referenceType()");
            Iterable $this$filter$iv = SafeUtilKt.safeFields(referenceType);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!this.isApplicable(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PendingValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Field it = (Field)element$iv$iv;
                boolean bl2 = false;
                if (CapturedValuesSearcherKt.access$createPendingValue(this, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isApplicable(Field $this$isApplicable) {
            String name2 = $this$isApplicable.name();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
            return StringsKt.startsWith$default((String)name2, (String)"$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"this$0");
        }

        @Override
        @Nullable
        public DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables existingVariables) {
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            throw new IllegalStateException("Should not be called on a container");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "name", "", "field", "Lcom/sun/jdi/Field;", "container", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "(Ljava/lang/String;Lcom/sun/jdi/Field;Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;)V", "getContainer", "()Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "getField", "()Lcom/sun/jdi/Field;", "getName", "()Ljava/lang/String;", "addTo", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/CapturedAsFieldValueData;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "kotlin.jvm-debugger.core"})
    public static final class Ordinary
    extends PendingValue {
        @NotNull
        private final String name;
        @NotNull
        private final Field field;
        @NotNull
        private final Container container;

        public Ordinary(@NotNull String name2, @NotNull Field field2, @NotNull Container container2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            super(null);
            this.name = name2;
            this.field = field2;
            this.container = container2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final Container getContainer() {
            return this.container;
        }

        @Nullable
        public CapturedAsFieldValueData addTo(@NotNull ExistingVariables existingVariables) {
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            if (!existingVariables.add(new ExistingVariable.Ordinary(this.name))) {
                return null;
            }
            return new CapturedAsFieldValueData(this.name, this.container.getValue(), this.field);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$This;", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "label", "", "value", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLabel", "()Ljava/lang/String;", "getValue", "()Lcom/sun/jdi/Value;", "addTo", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "kotlin.jvm-debugger.core"})
    public static final class This
    extends PendingValue {
        @NotNull
        private final String label;
        @Nullable
        private final Value value;

        public This(@NotNull String label2, @Nullable Value value2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            super(null);
            this.label = label2;
            this.value = value2;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public DescriptorData<? extends ValueDescriptorImpl> addTo(@NotNull ExistingVariables existingVariables) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
            if (existingVariables.getHasThisVariables()) {
                if (!existingVariables.add(new ExistingVariable.LabeledThis(this.label))) {
                    return null;
                }
                string2 = ThisLabelUtilsKt.getThisName(this.label);
            } else {
                if (!existingVariables.add(new ExistingVariable.LabeledThis(this.label))) {
                    return null;
                }
                string2 = "this";
            }
            String thisName = string2;
            return new LabeledThisData(this.label, thisName, this.value);
        }
    }
}

