/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.fir.low.level.api.ide;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/fir/low/level/api/ide/SealedClassInheritorsProviderIdeImpl;", "Lorg/jetbrains/kotlin/fir/declarations/SealedClassInheritorsProvider;", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "", "getCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "getInheritors", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getPackageViaDirectoryService", "Lcom/intellij/psi/PsiPackage;", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getSealedClassInheritors", "getSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "Lcom/intellij/openapi/module/Module;", "psiPackage", "kotlin.fir.fir-low-level-api-ide-impl"})
@SourceDebugExtension(value={"SMAP\nSealedClassInheritorsProviderIdeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SealedClassInheritorsProviderIdeImpl.kt\norg/jetbrains/kotlin/idea/fir/low/level/api/ide/SealedClassInheritorsProviderIdeImpl\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n59#2:73\n1#3:74\n1#3:85\n1603#4,9:75\n1855#4:84\n1856#4:86\n1612#4:87\n1002#4,2:88\n*S KotlinDebug\n*F\n+ 1 SealedClassInheritorsProviderIdeImpl.kt\norg/jetbrains/kotlin/idea/fir/low/level/api/ide/SealedClassInheritorsProviderIdeImpl\n*L\n30#1:73\n52#1:85\n52#1:75,9\n52#1:84\n52#1:86\n52#1:87\n56#1:88,2\n*E\n"})
public final class SealedClassInheritorsProviderIdeImpl
extends SealedClassInheritorsProvider {
    @NotNull
    private final ConcurrentHashMap<ClassId, List<ClassId>> cache = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<ClassId, List<ClassId>> getCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public List<ClassId> getSealedClassInheritors(@NotNull FirRegularClass firClass) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        FirRegularClass $this$isSealed$iv = firClass;
        boolean $i$f$isSealed = false;
        if (!($this$isSealed$iv.getStatus().getModality() == Modality.SEALED)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Lazy<List<ClassId>> lazy = SealedClassInheritorsKt.getSealedInheritorsAttr(firClass);
        if (lazy != null && (list2 = (List)lazy.getValue()) != null) {
            List it = list2;
            boolean bl = false;
            return it;
        }
        List list3 = this.cache.computeIfAbsent(FirDeclarationUtilKt.getClassId(firClass), arg_0 -> SealedClassInheritorsProviderIdeImpl.getSealedClassInheritors$lambda$1((Function1)new Function1<ClassId, List<? extends ClassId>>(this, firClass){
            final /* synthetic */ SealedClassInheritorsProviderIdeImpl this$0;
            final /* synthetic */ FirRegularClass $firClass;
            {
                this.this$0 = $receiver;
                this.$firClass = $firClass;
                super(1);
            }

            @NotNull
            public final List<ClassId> invoke(@NotNull ClassId it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SealedClassInheritorsProviderIdeImpl.access$getInheritors(this.this$0, this.$firClass);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"@OptIn(SealedClassInheri\u2026eritors(firClass) }\n    }");
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> getInheritors(FirRegularClass firClass) {
        List subclasses;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        PsiElement psiElement2 = UtilsKt.getPsi(firClass);
        KtClass ktClass2 = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
        if (ktClass2 == null) {
            return CollectionsKt.emptyList();
        }
        KtClass sealedKtClass = ktClass2;
        Module module2 = GenericPsiUtils.getModule((PsiElement)sealedKtClass);
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        Module module3 = module2;
        FqName fqName2 = FirDeclarationUtilKt.getClassId(firClass).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"firClass.classId.packageFqName");
        FqName containingPackage = fqName2;
        PsiPackage psiPackage = KotlinJavaPsiFacade.getInstance((Project)sealedKtClass.getProject()).findPackage(containingPackage.asString(), GlobalSearchScope.moduleScope((Module)module3));
        if (psiPackage == null && (psiPackage = this.getPackageViaDirectoryService(sealedKtClass)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiPackage psiPackage2 = psiPackage;
        Project project2 = sealedKtClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"sealedKtClass.project");
        KotlinAsJavaSupport kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(project2);
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)sealedKtClass));
        if (ktLightClass == null) {
            ktLightClass = (KtLightClass)kotlinAsJavaSupport.getFakeLightClass((KtClassOrObject)sealedKtClass);
        }
        KtLightClass lightClass = ktLightClass;
        SearchScope searchScope2 = (SearchScope)this.getSearchScope(module3, psiPackage2);
        ClassInheritorsSearch.SearchParameters searchParameters2 = new ClassInheritorsSearch.SearchParameters((PsiClass)lightClass, searchScope2, false, true, false);
        Query query = ClassInheritorsSearch.search((ClassInheritorsSearch.SearchParameters)searchParameters2);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(searchParameters)");
        Iterable iterable = (Iterable)query;
        boolean $i$f$mapNotNull = false;
        void var13_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (JavaPsiUtils.getClassIdIfNonLocal(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List $this$sortBy$iv = subclasses = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ClassId it = (ClassId)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.toString());
                    it = (ClassId)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                }
            });
        }
        return subclasses;
    }

    private final GlobalSearchScope getSearchScope(Module module2, PsiPackage psiPackage) {
        PackageScope packageScope = new PackageScope(psiPackage, false, false);
        GlobalSearchScope globalSearchScope = module2.getModuleScope().intersectWith((GlobalSearchScope)packageScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.moduleScope.intersectWith(packageScope)");
        return globalSearchScope;
    }

    private final PsiPackage getPackageViaDirectoryService(KtClass ktClass2) {
        PsiDirectory psiDirectory = ktClass2.getContainingFile().getContainingDirectory();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory directory = psiDirectory;
        return JavaDirectoryService.getInstance().getPackage(directory);
    }

    private static final List getSealedClassInheritors$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getInheritors(SealedClassInheritorsProviderIdeImpl $this, FirRegularClass firClass) {
        return $this.getInheritors(firClass);
    }
}

