/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.groovy.KotlinGroovyBundle;
import org.jetbrains.kotlin.idea.groovy.inspections.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.PluginVersionDependentInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J2\u0010\u0012\u001a, \u0017*\u0015\u0018\u00010\u0005\u00a2\u0006\u000e\b\u0013\u0012\n\b\u0014\u0012\u0006\b\n0\u00158\u00160\u0005\u00a2\u0006\u000e\b\u0013\u0012\n\b\u0014\u0012\u0006\b\n0\u00158\u0016H\u0016R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "Lorg/jetbrains/kotlin/idea/inspections/PluginVersionDependentInspection;", "()V", "<set-?>", "", "testVersionMessage", "getTestVersionMessage", "()Ljava/lang/String;", "setTestVersionMessage", "(Ljava/lang/String;)V", "buildErrorString", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "getGroupDisplayName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "kotlin.jvm.PlatformType", "Companion", "MyVisitor", "VersionFinder", "kotlin.gradle.code-insight-groovy"})
public final class DifferentKotlinGradleVersionInspection
extends BaseInspection
implements PluginVersionDependentInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String testVersionMessage;

    @Override
    @Nullable
    public String getTestVersionMessage() {
        return this.testVersionMessage;
    }

    @Override
    @TestOnly
    public void setTestVersionMessage(@Nullable String string2) {
        this.testVersionMessage = string2;
    }

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    public String getGroupDisplayName() {
        return BaseInspection.getProbableBugs();
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[]{args[0], args[1]};
        return KotlinGroovyBundle.message("error.text.different.kotlin.gradle.version", objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$Companion;", "", "()V", "getKotlinPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "gradleFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "kotlin.gradle.code-insight-groovy"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IdeKotlinVersion getKotlinPluginVersion(@NotNull GroovyFileBase gradleFile) {
            Intrinsics.checkNotNullParameter((Object)gradleFile, (String)"gradleFile");
            Ref.ObjectRef version2 = new Ref.ObjectRef();
            VersionFinder visitor2 = new VersionFinder((Ref.ObjectRef<IdeKotlinVersion>)version2){
                final /* synthetic */ Ref.ObjectRef<IdeKotlinVersion> $version;
                {
                    this.$version = $version;
                }

                public void visitElement(@NotNull GroovyPsiElement element3) {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    element3.acceptChildren((GroovyElementVisitor)this);
                }

                protected void onFound(@NotNull IdeKotlinVersion kotlinPluginVersion, @NotNull GrCallExpression kotlinPluginStatement) {
                    Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
                    Intrinsics.checkNotNullParameter((Object)kotlinPluginStatement, (String)"kotlinPluginStatement");
                    this.$version.element = kotlinPluginVersion;
                }
            };
            gradleFile.accept((GroovyElementVisitor)visitor2);
            return (IdeKotlinVersion)version2.element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$VersionFinder;", "(Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection;)V", "onFound", "", "kotlinPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "kotlinPluginStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "kotlin.gradle.code-insight-groovy"})
    private final class MyVisitor
    extends VersionFinder {
        @Override
        protected void onFound(@NotNull IdeKotlinVersion kotlinPluginVersion, @NotNull GrCallExpression kotlinPluginStatement) {
            Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            Intrinsics.checkNotNullParameter((Object)kotlinPluginStatement, (String)"kotlinPluginStatement");
            LanguageVersion latestSupportedLanguageVersion = KotlinPluginLayout.getIdeCompilerVersion().getLanguageVersion();
            LanguageVersion projectLanguageVersion = kotlinPluginVersion.getLanguageVersion();
            if (latestSupportedLanguageVersion.compareTo((Enum)projectLanguageVersion) < 0 || projectLanguageVersion.compareTo((Enum)LanguageVersion.FIRST_SUPPORTED) < 0) {
                PsiElement psiElement2 = (PsiElement)kotlinPluginStatement;
                Object[] objectArray = new Object[2];
                objectArray[0] = kotlinPluginVersion;
                String string2 = DifferentKotlinGradleVersionInspection.this.getTestVersionMessage();
                if (string2 == null) {
                    string2 = latestSupportedLanguageVersion;
                }
                objectArray[1] = string2;
                this.registerError(psiElement2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/KotlinGradleInspectionVisitor;", "()V", "onFound", "", "kotlinPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "kotlinPluginStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "kotlin.gradle.code-insight-groovy"})
    @SourceDebugExtension(value={"SMAP\nDifferentKotlinGradleVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentKotlinGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$VersionFinder\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n142#2:83\n142#2:84\n288#3,2:85\n*S KotlinDebug\n*F\n+ 1 DifferentKotlinGradleVersionInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DifferentKotlinGradleVersionInspection$VersionFinder\n*L\n37#1:83\n40#1:84\n43#1:85,2\n*E\n"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        protected abstract void onFound(@NotNull IdeKotlinVersion var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Object v3;
            block8: {
                Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
                super.visitClosure(closure);
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
                boolean $i$f$getStrictParentOfType = false;
                GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
                if (grMethodCall == null) {
                    return;
                }
                GrMethodCall dependenciesCall = grMethodCall;
                if (!Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies")) {
                    return;
                }
                PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)dependenciesCall;
                boolean $i$f$getStrictParentOfType2 = false;
                GrMethodCall grMethodCall2 = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, GrMethodCall.class, (boolean)true);
                if (grMethodCall2 == null) {
                    return;
                }
                GrMethodCall buildScriptCall = grMethodCall2;
                if (!Intrinsics.areEqual((Object)buildScriptCall.getInvokedExpression().getText(), (Object)"buildscript")) {
                    return;
                }
                Iterable $this$firstOrNull$iv = GradleHeuristicHelper.INSTANCE.findStatementWithPrefix(closure, "classpath");
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GrCallExpression it = (GrCallExpression)element$iv;
                    boolean bl = false;
                    String string2 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"org.jetbrains.kotlin:kotlin-gradle-plugin:", (boolean)false, (int)2, null)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            GrCallExpression grCallExpression = v3;
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression kotlinPluginStatement = grCallExpression;
            IdeKotlinVersion ideKotlinVersion = GradleHeuristicHelper.INSTANCE.getHeuristicVersionInBuildScriptDependency(kotlinPluginStatement);
            if (ideKotlinVersion == null) {
                PsiFile psiFile2 = closure.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"closure.containingFile");
                ideKotlinVersion = KotlinGradleInspectionVisitorKt.findResolvedKotlinGradleVersion(psiFile2);
                if (ideKotlinVersion == null) {
                    return;
                }
            }
            IdeKotlinVersion kotlinPluginVersion = ideKotlinVersion;
            this.onFound(kotlinPluginVersion, kotlinPluginStatement);
        }
    }
}

