/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulatorUtils;
import org.jetbrains.kotlin.idea.groovy.inspections.DeprecatedGradleDependencyInspection;
import org.jetbrains.kotlin.idea.groovy.inspections.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.groovy.inspections.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.groovy.inspections.GradleKotlinxCoroutinesDeprecationInspectionKt;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.inspections.migration.DeprecatedForKotlinLibInfo;
import org.jetbrains.kotlin.idea.inspections.migration.KotlinxVersionUpdaterKt;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationInfoKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/GradleKotlinxCoroutinesDeprecationInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "DependencyFinder", "kotlin.gradle.code-insight-groovy"})
public final class GradleKotlinxCoroutinesDeprecationInspection
extends BaseInspection
implements CleanupLocalInspectionTool,
MigrationFix {
    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return MigrationInfoKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3);
    }

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new DependencyFinder();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/GradleKotlinxCoroutinesDeprecationInspection$DependencyFinder;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/KotlinGradleInspectionVisitor;", "()V", "checkKotlinVersion", "", "file", "Lcom/intellij/psi/PsiFile;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "classpathEntry", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "deprecatedForKotlinInfo", "Lorg/jetbrains/kotlin/idea/inspections/migration/DeprecatedForKotlinLibInfo;", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "kotlin.gradle.code-insight-groovy"})
    @SourceDebugExtension(value={"SMAP\nGradleKotlinxCoroutinesDeprecationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleKotlinxCoroutinesDeprecationInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/GradleKotlinxCoroutinesDeprecationInspection$DependencyFinder\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n142#2:108\n26#3:109\n1747#4,3:110\n*S KotlinDebug\n*F\n+ 1 GradleKotlinxCoroutinesDeprecationInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/GradleKotlinxCoroutinesDeprecationInspection$DependencyFinder\n*L\n41#1:108\n83#1:109\n102#1:110,3\n*E\n"})
    private static class DependencyFinder
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
            boolean $i$f$getStrictParentOfType = false;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            if (!Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies")) {
                return;
            }
            List<GrCallExpression> dependencyEntries = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleBuildScriptManipulatorUtils.getSCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS());
            block0: for (GrCallExpression dependencyStatement : dependencyEntries) {
                for (DeprecatedForKotlinLibInfo outdatedInfo : KotlinxVersionUpdaterKt.getDEPRECATED_COROUTINES_LIBRARIES_INFORMATION()) {
                    LocalQuickFix[] localQuickFixArray;
                    String updatedVersion;
                    String libVersion;
                    String dependencyText = dependencyStatement.getText();
                    String libMarker = GradleKotlinxCoroutinesDeprecationInspectionKt.access$getGradleMarker(outdatedInfo.getLib());
                    Intrinsics.checkNotNullExpressionValue((Object)dependencyText, (String)"dependencyText");
                    if (!StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)libMarker, (boolean)false, (int)2, null)) continue;
                    PsiFile psiFile2 = dependencyStatement.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"dependencyStatement.containingFile");
                    if (!this.checkKotlinVersion(psiFile2, outdatedInfo.getSinceKotlinLanguageVersion())) {
                        return;
                    }
                    PsiFile psiFile3 = dependencyStatement.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"dependencyStatement.containingFile");
                    String string2 = DifferentStdlibGradleVersionInspection.Companion.getRawResolvedLibVersion(psiFile3, outdatedInfo.getLib().getGroupId(), CollectionsKt.listOf((Object)outdatedInfo.getLib().getName()));
                    if (string2 == null) {
                        PsiFile psiFile4 = dependencyStatement.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"dependencyStatement.containingFile");
                        string2 = DeprecatedGradleDependencyInspection.Companion.libraryVersionFromOrderEntry(psiFile4, outdatedInfo.getLib().getName());
                        if (string2 == null) continue;
                    }
                    if (Intrinsics.areEqual((Object)(libVersion = string2), (Object)(updatedVersion = outdatedInfo.getVersionUpdater().updateVersion(libVersion))) || StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)updatedVersion, (boolean)false, (int)2, null)) continue;
                    PsiElement reportOnElement = this.reportOnElement(dependencyStatement, outdatedInfo);
                    ReplaceStringInDocumentFix fix3 = StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)libVersion, (boolean)false, (int)2, null) ? new ReplaceStringInDocumentFix(reportOnElement, libVersion, updatedVersion) : null;
                    String string3 = outdatedInfo.getMessage();
                    if (fix3 != null) {
                        ReplaceStringInDocumentFix[] replaceStringInDocumentFixArray = new ReplaceStringInDocumentFix[]{fix3};
                        localQuickFixArray = replaceStringInDocumentFixArray;
                    } else {
                        boolean $i$f$emptyArray = false;
                        localQuickFixArray = new LocalQuickFix[]{};
                    }
                    this.registerError(reportOnElement, string3, localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    continue block0;
                }
            }
        }

        private final PsiElement reportOnElement(GrCallExpression classpathEntry, DeprecatedForKotlinLibInfo deprecatedForKotlinInfo) {
            String string2 = classpathEntry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classpathEntry.text");
            int indexOf = StringsKt.indexOf$default((CharSequence)string2, (String)deprecatedForKotlinInfo.getLib().getName(), (int)0, (boolean)false, (int)6, null);
            if (indexOf < 0) {
                return (PsiElement)classpathEntry;
            }
            PsiElement psiElement2 = classpathEntry.findElementAt(indexOf);
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)classpathEntry;
            }
            return psiElement2;
        }

        private final boolean checkKotlinVersion(PsiFile file2, LanguageVersion languageVersion) {
            boolean bl;
            block4: {
                Module module2 = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getModuleForFile(file2.getVirtualFile());
                if (module2 == null) {
                    return false;
                }
                Module module3 = module2;
                ModuleSourceRootGroup moduleGroup = ModuleSourceRootGroupUtils.getWholeModuleGroup(module3);
                Iterable $this$any$iv = moduleGroup.getSourceRootModules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Module moduleInGroup = (Module)element$iv;
                        boolean bl2 = false;
                        if (!(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(moduleInGroup).getLanguageVersion().compareTo((Enum)languageVersion) >= 0)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

