/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.idea.base.highlighting.HighlightingFactory;
import org.jetbrains.kotlin.idea.base.highlighting.dsl.DslStyleUtils;
import org.jetbrains.kotlin.idea.highlighting.highlighters.AfterResolveHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.DslHighlighterKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\rH\u0002R\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/DslHighlighter;", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "highlight", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "highlightCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "kotlin.highlighting"})
public final class DslHighlighter
extends AfterResolveHighlighter {
    public DslHighlighter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
    }

    @Override
    @NotNull
    public List<HighlightInfo.Builder> highlight(@NotNull KtAnalysisSession _context_receiver_0, @NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)_context_receiver_0, (String)"_context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtCallExpression ? CollectionsKt.listOfNotNull((Object)this.highlightCall(_context_receiver_0, (KtCallExpression)element3)) : CollectionsKt.emptyList();
    }

    private final HighlightInfo.Builder highlightCall(KtAnalysisSession _context_receiver_0, KtCallExpression element3) {
        KtExpression ktExpression = element3.getCalleeExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression calleeExpression2 = ktExpression;
        List list2 = element3.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return null;
        }
        KtLambdaArgument lambdaExpression2 = ktLambdaArgument;
        KtType ktType = _context_receiver_0.getKtType((KtExpression)lambdaExpression2);
        KtType ktType2 = ktType instanceof KtFunctionalType ? (KtFunctionalType)ktType : null;
        if (ktType2 == null || (ktType2 = ktType2.getReceiverType()) == null) {
            return null;
        }
        KtType receiverType2 = ktType2;
        ClassId classId = DslHighlighterKt.access$getDslAnnotation(_context_receiver_0, receiverType2);
        if (classId == null) {
            return null;
        }
        ClassId dslAnnotation = classId;
        FqName fqName2 = dslAnnotation.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"dslAnnotation.asSingleFqName()");
        int dslStyleId = DslStyleUtils.INSTANCE.styleIdByFQName(fqName2);
        return HighlightingFactory.INSTANCE.highlightName((PsiElement)calleeExpression2, DslStyleUtils.INSTANCE.typeById(dslStyleId), DslStyleUtils.INSTANCE.styleOptionDisplayName(dslStyleId));
    }
}

