/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.siyeh.ig.BaseGlobalInspection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.inspections.CheckResult;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.PackageNameInspectionLocal;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection;", "Lcom/siyeh/ig/BaseGlobalInspection;", "()V", "DEFAULT_PACKAGE_NAME_PATTERN", "", "namePattern", "getNamePattern$annotations", "getNamePattern", "()Ljava/lang/String;", "setNamePattern", "(Ljava/lang/String;)V", "namingSettings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "checkElement", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "refEntity", "Lcom/intellij/codeInspection/reference/RefEntity;", "analysisScope", "Lcom/intellij/analysis/AnalysisScope;", "inspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "globalInspectionContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "(Lcom/intellij/codeInspection/reference/RefEntity;Lcom/intellij/analysis/AnalysisScope;Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/codeInspection/GlobalInspectionContext;)[Lcom/intellij/codeInspection/CommonProblemDescriptor;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getSharedLocalInspectionTool", "Lcom/intellij/codeInspection/LocalInspectionTool;", "readSettings", "", "element", "Lorg/jdom/Element;", "kotlin.idea"})
public final class PackageNameInspection
extends BaseGlobalInspection {
    @NotNull
    private final String DEFAULT_PACKAGE_NAME_PATTERN;
    @NotNull
    private String namePattern;
    @NotNull
    private final NamingConventionInspectionSettings namingSettings;

    public PackageNameInspection() {
        this.namePattern = this.DEFAULT_PACKAGE_NAME_PATTERN = "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*";
        this.namingSettings = new NamingConventionInspectionSettings(KotlinBundle.message("text.Package", new Object[0]), this.DEFAULT_PACKAGE_NAME_PATTERN, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ PackageNameInspection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.this$0.setNamePattern(value2);
            }
        }));
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.namePattern = string2;
    }

    public static /* synthetic */ void getNamePattern$annotations() {
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        Intrinsics.checkNotNullParameter((Object)refEntity, (String)"refEntity");
        Intrinsics.checkNotNullParameter((Object)analysisScope, (String)"analysisScope");
        Intrinsics.checkNotNullParameter((Object)inspectionManager, (String)"inspectionManager");
        Intrinsics.checkNotNullParameter((Object)globalInspectionContext, (String)"globalInspectionContext");
        RefEntity refEntity2 = refEntity;
        if (refEntity2 instanceof RefFile) {
            KtPackageDirective packageDirective;
            PsiFile psiFile2 = ((RefFile)refEntity).getPsiElement();
            if (psiFile2 instanceof KtFile && !KotlinRefactoringUtilKt.isInjectedFragment(psiFile2) && !PackageUtilsKt.packageMatchesDirectoryOrImplicit((KtFile)psiFile2) && (packageDirective = ((KtFile)psiFile2).getPackageDirective()) != null) {
                String string2 = packageDirective.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageDirective.qualifiedName");
                String qualifiedName2 = string2;
                CheckResult checkResult = NamingConventionInspectionsKt.access$checkPackageDirective(packageDirective, this.namingSettings);
                if (checkResult != null) {
                    CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[1];
                    Intrinsics.checkNotNullExpressionValue((Object)inspectionManager.createProblemDescriptor(checkResult.toErrorMessage(qualifiedName2), new QuickFix[0]), (String)"inspectionManager.create\u2026orMessage(qualifiedName))");
                    return commonProblemDescriptorArray;
                }
            }
        } else if (refEntity2 instanceof RefPackage) {
            String string3 = StringUtil.getShortName((String)refEntity.getQualifiedName());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getShortName(refEntity.getQualifiedName())");
            String name2 = string3;
            if (((CharSequence)name2).length() == 0 || Intrinsics.areEqual((Object)InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]), (Object)name2)) {
                return null;
            }
            CheckResult checkResult = NamingConventionInspectionsKt.access$checkQualifiedName(name2, this.namingSettings);
            if (checkResult != null) {
                CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[1];
                Intrinsics.checkNotNullExpressionValue((Object)inspectionManager.createProblemDescriptor(checkResult.toErrorMessage(name2), new QuickFix[0]), (String)"inspectionManager.create\u2026ult.toErrorMessage(name))");
                return commonProblemDescriptorArray;
            }
        } else {
            return null;
        }
        return null;
    }

    public void readSettings(@NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super.readSettings(element3);
        this.namingSettings.setNamePattern(this.namePattern);
    }

    @NotNull
    public OptPane getOptionsPane() {
        return this.namingSettings.getOptionsPane();
    }

    @NotNull
    public OptionController getOptionController() {
        return this.namingSettings.getOptionController();
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new PackageNameInspectionLocal((InspectionProfileEntry)this, this.namingSettings);
    }
}

