/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineBlockingCallInspectionUtils;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineBlockingCallInspectionUtils$findFlowOnCall$;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001a\u001a\u00020\u00122\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u0014H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!J\u0017\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001c\u0018\u00010\u0014*\u00020#H\u0086\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils;", "", "()V", "BLOCKING_EXECUTOR_ANNOTATION", "", "COROUTINE_CONTEXT", "COROUTINE_NAME", "COROUTINE_SCOPE", "DEFAULT_DISPATCHER_FQN", "DISPATCHERS_FQN", "FLOW_FQN", "FLOW_ON_FQN", "FLOW_PACKAGE_FQN", "IO_DISPATCHER_FQN", "MAIN_DISPATCHER_FQN", "NONBLOCKING_EXECUTOR_ANNOTATION", "WITH_CONTEXT_FQN", "isCalledInsideNonIoContext", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isInSuspendLambdaOrFunction", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInsideFlowChain", "isKotlinxOnClasspath", "isNonBlockingDispatcher", "call", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "postProcessQuickFix", "", "replacedElement", "project", "Lcom/intellij/openapi/project/Project;", "findFlowOnCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCoroutineBlockingCallInspectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,104:1\n57#2,2:105\n57#2,2:108\n142#3:107\n142#3:113\n29#4,3:110\n473#5:114\n179#5,2:115\n*S KotlinDebug\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n*L\n34#1:105,2\n42#1:108,2\n36#1:107\n81#1:113\n49#1:110,3\n85#1:114\n87#1:115,2\n*E\n"})
public final class CoroutineBlockingCallInspectionUtils {
    @NotNull
    public static final CoroutineBlockingCallInspectionUtils INSTANCE = new CoroutineBlockingCallInspectionUtils();
    @NotNull
    public static final String BLOCKING_EXECUTOR_ANNOTATION = "org.jetbrains.annotations.BlockingExecutor";
    @NotNull
    public static final String NONBLOCKING_EXECUTOR_ANNOTATION = "org.jetbrains.annotations.NonBlockingExecutor";
    @NotNull
    private static final String DISPATCHERS_FQN = "kotlinx.coroutines.Dispatchers";
    @NotNull
    public static final String IO_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.IO";
    @NotNull
    public static final String MAIN_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.Main";
    @NotNull
    public static final String DEFAULT_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.Default";
    @NotNull
    public static final String COROUTINE_SCOPE = "kotlinx.coroutines.CoroutineScope";
    @NotNull
    public static final String COROUTINE_CONTEXT = "kotlin.coroutines.CoroutineContext";
    @NotNull
    private static final String FLOW_ON_FQN = "kotlinx.coroutines.flow.flowOn";
    @NotNull
    public static final String FLOW_PACKAGE_FQN = "kotlinx.coroutines.flow";
    @NotNull
    private static final String FLOW_FQN = "kotlinx.coroutines.flow.Flow";
    @NotNull
    public static final String WITH_CONTEXT_FQN = "kotlinx.coroutines.withContext";
    @NotNull
    public static final String COROUTINE_NAME = "kotlinx.coroutines.CoroutineName";

    private CoroutineBlockingCallInspectionUtils() {
    }

    public final boolean isInSuspendLambdaOrFunction(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)ktElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtLambdaArgument lambdaArgument = (KtLambdaArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLambdaArgument.class, (boolean)true);
        if (lambdaArgument != null) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)lambdaArgument;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)callExpression2, BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> call = resolvedCall2;
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(call, (ValueArgument)((ValueArgument)lambdaArgument));
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameterForArgument = valueParameterDescriptor;
            KotlinType kotlinType = parameterForArgument.getReturnType();
            return kotlinType != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)kotlinType) : false;
        }
        PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)ktElement;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, KtNamedFunction.class, (boolean)true);
        return ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isKotlinxOnClasspath(@NotNull KtElement ktElement) {
        void $this$service$iv;
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)ktElement));
        if (module2 == null) {
            return false;
        }
        Module module3 = module2;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module3);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithLibrariesScope(module)");
        GlobalSearchScope searchScope2 = globalSearchScope;
        Project project2 = module3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        ComponentManager componentManager = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<JavaPsiFacade> serviceClass$iv = JavaPsiFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return ((JavaPsiFacade)object).findClass(DISPATCHERS_FQN, searchScope2) != null;
    }

    public final boolean isInsideFlowChain(@NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
        Object object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
        boolean isFlowGenerator = object != null && (object = object.asString()) != null ? StringsKt.startsWith$default((String)object, (String)FLOW_PACKAGE_FQN, (boolean)false, (int)2, null) : false;
        KotlinType kotlinType = UtilsKt.receiverType(descriptor2);
        return Intrinsics.areEqual((Object)(kotlinType != null && (kotlinType = FqNameUtilKt.getFqName(kotlinType)) != null ? kotlinType.asString() : null), (Object)FLOW_FQN) || UtilsKt.receiverType(descriptor2) == null && isFlowGenerator;
    }

    public final boolean isCalledInsideNonIoContext(@NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Object object = resolvedCall2.getResultingDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return false;
        }
        Object callFqn = object;
        if (!Intrinsics.areEqual((Object)callFqn, (Object)WITH_CONTEXT_FQN)) {
            return false;
        }
        return this.isNonBlockingDispatcher(resolvedCall2);
    }

    private final boolean isNonBlockingDispatcher(ResolvedCall<? extends CallableDescriptor> call) {
        FqName fqName2;
        CallableDescriptor callableDescriptor;
        ResolvedCall resolvedCall2;
        KtExpression ktExpression = CallUtilKt.getFirstArgumentExpression(call);
        String dispatcherFqnOrNull = ktExpression != null && (resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)ktExpression, null, 1, null)) != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) != null && (fqName2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) != null ? fqName2.asString() : null;
        return dispatcherFqnOrNull != null && !Intrinsics.areEqual(dispatcherFqnOrNull, (Object)IO_DISPATCHER_FQN);
    }

    public final void postProcessQuickFix(@NotNull KtElement replacedElement, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)replacedElement, (String)"replacedElement");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtFile ktFile = replacedElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"replacedElement.containingKtFile");
        KtFile containingKtFile = ktFile;
        PsiElement psiElement2 = GenericPsiUtils.reformatted$default((PsiElement)replacedElement, false, 1, null);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement2, null, 2, null);
        new OptimizeImportsProcessor(project2, (PsiFile)containingKtFile).run();
        org.jetbrains.kotlin.idea.formatter.UtilsKt.commitAndUnblockDocument((PsiFile)containingKtFile);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ResolvedCall<? extends CallableDescriptor> findFlowOnCall(@NotNull KtExpression $this$findFlowOnCall) {
        ResolvedCall resolvedCall2;
        Intrinsics.checkNotNullParameter((Object)$this$findFlowOnCall, (String)"<this>");
        while (true) {
            ResolvedCall candidate2;
            Object v2;
            KtDotQualifiedExpression dotQualifiedExpression;
            block3: {
                void $this$firstOrNull$iv;
                Sequence $this$filterIsInstance$iv;
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$findFlowOnCall;
                boolean $i$f$getStrictParentOfType = false;
                if ((KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDotQualifiedExpression.class, (boolean)true) == null) {
                    return null;
                }
                PsiElement[] psiElementArray = dotQualifiedExpression.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"dotQualifiedExpression\n            .children");
                $this$getStrictParentOfType$iv = ArraysKt.asSequence((Object[])psiElementArray);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findFlowOnCall$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = SequencesKt.mapNotNull((Sequence)sequence2, (Function1)findFlowOnCall.candidate.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResolvedCall it = (ResolvedCall)element$iv;
                    boolean bl = false;
                    if (!FunctionUtilsKt.isCalling((ResolvedCall<? extends CallableDescriptor>)it, new FqName(FLOW_ON_FQN))) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            resolvedCall2 = candidate2 = (ResolvedCall)v2;
            if (resolvedCall2 != null) break;
            $this$findFlowOnCall = (KtExpression)dotQualifiedExpression;
        }
        return resolvedCall2;
    }
}

