/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.GeneralPostProcessing;
import org.jetbrains.kotlin.idea.j2k.post.processing.J2kPostProcessorKt;
import org.jetbrains.kotlin.idea.j2k.post.processing.NamedPostProcessingGroup;
import org.jetbrains.kotlin.idea.j2k.post.processing.UtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.JKPostProcessingTarget;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverterKt;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\b*\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor;", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "()V", "phasesCount", "", "getPhasesCount", "()I", "commitFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "doAdditionalProcessing", "target", "Lorg/jetbrains/kotlin/j2k/JKPostProcessingTarget;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "onPhaseChanged", "Lkotlin/Function2;", "", "insertImport", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "runProcessingConsideringOptions", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/GeneralPostProcessing;", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "Companion", "kotlin.j2k.post-processing"})
@SourceDebugExtension(value={"SMAP\nJ2kPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 J2kPostProcessor.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1855#2,2:306\n1855#2,2:308\n*S KotlinDebug\n*F\n+ 1 J2kPostProcessor.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor\n*L\n66#1:306,2\n70#1:308,2\n*E\n"})
public final class NewJ2kPostProcessor
implements PostProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int phasesCount = J2kPostProcessorKt.access$getProcessings$p().size();
    @NotNull
    private static final Logger LOG;

    @Override
    public void insertImport(@NotNull KtFile file2, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        UtilsKt.runUndoTransparentActionInEdt(true, (Function0<Unit>)((Function0)new Function0<Unit>(file2, fqName2){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ FqName $fqName;
            {
                this.$file = $file;
                this.$fqName = $fqName;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Collection<DeclarationDescriptor> descriptors2 = ResolutionUtils.resolveImportReference(this.$file, this.$fqName);
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)descriptors2);
                    if (declarationDescriptor == null) break block0;
                    DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                    KtFile ktFile = this.$file;
                    DeclarationDescriptor it = declarationDescriptor2;
                    boolean bl = false;
                    Project project2 = ktFile.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
                    ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project2), ktFile, it, false, 4, null);
                }
            }
        }));
    }

    @Override
    public int getPhasesCount() {
        return this.phasesCount;
    }

    @Override
    public void doAdditionalProcessing(@NotNull JKPostProcessingTarget target2, @Nullable ConverterContext converterContext, @Nullable Function2<? super Integer, ? super String, Unit> onPhaseChanged) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (!(converterContext instanceof NewJ2kConverterContext)) {
            throw new IllegalStateException("Invalid converter context for new J2K".toString());
        }
        Iterator iterator2 = J2kPostProcessorKt.access$getProcessings$p().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            NamedPostProcessingGroup group = (NamedPostProcessingGroup)iterator2.next();
            ProgressManager.checkCanceled();
            Function2<? super Integer, ? super String, Unit> function2 = onPhaseChanged;
            if (function2 != null) {
                function2.invoke((Object)i2, (Object)group.getDescription());
            }
            for (GeneralPostProcessing processing : group.getProcessings()) {
                ProgressManager.checkCanceled();
                try {
                    this.runProcessingConsideringOptions(processing, target2, (NewJ2kConverterContext)converterContext);
                    Iterable $this$forEach$iv = JavaToKotlinConverterKt.files(target2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean bl = false;
                        this.commitFile(p0);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Iterable $this$forEach$iv = JavaToKotlinConverterKt.files(target2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean bl = false;
                        this.commitFile(p0);
                    }
                    LOG.error(t);
                }
            }
        }
    }

    private final void runProcessingConsideringOptions(GeneralPostProcessing $this$runProcessingConsideringOptions, JKPostProcessingTarget target2, NewJ2kConverterContext converterContext) {
        if ($this$runProcessingConsideringOptions.getOptions().getDisablePostprocessingFormatting()) {
            PostprocessReformattingAspect.getInstance((Project)converterContext.getProject()).disablePostprocessFormattingInside(() -> NewJ2kPostProcessor.runProcessingConsideringOptions$lambda$1($this$runProcessingConsideringOptions, target2, converterContext));
        } else {
            $this$runProcessingConsideringOptions.runProcessing(target2, converterContext);
        }
    }

    private final void commitFile(KtFile file2) {
        UtilsKt.runUndoTransparentActionInEdt(true, (Function0<Unit>)((Function0)new Function0<Unit>(file2){
            final /* synthetic */ KtFile $file;
            {
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                DocumentUtilsKt.commitAndUnblockDocument((PsiFile)this.$file);
            }
        }));
    }

    private static final void runProcessingConsideringOptions$lambda$1(GeneralPostProcessing $this_runProcessingConsideringOptions, JKPostProcessingTarget $target, NewJ2kConverterContext $converterContext) {
        Intrinsics.checkNotNullParameter((Object)$this_runProcessingConsideringOptions, (String)"$this_runProcessingConsideringOptions");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$converterContext, (String)"$converterContext");
        $this_runProcessingConsideringOptions.runProcessing($target, $converterContext);
    }

    static {
        Logger logger = Logger.getInstance((String)"@org.jetbrains.kotlin.idea.j2k.post.processings.NewJ2kPostProcessor");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"@org.jetbra\u2026ngs.NewJ2kPostProcessor\")");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/NewJ2kPostProcessor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.j2k.post-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

