/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.ArgumentNameCommentInfo;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.JavaArgumentNameCommentUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/InconsistentCommentForJavaParameterInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CorrectNamesInCommentsToJavaCallArgumentsFix", "kotlin.code-insight.inspections-k2"})
public final class InconsistentCommentForJavaParameterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCallExpression(@NotNull KtCallExpression callExpression2) {
                Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                this.check((KtCallElement)callExpression2);
            }

            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitConstructorDelegationCall(@NotNull KtConstructorDelegationCall call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.check((KtCallElement)call);
            }

            public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
                Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
                this.check((KtCallElement)annotationEntry2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final void check(KtCallElement $this$check) {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                if (!JavaArgumentNameCommentUtilsKt.hasArgumentNameComments($this$check)) {
                    return;
                }
                ProblemsHolder problemsHolder = this.$holder;
                Object nonDefaultLifetimeTokenFactory$iv = null;
                boolean $i$f$analyze = false;
                Project project2 = ((KtElement)$this$check).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
                boolean $i$f$analyse = false;
                KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
                void var8_8 = this_$iv$iv;
                KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$check, factory$iv$iv);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                try {
                    Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> map2;
                    Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> expectedNameComments;
                    KtAnalysisSession $this$check_u24lambda_u241 = analysisSession$iv$iv$iv;
                    boolean bl = false;
                    if (JavaArgumentNameCommentUtilsKt.getArgumentNameComments($this$check_u24lambda_u241, $this$check) == null) {
                        return;
                    }
                    Map<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> $this$forEach$iv = expectedNameComments = map2;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo>> iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Object[] actualComment;
                        Object[] objectArray;
                        Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> element$iv;
                        Map.Entry<SmartPsiElementPointer<KtValueArgument>, ArgumentNameCommentInfo> entry = element$iv = iterator2.next();
                        boolean bl2 = false;
                        SmartPsiElementPointer<KtValueArgument> argumentPointer = entry.getKey();
                        ArgumentNameCommentInfo expected = entry.getValue();
                        Object[] objectArray2 = objectArray = (Object[])argumentPointer.getElement();
                        if (objectArray == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"element");
                        objectArray2 = JavaArgumentNameCommentUtilsKt.getBlockCommentWithName((KtValueArgument)objectArray);
                        if (objectArray2 == null || JavaArgumentNameCommentUtilsKt.isExpectedArgumentNameComment((PsiComment)(actualComment = objectArray2), expected)) continue;
                        PsiElement psiElement2 = (PsiElement)actualComment;
                        objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)expected.getArgumentName().asString(), (String)"expected.argumentName.asString()");
                        String string2 = KotlinBundle.message("inspection.message.inconsistent.parameter.name.for.0", objectArray);
                        objectArray = new LocalQuickFix[]{new CorrectNamesInCommentsToJavaCallArgumentsFix(expected.getComment())};
                        problemsHolder.registerProblem(psiElement2, string2, (LocalQuickFix[])objectArray);
                    }
                    Unit unit2 = Unit.INSTANCE;
                }
                finally {
                    factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                    this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "commentedParameterName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.code-insight.inspections-k2"})
    private static final class CorrectNamesInCommentsToJavaCallArgumentsFix
    implements LocalQuickFix {
        @NotNull
        private final String commentedParameterName;

        public CorrectNamesInCommentsToJavaCallArgumentsFix(@NotNull String commentedParameterName) {
            Intrinsics.checkNotNullParameter((Object)commentedParameterName, (String)"commentedParameterName");
            this.commentedParameterName = commentedParameterName;
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("intention.name.use.correct.parameter.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            PsiComment psiComment = psiElement2 instanceof PsiComment ? (PsiComment)psiElement2 : null;
            if (psiComment == null) {
                return;
            }
            PsiComment comment2 = psiComment;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            comment2.replace((PsiElement)factory2.createComment(this.commentedParameterName));
        }
    }
}

