/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J#\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0003\u001a\u00020\u0002H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "addArgumentToExistingAnnotation", "", "annotationEntry", "argumentText", "", "getFamilyName", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddFileAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public class AddFileAnnotationFix
extends KotlinQuickFixAction<KtFile> {
    @NotNull
    private final FqName annotationFqName;
    @Nullable
    private final FqName argumentClassFqName;
    @Nullable
    private final SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry;

    public AddFileAnnotationFix(@NotNull KtFile file2, @NotNull FqName annotationFqName, @Nullable FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file2);
        this.annotationFqName = annotationFqName;
        this.argumentClassFqName = argumentClassFqName;
        this.existingAnnotationEntry = existingAnnotationEntry;
    }

    public /* synthetic */ AddFileAnnotationFix(KtFile ktFile, FqName fqName2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName3 = null;
        }
        if ((n & 8) != 0) {
            smartPsiElementPointer = null;
        }
        this(ktFile, fqName2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
    }

    @NotNull
    public String getText() {
        Object object;
        String annotationName;
        block5: {
            block4: {
                String string2 = this.annotationFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotationFqName.shortName().asString()");
                annotationName = string2;
                object = this.argumentClassFqName;
                if (object == null || (object = object.shortName()) == null || (object = object.asString()) == null) break block4;
                Object it = object;
                boolean bl = false;
                String string3 = (String)it + "::class";
                object = string3;
                if (string3 != null) break block5;
            }
            object = "";
        }
        Object innerText2 = object;
        String annotationText2 = annotationName + "(" + (String)innerText2 + ")";
        Object[] objectArray = new Object[2];
        objectArray[0] = annotationText2;
        Object object2 = (KtFile)this.getElement();
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = "";
        }
        objectArray[1] = object2;
        return KotlinBundle.message("fix.add.annotation.text.containing.file", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.annotation.family", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtFile ktFile = (KtFile)this.getElement();
        if (ktFile == null) {
            return;
        }
        KtFile fileToAnnotate = ktFile;
        Object object = this.argumentClassFqName;
        if (object != null && (object = RenderingUtilsKt.render((FqName)object)) != null) {
            Object it = object;
            boolean bl = false;
            string2 = (String)it + "::class";
        } else {
            string2 = null;
        }
        String innerText2 = string2;
        String annotationText2 = innerText2 == null ? RenderingUtilsKt.render((FqName)this.annotationFqName) : RenderingUtilsKt.render((FqName)this.annotationFqName) + "(" + innerText2 + ")";
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        if (fileToAnnotate.getFileAnnotationList() == null) {
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(annotationText2);
            KtFileAnnotationList createdAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)fileToAnnotate, (KtFileAnnotationList)newAnnotationList);
            fileToAnnotate.addAfter(psiFactory.createWhiteSpace("\n"), (PsiElement)createdAnnotationList);
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)createdAnnotationList, null, 2, null);
        } else {
            KtFileAnnotationList ktFileAnnotationList = fileToAnnotate.getFileAnnotationList();
            if (ktFileAnnotationList == null) {
                return;
            }
            KtFileAnnotationList annotationList = ktFileAnnotationList;
            if (this.existingAnnotationEntry == null) {
                KtAnnotationEntry newAnnotation = psiFactory.createFileAnnotation(annotationText2);
                annotationList.add(psiFactory.createWhiteSpace("\n"));
                annotationList.add((PsiElement)newAnnotation);
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)annotationList, null, 2, null);
            } else if (innerText2 != null) {
                this.addArgumentToExistingAnnotation(this.existingAnnotationEntry, innerText2);
            }
        }
    }

    private final void addArgumentToExistingAnnotation(SmartPsiElementPointer<KtAnnotationEntry> annotationEntry2, String argumentText2) {
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)annotationEntry2.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry entry = ktAnnotationEntry;
        KtValueArgumentList existingArgumentList = entry.getValueArgumentList();
        Project project2 = entry.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"entry.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtValueArgumentList newArgumentList2 = psiFactory.createCallArguments("(" + argumentText2 + ")");
        if (existingArgumentList == null) {
            entry.addAfter((PsiElement)newArgumentList2, entry.getLastChild());
        } else if (existingArgumentList.getArguments().isEmpty()) {
            existingArgumentList.replace((PsiElement)newArgumentList2);
        } else {
            existingArgumentList.addArgument((KtValueArgument)newArgumentList2.getArguments().get(0));
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)entry, null, 2, null);
    }
}

