/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.ChangeMemberFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAnnotationNamesKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.VisibilityUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u001d\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "MyAction", "ParameterChooser", "Signature", "kotlin.idea"})
public final class ChangeMemberFunctionSignatureFix
extends KotlinQuickFixAction<KtNamedFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Signature> signatures;

    private ChangeMemberFunctionSignatureFix(KtNamedFunction element3, List<Signature> signatures) {
        super((PsiElement)element3);
        boolean bl;
        this.signatures = signatures;
        boolean bl2 = bl = !((Collection)this.signatures).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public String getText() {
        String string2;
        Signature single2 = (Signature)CollectionsKt.singleOrNull(this.signatures);
        if (single2 != null) {
            Object[] objectArray = new Object[]{single2.getPreview()};
            string2 = KotlinBundle.message("fix.change.signature.function.text", objectArray);
        } else {
            string2 = KotlinBundle.message("fix.change.signature.function.text.generic", new Object[0]);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.change.signature.function.family", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtNamedFunction ktNamedFunction = (KtNamedFunction)this.getElement();
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction element3 = ktNamedFunction;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ChangeMemberFunctionSignatureFix.invoke$lambda$0(project2, editor2, element3, this));
    }

    private static final void invoke$lambda$0(Project $project, Editor $editor, KtNamedFunction $element, ChangeMemberFunctionSignatureFix this$0) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        new MyAction($project, $editor, $element, this$0.signatures).execute();
    }

    public /* synthetic */ ChangeMemberFunctionSignatureFix(KtNamedFunction element3, List signatures, DefaultConstructorMarker $constructor_marker) {
        this(element3, signatures);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002JJ\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "computePossibleSignatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "functionElement", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getPossibleSuperFunctionsDescriptors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "matchParameters", "", "parameterChooser", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "superParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "newParameters", "", "matched", "Ljava/util/BitSet;", "used", "replaceFunctionParameters", "function", "signatureToMatch", "superFunction", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeMemberFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n603#2:361\n1360#3:362\n1446#3,5:363\n766#3:368\n857#3,2:369\n1549#3:371\n1620#3,3:372\n*S KotlinDebug\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion\n*L\n97#1:361\n177#1:362\n177#1:363,5\n178#1:368\n178#1:369,2\n207#1:371\n207#1:372,3\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            List<Signature> signatures = this.computePossibleSignatures(function2);
            if (signatures.isEmpty()) {
                return null;
            }
            return new ChangeMemberFunctionSignatureFix(function2, signatures, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Signature> computePossibleSignatures(KtNamedFunction functionElement) {
            void $this$sortedBy$iv;
            if (functionElement.getValueParameterList() == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny(functionElement, BodyResolveMode.FULL);
            if (functionDescriptor2 == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            List<FunctionDescriptor> superFunctions2 = this.getPossibleSuperFunctionsDescriptors(functionDescriptor3);
            Sequence sequence2 = SequencesKt.distinctBy((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)superFunctions2), (Function1)computePossibleSignatures.1.INSTANCE), (Function1)((Function1)new Function1<FunctionDescriptor, Signature>(functionDescriptor3){
                final /* synthetic */ FunctionDescriptor $functionDescriptor;
                {
                    this.$functionDescriptor = $functionDescriptor;
                    super(1);
                }

                @NotNull
                public final Signature invoke(@NotNull FunctionDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.quickfix.ChangeMemberFunctionSignatureFix$Companion.access$signatureToMatch(ChangeMemberFunctionSignatureFix.Companion, this.$functionDescriptor, it);
                }
            })), (Function1)computePossibleSignatures.3.INSTANCE);
            boolean $i$f$sortedBy = false;
            return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Signature it = (Signature)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPreview());
                    it = (Signature)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPreview())));
                }
            }));
        }

        private final Signature signatureToMatch(FunctionDescriptor function2, FunctionDescriptor superFunction) {
            List list2 = superFunction.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"superFunction.valueParameters");
            List superParameters = list2;
            List list3 = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"function.valueParameters");
            List parameters2 = list3;
            List newParameters2 = CollectionsKt.toMutableList((Collection)superParameters);
            BitSet matched = new BitSet(superParameters.size());
            BitSet used2 = new BitSet(superParameters.size());
            this.matchParameters(ParameterChooser.MatchNames.INSTANCE, superParameters, parameters2, newParameters2, matched, used2);
            this.matchParameters(ParameterChooser.MatchTypes.INSTANCE, superParameters, parameters2, newParameters2, matched, used2);
            Object[] objectArray = new FunctionDescriptor[]{superFunction, function2};
            FunctionDescriptor functionDescriptor2 = superFunction.copy(function2.getContainingDeclaration(), Modality.OPEN, VisibilityUtilKt.findMemberWithMaxVisibility((Collection)CollectionsKt.listOf((Object[])objectArray)).getVisibility(), CallableMemberDescriptor.Kind.DELEGATION, true);
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor2, (String)"superFunction.copy(\n    \u2026*/ true\n                )");
            FunctionDescriptor newFunction2 = this.replaceFunctionParameters(functionDescriptor2, newParameters2);
            DescriptorUtilsKt.setSingleOverridden((CallableMemberDescriptor)((CallableMemberDescriptor)newFunction2), (CallableMemberDescriptor)((CallableMemberDescriptor)superFunction));
            return new Signature(newFunction2);
        }

        private final void matchParameters(ParameterChooser parameterChooser, List<? extends ValueParameterDescriptor> superParameters, List<? extends ValueParameterDescriptor> parameters2, List<ValueParameterDescriptor> newParameters2, BitSet matched, BitSet used2) {
            block0: for (ValueParameterDescriptor valueParameterDescriptor : superParameters) {
                if (matched.get(valueParameterDescriptor.getIndex())) continue;
                for (ValueParameterDescriptor valueParameterDescriptor2 : parameters2) {
                    ValueParameterDescriptor choice = parameterChooser.choose(valueParameterDescriptor2, valueParameterDescriptor);
                    if (choice == null || used2.get(valueParameterDescriptor2.getIndex())) continue;
                    used2.set(valueParameterDescriptor2.getIndex(), true);
                    matched.set(valueParameterDescriptor.getIndex(), true);
                    newParameters2.set(valueParameterDescriptor.getIndex(), choice);
                    continue block0;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<FunctionDescriptor> getPossibleSuperFunctionsDescriptors(FunctionDescriptor functionDescriptor2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object = functionDescriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor containingClass = classDescriptor;
            Name name2 = functionDescriptor2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"functionDescriptor.name");
            Name name3 = name2;
            SimpleType simpleType = containingClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"containingClass.defaultType");
            object = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            boolean $i$f$flatMap = false;
            void var6_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinType supertype = (KotlinType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = supertype.getMemberScope().getContributedFunctions(name3, (LookupLocation)NoLookupLocation.FROM_IDE);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(it.getKind().isReal() && ModalityUtilsKt.isOverridable((CallableMemberDescriptor)((CallableMemberDescriptor)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final FunctionDescriptor replaceFunctionParameters(FunctionDescriptor function2, List<? extends ValueParameterDescriptor> newParameters2) {
            Collection<ReceiverParameterDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl2 = SimpleFunctionDescriptorImpl.create((DeclarationDescriptor)function2.getContainingDeclaration(), (Annotations)function2.getAnnotations(), (Name)function2.getName(), (CallableMemberDescriptor.Kind)function2.getKind(), (SourceElement)SourceElement.NO_SOURCE);
            Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl2, (String)"create(\n                \u2026t.NO_SOURCE\n            )");
            SimpleFunctionDescriptorImpl descriptor2 = simpleFunctionDescriptorImpl2;
            List parameters2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)newParameters2)), (Function1)((Function1)new Function1<IndexedValue<? extends ValueParameterDescriptor>, ValueParameterDescriptorImpl>(descriptor2){
                final /* synthetic */ SimpleFunctionDescriptorImpl $descriptor;
                {
                    this.$descriptor = $descriptor;
                    super(1);
                }

                @NotNull
                public final ValueParameterDescriptorImpl invoke(@NotNull IndexedValue<? extends ValueParameterDescriptor> indexedValue) {
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int index = indexedValue.component1();
                    ValueParameterDescriptor parameter2 = (ValueParameterDescriptor)indexedValue.component2();
                    CallableDescriptor callableDescriptor = (CallableDescriptor)this.$descriptor;
                    Annotations annotations2 = parameter2.getAnnotations();
                    Name name2 = parameter2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"parameter.name");
                    KotlinType kotlinType = parameter2.getReturnType();
                    Intrinsics.checkNotNull((Object)kotlinType);
                    boolean bl = parameter2.declaresDefaultValue();
                    boolean bl2 = parameter2.isCrossinline();
                    boolean bl3 = parameter2.isNoinline();
                    KotlinType kotlinType2 = parameter2.getVarargElementType();
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                    return new ValueParameterDescriptorImpl(callableDescriptor, null, index, annotations2, name2, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                }
            })));
            SimpleFunctionDescriptorImpl $this$replaceFunctionParameters_u24lambda_u244 = simpleFunctionDescriptorImpl = descriptor2;
            boolean bl = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = function2.getExtensionReceiverParameter();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.copy((DeclarationDescriptor)$this$replaceFunctionParameters_u24lambda_u244) : null;
            ReceiverParameterDescriptor receiverParameterDescriptor3 = function2.getDispatchReceiverParameter();
            List list2 = function2.getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"function.contextReceiverParameters");
            Iterable iterable = list2;
            ReceiverParameterDescriptor receiverParameterDescriptor4 = receiverParameterDescriptor3;
            ReceiverParameterDescriptor receiverParameterDescriptor5 = receiverParameterDescriptor2;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl3 = $this$replaceFunctionParameters_u24lambda_u244;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReceiverParameterDescriptor receiverParameterDescriptor6 = (ReceiverParameterDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.copy((DeclarationDescriptor)$this$replaceFunctionParameters_u24lambda_u244));
            }
            collection = (List)destination$iv$iv;
            simpleFunctionDescriptorImpl3.initialize(receiverParameterDescriptor5, receiverParameterDescriptor4, collection, function2.getTypeParameters(), parameters2, function2.getReturnType(), function2.getModality(), function2.getVisibility());
            $this$replaceFunctionParameters_u24lambda_u244.setOperator(function2.isOperator());
            $this$replaceFunctionParameters_u24lambda_u244.setInfix(function2.isInfix());
            $this$replaceFunctionParameters_u24lambda_u244.setExternal(function2.isExternal());
            $this$replaceFunctionParameters_u24lambda_u244.setInline(function2.isInline());
            $this$replaceFunctionParameters_u24lambda_u244.setTailrec(function2.isTailrec());
            $this$replaceFunctionParameters_u24lambda_u244.setSuspend(function2.isSuspend());
            return (FunctionDescriptor)simpleFunctionDescriptorImpl;
        }

        public static final /* synthetic */ Signature access$signatureToMatch(Companion $this, FunctionDescriptor function2, FunctionDescriptor superFunction) {
            return $this.signatureToMatch(function2, superFunction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "signaturePopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "getSignaturePopup", "()Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "changeSignature", "", "signature", "chooseSignatureAndChange", "execute", "kotlin.idea"})
    private static final class MyAction {
        @NotNull
        private final Project project;
        @Nullable
        private final Editor editor;
        @NotNull
        private final KtNamedFunction function;
        @NotNull
        private final List<Signature> signatures;

        public MyAction(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtNamedFunction function2, @NotNull List<Signature> signatures) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            this.project = project2;
            this.editor = editor2;
            this.function = function2;
            this.signatures = signatures;
        }

        public final void execute() {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            if (!this.function.isValid() || this.signatures.isEmpty()) {
                return;
            }
            if (this.signatures.size() == 1 || this.editor == null || !this.editor.getComponent().isShowing()) {
                this.changeSignature((Signature)CollectionsKt.first(this.signatures));
            } else {
                this.chooseSignatureAndChange();
            }
        }

        private final BaseListPopupStep<Signature> getSignaturePopup() {
            String string2 = KotlinBundle.message("fix.change.signature.function.popup.title", new Object[0]);
            List<Signature> list2 = this.signatures;
            return (BaseListPopupStep)new BaseListPopupStep<Signature>(this, string2, list2){
                final /* synthetic */ MyAction this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                }

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                @Nullable
                public PopupStep<?> onChosen(@NotNull Signature selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    if (finalChoice) {
                        MyAction.access$changeSignature(this.this$0, selectedValue);
                    }
                    return PopupStep.FINAL_CHOICE;
                }

                @NotNull
                public Icon getIconFor(@NotNull Signature aValue) {
                    Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                    return IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Function);
                }

                @NotNull
                public String getTextFor(@NotNull Signature aValue) {
                    Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                    return aValue.getPreview();
                }
            };
        }

        private final void changeSignature(Signature signature2) {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            ApplicationUtilsKt.executeWriteCommand(this.project, KotlinBundle.message("fix.change.signature.function.family", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this, signature2){
                final /* synthetic */ MyAction this$0;
                final /* synthetic */ Signature $signature;
                {
                    this.this$0 = $receiver;
                    this.$signature = $signature;
                    super(0);
                }

                public final void invoke() {
                    block13: {
                        block12: {
                            PsiElement psiElement2;
                            KtTypeParameterList patternTypeParameterList;
                            PsiElement psiElement3;
                            Object param2;
                            KtTypeReference newTypeRef;
                            KtNamedFunction patternFunction = new KtPsiFactory(MyAction.access$getProject$p(this.this$0), false, 2, null).createFunction(this.$signature.getSourceCode());
                            if (patternFunction.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                                MyAction.access$getFunction$p(this.this$0).addModifier(KtTokens.SUSPEND_KEYWORD);
                            }
                            if ((newTypeRef = MyAction.access$getFunction$p(this.this$0).setTypeReference(patternFunction.getTypeReference())) != null) {
                                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)newTypeRef, null, 2, null);
                            }
                            List list2 = patternFunction.getValueParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"patternFunction.valueParameters");
                            Iterable $this$forEach$iv = list2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                param2 = (KtParameter)element$iv;
                                boolean bl = false;
                                List list3 = param2.getAnnotationEntries();
                                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"param.annotationEntries");
                                Iterable $this$forEach$iv2 = list3;
                                boolean $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    KtTypeReference $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                                    KtAnnotationEntry a = (KtAnnotationEntry)element$iv2;
                                    boolean bl2 = false;
                                    if (a.getTypeReference() == null) continue;
                                    boolean bl3 = false;
                                    FqName fqName2 = new FqName($this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.getText());
                                    if (!CollectionsKt.plus((Collection)JvmAnnotationNamesKt.getNULLABLE_ANNOTATIONS(), (Iterable)JvmAnnotationNamesKt.getNOT_NULL_ANNOTATIONS()).contains(fqName2)) continue;
                                    a.delete();
                                }
                            }
                            KtParameterList ktParameterList = patternFunction.getValueParameterList();
                            if (ktParameterList != null) {
                                KtParameterList ktParameterList2 = ktParameterList;
                                param2 = this.this$0;
                                KtParameterList it = ktParameterList2;
                                boolean bl = false;
                                KtParameterList ktParameterList3 = MyAction.access$getFunction$p((MyAction)param2).getValueParameterList();
                                psiElement3 = ktParameterList3 != null ? ktParameterList3.replace((PsiElement)it) : null;
                            } else {
                                psiElement3 = null;
                            }
                            Intrinsics.checkNotNull(psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
                            KtParameterList newParameterList = (KtParameterList)psiElement3;
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)newParameterList, null, 2, null);
                            KtTypeReference patternFunctionReceiver = patternFunction.getReceiverTypeReference();
                            if (patternFunctionReceiver == null) {
                                if (MyAction.access$getFunction$p(this.this$0).getReceiverTypeReference() != null) {
                                    TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)MyAction.access$getFunction$p(this.this$0)), null);
                                }
                            } else {
                                KtTypeReference ktTypeReference = TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)MyAction.access$getFunction$p(this.this$0)), (KtTypeReference)patternFunction.getReceiverTypeReference());
                                if (ktTypeReference != null) {
                                    KtTypeReference it = ktTypeReference;
                                    boolean bl = false;
                                    ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)it, null, 2, null);
                                }
                            }
                            if ((patternTypeParameterList = patternFunction.getTypeParameterList()) == null) break block12;
                            if (MyAction.access$getFunction$p(this.this$0).getTypeParameterList() != null) {
                                KtTypeParameterList ktTypeParameterList = MyAction.access$getFunction$p(this.this$0).getTypeParameterList();
                                psiElement2 = ktTypeParameterList != null ? ktTypeParameterList.replace((PsiElement)patternTypeParameterList) : null;
                            } else {
                                psiElement2 = MyAction.access$getFunction$p(this.this$0).addAfter((PsiElement)patternTypeParameterList, MyAction.access$getFunction$p(this.this$0).getFunKeyword());
                            }
                            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterList");
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)((KtTypeParameterList)psiElement2), null, 2, null);
                            break block13;
                        }
                        KtTypeParameterList ktTypeParameterList = MyAction.access$getFunction$p(this.this$0).getTypeParameterList();
                        if (ktTypeParameterList == null) break block13;
                        ktTypeParameterList.delete();
                    }
                }
            }));
        }

        private final void chooseSignatureAndChange() {
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getSignaturePopup());
            Editor editor2 = this.editor;
            Intrinsics.checkNotNull((Object)editor2);
            listPopup.showInBestPositionFor(editor2);
        }

        public static final /* synthetic */ void access$changeSignature(MyAction $this, Signature signature2) {
            $this.changeSignature(signature2);
        }

        public static final /* synthetic */ Project access$getProject$p(MyAction $this) {
            return $this.project;
        }

        public static final /* synthetic */ KtNamedFunction access$getFunction$p(MyAction $this) {
            return $this.function;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bb\u0018\u00002\u00020\u0001:\u0002\u0006\u0007J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "MatchNames", "MatchTypes", "kotlin.idea"})
    private static interface ParameterChooser {
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor var1, @NotNull ValueParameterDescriptor var2);

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchNames;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "kotlin.idea"})
        @SourceDebugExtension(value={"SMAP\nChangeMemberFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeMemberFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchNames\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
        public static final class MatchNames
        implements ParameterChooser {
            @NotNull
            public static final MatchNames INSTANCE = new MatchNames();

            private MatchNames() {
            }

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter2, @NotNull ValueParameterDescriptor superParameter) {
                ValueParameterDescriptor valueParameterDescriptor;
                Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)superParameter, (String)"superParameter");
                ValueParameterDescriptor it = valueParameterDescriptor = superParameter;
                boolean bl = false;
                return Intrinsics.areEqual((Object)parameter2.getName(), (Object)superParameter.getName()) ? valueParameterDescriptor : null;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchTypes;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "kotlin.idea"})
        public static final class MatchTypes
        implements ParameterChooser {
            @NotNull
            public static final MatchTypes INSTANCE = new MatchTypes();

            private MatchTypes() {
            }

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter2, @NotNull ValueParameterDescriptor superParameter) {
                ValueParameterDescriptor valueParameterDescriptor;
                Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)superParameter, (String)"superParameter");
                if (KotlinTypeChecker.DEFAULT.equalTypes(parameter2.getType(), superParameter.getType())) {
                    CallableDescriptor callableDescriptor = parameter2.getContainingDeclaration();
                    Name name2 = parameter2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"parameter.name");
                    valueParameterDescriptor = superParameter.copy(callableDescriptor, name2, parameter2.getIndex());
                } else {
                    valueParameterDescriptor = null;
                }
                return valueParameterDescriptor;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "preview", "", "getPreview", "()Ljava/lang/String;", "sourceCode", "getSourceCode", "Companion", "kotlin.idea"})
    private static final class Signature {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String sourceCode;
        @NotNull
        private final String preview;
        @NotNull
        private static final DescriptorRenderer SIGNATURE_SOURCE_RENDERER = IdeDescriptorRenderers.SOURCE_CODE.withOptions((Function1)Companion.SIGNATURE_SOURCE_RENDERER.1.INSTANCE);
        @NotNull
        private static final DescriptorRenderer SIGNATURE_PREVIEW_RENDERER = DescriptorRenderer.Companion.withOptions((Function1)Companion.SIGNATURE_PREVIEW_RENDERER.1.INSTANCE);

        public Signature(@NotNull FunctionDescriptor function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            this.sourceCode = SIGNATURE_SOURCE_RENDERER.render((DeclarationDescriptor)function2);
            this.preview = SIGNATURE_PREVIEW_RENDERER.render((DeclarationDescriptor)function2);
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final String getPreview() {
            return this.preview;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature$Companion;", "", "()V", "SIGNATURE_PREVIEW_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "SIGNATURE_SOURCE_RENDERER", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

