/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.AddJvmStaticIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.quickfix.MakeMemberStaticFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0094\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getText", "invoke", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMakeMemberStaticFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakeMemberStaticFix.kt\norg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix\n+ 2 KtClassOrObject.kt\norg/jetbrains/kotlin/psi/KtClassOrObject\n*L\n1#1,91:1\n78#2,6:92\n*S KotlinDebug\n*F\n+ 1 MakeMemberStaticFix.kt\norg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix\n*L\n40#1:92,6\n*E\n"})
public final class MakeMemberStaticFix
extends KotlinQuickFixAction<KtNamedDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName JVM_STATIC_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");

    public MakeMemberStaticFix(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super((PsiElement)declaration2);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        KtNamedDeclaration ktNamedDeclaration;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtNamedDeclaration ktNamedDeclaration2 = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration2 == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration2;
        if (declaration2 instanceof KtClass) {
            if (declaration2.hasModifier(KtTokens.INNER_KEYWORD)) {
                declaration2.removeModifier(KtTokens.INNER_KEYWORD);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }
        KtNamedDeclaration copyDeclaration = (KtNamedDeclaration)PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)declaration2), (PsiFile)file2);
        Intrinsics.checkNotNullExpressionValue((Object)copyDeclaration, (String)"copyDeclaration");
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)copyDeclaration));
        if (ktClassOrObject == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        KtClassOrObject containingClass = ktClassOrObject;
        if (containingClass instanceof KtClass) {
            PsiElement anchor$iv;
            KtObjectDeclaration companionObject2 = KotlinPsiModificationUtils.getOrCreateCompanionObject((KtClass)containingClass);
            MoveMemberToCompanionObjectIntention.Factory.INSTANCE.removeModifiers((KtModifierListOwner)copyDeclaration);
            KtClassOrObject this_$iv = (KtClassOrObject)companionObject2;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement2 = body$iv.getRBrace();
            if (psiElement2 == null) {
                PsiElement psiElement3 = body$iv.getLastChild();
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
            Class[] classArray = new Class[]{PsiWhiteSpace.class};
            PsiElement psiElement4 = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])classArray);
            KtNamedDeclaration newDeclaration = (KtNamedDeclaration)((KtDeclaration)((KtNamedDeclaration)((psiElement4 != null ? psiElement4.getNextSibling() : null) instanceof PsiErrorElement ? body$iv.addBefore((PsiElement)((KtDeclaration)copyDeclaration), anchor$iv) : body$iv.addAfter((PsiElement)((KtDeclaration)copyDeclaration), anchor$iv))));
            copyDeclaration.delete();
            ktNamedDeclaration = newDeclaration;
        } else {
            ktNamedDeclaration = copyDeclaration;
        }
        KtNamedDeclaration copyDeclarationInCompanion = ktNamedDeclaration;
        AddJvmStaticIntention addJvmStaticIntention = new AddJvmStaticIntention();
        Intrinsics.checkNotNullExpressionValue((Object)copyDeclarationInCompanion, (String)"copyDeclarationInCompanion");
        if (addJvmStaticIntention.applicabilityRange(copyDeclarationInCompanion) != null) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)copyDeclarationInCompanion, JVM_STATIC_FQ_NAME, null, null, null, 14, null);
            CodeStyleManager.getInstance((Project)declaration2.getProject()).reformat((PsiElement)copyDeclarationInCompanion, true);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (declaration2 instanceof KtClass) {
            if (declaration2.hasModifier(KtTokens.INNER_KEYWORD)) {
                declaration2.removeModifier(KtTokens.INNER_KEYWORD);
            }
            return;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject containingClass = ktClassOrObject;
        if (containingClass instanceof KtClass) {
            MoveMemberToCompanionObjectIntention moveMemberToCompanionObjectIntention = new MoveMemberToCompanionObjectIntention();
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple = moveMemberToCompanionObjectIntention.retrieveConflictsAndUsages(project2, editor2, declaration2, (KtClass)containingClass);
            if (triple == null) {
                return;
            }
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple2 = triple;
            MultiMap conflicts2 = (MultiMap)triple2.component1();
            List externalUsages = (List)triple2.component2();
            List outerInstanceUsages = (List)triple2.component3();
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project2, conflicts2, null, (Function0)new Function0<Unit>(project2, moveMemberToCompanionObjectIntention, declaration2, (List<? extends UsageInfo>)externalUsages, (List<? extends UsageInfo>)outerInstanceUsages, editor2){
                final /* synthetic */ Project $project;
                final /* synthetic */ MoveMemberToCompanionObjectIntention $moveMemberToCompanionObjectIntention;
                final /* synthetic */ KtNamedDeclaration $declaration;
                final /* synthetic */ List<UsageInfo> $externalUsages;
                final /* synthetic */ List<UsageInfo> $outerInstanceUsages;
                final /* synthetic */ Editor $editor;
                {
                    this.$project = $project;
                    this.$moveMemberToCompanionObjectIntention = $moveMemberToCompanionObjectIntention;
                    this.$declaration = $declaration;
                    this.$externalUsages = $externalUsages;
                    this.$outerInstanceUsages = $outerInstanceUsages;
                    this.$editor = $editor;
                    super(0);
                }

                public final void invoke() {
                    ApplicationManagerEx.getApplicationEx().runWriteActionWithNonCancellableProgressInDispatchThread(KotlinBundle.message("making.member.static", new Object[0]), this.$project, null, arg_0 -> invoke.1.invoke$lambda$0((Function1)new Function1<ProgressIndicator, Unit>(this.$moveMemberToCompanionObjectIntention, this.$declaration, this.$externalUsages, this.$outerInstanceUsages, this.$editor){
                        final /* synthetic */ MoveMemberToCompanionObjectIntention $moveMemberToCompanionObjectIntention;
                        final /* synthetic */ KtNamedDeclaration $declaration;
                        final /* synthetic */ List<UsageInfo> $externalUsages;
                        final /* synthetic */ List<UsageInfo> $outerInstanceUsages;
                        final /* synthetic */ Editor $editor;
                        {
                            this.$moveMemberToCompanionObjectIntention = $moveMemberToCompanionObjectIntention;
                            this.$declaration = $declaration;
                            this.$externalUsages = $externalUsages;
                            this.$outerInstanceUsages = $outerInstanceUsages;
                            this.$editor = $editor;
                            super(1);
                        }

                        public final void invoke(ProgressIndicator it) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            KtNamedDeclaration movedDeclaration = this.$moveMemberToCompanionObjectIntention.doMove(it, this.$declaration, this.$externalUsages, this.$outerInstanceUsages, this.$editor);
                            MakeMemberStaticFix.access$invoke$makeStaticAndReformat(movedDeclaration, this.$editor);
                        }
                    }, arg_0));
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, 2, null);
        } else {
            MakeMemberStaticFix.invoke$makeStaticAndReformat(declaration2, editor2);
        }
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        Object object = (KtNamedDeclaration)this.getElement();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        return KotlinBundle.message("make.member.static.quickfix", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    private static final void invoke$makeStaticAndReformat(KtNamedDeclaration declaration2, Editor editor2) {
        AddJvmStaticIntention intention2 = new AddJvmStaticIntention();
        if (intention2.applicabilityRange(declaration2) != null) {
            intention2.applyTo(declaration2, editor2);
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<PsiElement>(declaration2){
                final /* synthetic */ KtNamedDeclaration $declaration;
                {
                    this.$declaration = $declaration;
                    super(0);
                }

                @NotNull
                public final PsiElement invoke() {
                    return CodeStyleManager.getInstance((Project)this.$declaration.getProject()).reformat((PsiElement)this.$declaration, true);
                }
            }));
        }
    }

    public static final /* synthetic */ void access$invoke$makeStaticAndReformat(KtNamedDeclaration declaration2, Editor editor2) {
        MakeMemberStaticFix.invoke$makeStaticAndReformat(declaration2, editor2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix$Companion;", "", "()V", "JVM_STATIC_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

