/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineActionHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH&J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u000fH&J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u001e\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineActionHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "helpId", "", "getHelpId", "()Ljava/lang/String;", "refactoringName", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getRefactoringName", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "canInlineKotlinElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSources", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "declaration", "getActionName", "inlineElement", "", "inlineKotlinElement", "isEnabledForLanguage", "language", "Lcom/intellij/lang/Language;", "showErrorHint", "message", "kotlin.idea"})
public abstract class KotlinInlineActionHandler
extends InlineActionHandler {
    @Nullable
    private final String helpId;

    public boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    public final boolean canInlineElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtElement ktElement = KotlinInlineActionHandlerKt.access$unwrapKotlinElement(element3);
        if (ktElement == null) {
            return false;
        }
        KtElement kotlinElement = ktElement;
        return this.canInlineKotlinElement(kotlinElement);
    }

    public final void inlineElement(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtElement ktElement = KotlinInlineActionHandlerKt.access$unwrapKotlinElement(element3);
        if (ktElement == null) {
            throw new IllegalStateException("Kotlin element not found".toString());
        }
        KtElement kotlinElement = ktElement;
        PsiElement psiElement2 = (PsiElement)kotlinElement;
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        KotlinInlineRefactoringFUSCollector.Companion.log(psiElement2, (Language)kotlinLanguage, false);
        this.inlineKotlinElement(project2, editor2, kotlinElement);
    }

    @NotNull
    public String getActionName(@Nullable PsiElement element3) {
        return this.getRefactoringName();
    }

    public abstract boolean canInlineKotlinElement(@NotNull KtElement var1);

    public abstract void inlineKotlinElement(@NotNull Project var1, @Nullable Editor var2, @NotNull KtElement var3);

    @NotNull
    public abstract String getRefactoringName();

    @Nullable
    public String getHelpId() {
        return this.helpId;
    }

    public final void showErrorHint(@NotNull Project project2, @Nullable Editor editor2, @NlsContexts.DialogMessage @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.getRefactoringName(), (String)this.getHelpId());
    }

    public final boolean checkSources(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtElement declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        boolean it = bl = declaration2.getContainingKtFile().isCompiled();
        boolean bl2 = false;
        if (it) {
            String string2 = DescriptiveNameUtil.getDescriptiveName((PsiElement)((PsiElement)declaration2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescriptiveName(declaration)");
            String declarationName2 = string2;
            Object[] objectArray = new Object[]{declarationName2};
            this.showErrorHint(project2, editor2, KotlinBundle.message("error.hint.text.cannot.inline.0.from.a.decompiled.file", objectArray));
        }
        return !bl;
    }
}

