/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt$checkMemberClashing$;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a/\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001aR\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0012j\b\u0012\u0004\u0012\u00020\u0010`\u0013H\u0002\u001a4\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001aR\u0010\u001a\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001aD\u0010\u001e\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0012j\b\u0012\u0004\u0012\u00020\u0010`\u0013H\u0002\u001a4\u0010\u001f\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006 "}, d2={"analyzePushDownConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;[Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/util/containers/MultiMap;", "checkConflicts", "", "conflicts", "targetClass", "membersToKeepAbstract", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "membersToPush", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "checkExternalUsages", "member", "targetClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "checkMemberClashing", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkSuperCalls", "checkVisibility", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\npushDownConflictsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pushDownConflictsUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/PushDownConflictsUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,237:1\n11383#2,9:238\n13309#2:247\n13310#2:249\n11392#2:250\n1#3:248\n473#4:251\n179#4,2:252\n*S KotlinDebug\n*F\n+ 1 pushDownConflictsUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/PushDownConflictsUtilsKt\n*L\n40#1:238,9\n40#1:247\n40#1:249\n40#1:250\n40#1:248\n141#1:251\n142#1:252,2\n*E\n"})
public final class PushDownConflictsUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<PsiElement, String> analyzePushDownConflicts(@NotNull KotlinPushDownContext context2, @NotNull UsageInfo[] usages2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        UsageInfo[] $this$mapNotNull$iv = usages2;
        boolean $i$f$mapNotNull = false;
        UsageInfo[] usageInfoArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PsiElement psiElement2;
            PsiElement psiElement3;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement4 = psiElement3 = it.getElement();
            if (psiElement4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"element");
                psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement3);
            } else {
                psiElement2 = null;
            }
            if (psiElement2 == null) continue;
            PsiElement it$iv$iv = psiElement2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List targetClasses = (List)destination$iv$iv;
        MultiMap conflicts2 = new MultiMap();
        ArrayList<KtNamedDeclaration> membersToPush = new ArrayList<KtNamedDeclaration>();
        ArrayList membersToKeepAbstract = new ArrayList();
        for (KotlinMemberInfo info2 : context2.getMembersToMove()) {
            KtNamedDeclaration member2 = (KtNamedDeclaration)info2.getMember();
            if (!info2.isChecked() || (member2 instanceof KtClassOrObject || member2 instanceof KtPsiClassWrapper) && info2.getOverrides() != null) continue;
            ((Collection)membersToPush).add(member2);
            if (!(member2 instanceof KtNamedFunction) && !(member2 instanceof KtProperty) || !info2.isToAbstract()) continue;
            DeclarationDescriptor declarationDescriptor = context2.getMemberDescriptors().get(member2);
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            if (((CallableMemberDescriptor)declarationDescriptor).getModality() == Modality.ABSTRACT) continue;
            ((Collection)membersToKeepAbstract).add(member2);
        }
        for (PsiElement targetClass : targetClasses) {
            PushDownConflictsUtilsKt.checkConflicts((MultiMap<PsiElement, String>)conflicts2, context2, targetClass, membersToKeepAbstract, membersToPush);
        }
        return conflicts2;
    }

    private static final void checkConflicts(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context2, PsiElement targetClass, List<? extends KtNamedDeclaration> membersToKeepAbstract, ArrayList<KtNamedDeclaration> membersToPush) {
        if (!(targetClass instanceof KtClassOrObject)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), (String)"getDescription(targetClass, false)");
            conflicts2.putValue((Object)targetClass, (Object)KotlinBundle.message("text.non.kotlin.0.will.not.be.affected.by.refactoring", objectArray));
            return;
        }
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.resolveToDescriptor$default(context2.getResolutionFacade(), (KtDeclaration)targetClass, null, 2, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor targetClassDescriptor2 = (ClassDescriptor)declarationDescriptor;
        SimpleType simpleType = context2.getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"context.sourceClassDescriptor.defaultType");
        SimpleType sourceClassType = simpleType;
        KotlinType kotlinType = (KotlinType)sourceClassType;
        SimpleType simpleType2 = targetClassDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"targetClassDescriptor.defaultType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = TypeUtils.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        TypeSubstitutor substitutor3 = TypeUtils.orEmpty((TypeSubstitutor)(linkedHashMap != null ? TypeUtils.toSubstitutor((Map<TypeConstructor, ? extends TypeProjection>)linkedHashMap) : null));
        if (!context2.getSourceClass().isInterface() && targetClass instanceof KtClass && ((KtClass)targetClass).isInterface()) {
            Object[] objectArray = new Object[]{PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)targetClassDescriptor2), PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)context2.getSourceClassDescriptor())};
            String message2 = KotlinBundle.message("text.0.inherits.from.1.it.will.not.be.affected.by.refactoring", objectArray);
            conflicts2.putValue((Object)targetClass, (Object)StringsKt.capitalize((String)message2));
        }
        for (KtNamedDeclaration member2 : membersToPush) {
            Intrinsics.checkNotNullExpressionValue((Object)member2, (String)"member");
            PushDownConflictsUtilsKt.checkMemberClashing(conflicts2, context2, member2, membersToKeepAbstract, substitutor3, (KtClassOrObject)targetClass, targetClassDescriptor2);
            PushDownConflictsUtilsKt.checkSuperCalls(conflicts2, context2, member2, membersToPush);
            PushDownConflictsUtilsKt.checkExternalUsages(conflicts2, (PsiElement)member2, targetClassDescriptor2, context2.getResolutionFacade());
            PushDownConflictsUtilsKt.checkVisibility(conflicts2, context2, member2, targetClassDescriptor2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkMemberClashing(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context2, KtNamedDeclaration member2, List<? extends KtNamedDeclaration> membersToKeepAbstract, TypeSubstitutor substitutor3, KtClassOrObject targetClass, ClassDescriptor targetClassDescriptor2) {
        block7: {
            Object v5;
            block5: {
                void $this$firstOrNull$iv;
                Sequence $this$filterIsInstance$iv;
                KtNamedDeclaration ktNamedDeclaration;
                block6: {
                    String message2;
                    Object[] objectArray;
                    KtNamedDeclaration clashingDeclaration;
                    ktNamedDeclaration = member2;
                    if (!(ktNamedDeclaration instanceof KtNamedFunction ? true : ktNamedDeclaration instanceof KtProperty)) break block6;
                    DeclarationDescriptor declarationDescriptor = context2.getMemberDescriptors().get(member2);
                    Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                    CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                    DeclarationDescriptorNonRoot declarationDescriptorNonRoot = memberDescriptor.substitute(substitutor3);
                    Intrinsics.checkNotNull((Object)declarationDescriptorNonRoot, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                    CallableMemberDescriptor clashingDescriptor = DescriptorUtilsKt.findCallableMemberBySignature$default(targetClassDescriptor2, (CallableMemberDescriptor)declarationDescriptorNonRoot, false, 2, null);
                    CallableMemberDescriptor callableMemberDescriptor = clashingDescriptor;
                    PsiElement psiElement2 = callableMemberDescriptor != null && (callableMemberDescriptor = callableMemberDescriptor.getSource()) != null ? PsiSourceElementKt.getPsi((SourceElement)callableMemberDescriptor) : null;
                    KtNamedDeclaration ktNamedDeclaration2 = clashingDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
                    if (clashingDescriptor == null || clashingDeclaration == null) break block7;
                    if (memberDescriptor.getModality() != Modality.ABSTRACT && !membersToKeepAbstract.contains(member2)) {
                        objectArray = new Object[]{PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)targetClassDescriptor2), PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)clashingDescriptor)};
                        message2 = KotlinBundle.message("text.0.already.contains.1", objectArray);
                        conflicts2.putValue((Object)clashingDeclaration, (Object)StringUtil.capitalize((String)message2));
                    }
                    if (!clashingDeclaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                        objectArray = new Object[]{PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)clashingDescriptor), PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)targetClassDescriptor2), PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)context2.getSourceClassDescriptor())};
                        message2 = KotlinBundle.message("text.0.in.1.will.override.corresponding.member.of.2.after.refactoring", objectArray);
                        conflicts2.putValue((Object)clashingDeclaration, (Object)StringUtil.capitalize((String)message2));
                    }
                    break block7;
                }
                if (!(ktNamedDeclaration instanceof KtClassOrObject)) break block7;
                Sequence clashingDescriptor = CollectionsKt.asSequence((Iterable)targetClass.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkMemberClashing$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((KtClassOrObject)member2).getName())) continue;
                    v5 = element$iv;
                    break block5;
                }
                v5 = null;
            }
            KtClassOrObject ktClassOrObject = v5;
            if (ktClassOrObject != null) {
                KtClassOrObject it = ktClassOrObject;
                boolean bl = false;
                Object[] objectArray = new Object[2];
                objectArray[0] = PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)targetClassDescriptor2);
                String string2 = ((KtClassOrObject)member2).getName();
                if (string2 == null) {
                    string2 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)CommonRefactoringUtil.htmlEmphasize((String)string2), (String)"htmlEmphasize(member.name ?: \"\")");
                String message3 = KotlinBundle.message("text.0.already.contains.nested.class.1", objectArray);
                conflicts2.putValue((Object)it, (Object)StringsKt.capitalize((String)message3));
            }
        }
    }

    private static final void checkSuperCalls(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context2, KtNamedDeclaration member2, ArrayList<KtNamedDeclaration> membersToPush) {
        member2.accept((PsiElementVisitor)new KtTreeVisitorVoid(context2, membersToPush, conflicts2){
            final /* synthetic */ KotlinPushDownContext $context;
            final /* synthetic */ ArrayList<KtNamedDeclaration> $membersToPush;
            final /* synthetic */ MultiMap<PsiElement, String> $conflicts;
            {
                this.$context = $context;
                this.$membersToPush = $membersToPush;
                this.$conflicts = $conflicts;
            }

            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)expression2));
                if (ktQualifiedExpression == null) {
                    return;
                }
                KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
                KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)qualifiedExpression.getSelectorExpression()));
                KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression refExpr = ktSimpleNameExpression;
                for (DeclarationDescriptor descriptor2 : KtReferenceKt.resolveToDescriptors((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)refExpr), this.$context.getSourceClassContext())) {
                    CallableMemberDescriptor memberInSource;
                    ClassDescriptor containingClass;
                    CallableMemberDescriptor memberDescriptor;
                    Object[] objectArray;
                    CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
                    if (callableMemberDescriptor == null || ((objectArray = (memberDescriptor = callableMemberDescriptor).getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)objectArray : null) == null) continue;
                    containingClass = containingClass;
                    if (!DescriptorUtils.isSubclass((ClassDescriptor)this.$context.getSourceClassDescriptor(), (ClassDescriptor)containingClass)) continue;
                    CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtilsKt.findCallableMemberBySignature$default(this.$context.getSourceClassDescriptor(), memberDescriptor, false, 2, null);
                    if (callableMemberDescriptor2 == null || (callableMemberDescriptor2 = callableMemberDescriptor2.getSource()) == null) continue;
                    if ((callableMemberDescriptor2 = PsiSourceElementKt.getPsi((SourceElement)callableMemberDescriptor2)) == null || CollectionsKt.contains((Iterable)this.$membersToPush, (Object)(memberInSource = callableMemberDescriptor2))) continue;
                    objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)qualifiedExpression.getText(), (String)"qualifiedExpression.text");
                    this.$conflicts.putValue((Object)qualifiedExpression, (Object)KotlinBundle.message("text.pushed.member.will.not.be.available.in.0", objectArray));
                }
            }
        });
    }

    public static final void checkExternalUsages(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull PsiElement member2, @NotNull ClassDescriptor targetClassDescriptor2, @NotNull ResolutionFacade resolutionFacade2) {
        Intrinsics.checkNotNullParameter(conflicts2, (String)"conflicts");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)targetClassDescriptor2, (String)"targetClassDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member2, (SearchScope)((SearchScope)member2.getResolveScope()), (boolean)false)) {
            KtElement callElement2;
            ClassDescriptor receiverClassDescriptor;
            ResolvedCall resolvedCall2;
            KtSimpleNameExpression calleeExpr;
            PsiElement psiElement2 = ref.getElement();
            KtSimpleNameExpression ktSimpleNameExpression = psiElement2 instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)psiElement2 : null;
            if (ktSimpleNameExpression == null || CallUtilKt.getResolvedCall((KtElement)((KtElement)(calleeExpr = ktSimpleNameExpression)), (BindingContext)ResolutionFacade.analyze$default(resolutionFacade2, (KtElement)calleeExpr, null, 2, null)) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2.getCall().getCallElement(), (String)"resolvedCall.call.callElement");
            ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
            if (dispatchReceiver == null || dispatchReceiver instanceof Qualifier) continue;
            ClassifierDescriptor classifierDescriptor = dispatchReceiver.getType().getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null || DescriptorUtils.isSubclass((ClassDescriptor)(receiverClassDescriptor = classDescriptor), (ClassDescriptor)targetClassDescriptor2)) continue;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)callElement2.getText(), (String)"callElement.text");
            conflicts2.putValue((Object)callElement2, (Object)KotlinBundle.message("text.pushed.member.will.not.be.available.in.0", objectArray));
        }
    }

    private static final void checkVisibility(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context2, KtNamedDeclaration member2, ClassDescriptor targetClassDescriptor2) {
        member2.accept((PsiElementVisitor)new KtTreeVisitorVoid(context2, targetClassDescriptor2, member2, conflicts2){
            final /* synthetic */ KotlinPushDownContext $context;
            final /* synthetic */ ClassDescriptor $targetClassDescriptor;
            final /* synthetic */ KtNamedDeclaration $member;
            final /* synthetic */ MultiMap<PsiElement, String> $conflicts;
            {
                this.$context = $context;
                this.$targetClassDescriptor = $targetClassDescriptor;
                this.$member = $member;
                this.$conflicts = $conflicts;
            }

            /*
             * WARNING - void declaration
             */
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                void $this$forEach$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitReferenceExpression(expression2);
                PsiReference[] psiReferenceArray = expression2.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"expression.references");
                Object[] objectArray = psiReferenceArray;
                KotlinPushDownContext kotlinPushDownContext = this.$context;
                boolean $i$f$flatMap = false;
                KtNamedDeclaration ktNamedDeclaration = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                    PsiReference it = (PsiReference)element$iv$iv;
                    boolean bl = false;
                    Object object = it instanceof KtReference ? (KtReference)it : null;
                    if (object == null || (object = KtReferenceKt.resolveToDescriptors(object, kotlinPushDownContext.getSourceClassContext())) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = (Iterable)object;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                kotlinPushDownContext = this.$targetClassDescriptor;
                KotlinPushDownContext kotlinPushDownContext2 = this.$context;
                ktNamedDeclaration = this.$member;
                MultiMap<PsiElement, String> multiMap = this.$conflicts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                    boolean bl = false;
                    PushDownConflictsUtilsKt.access$checkVisibility$reportConflictIfAny((ClassDescriptor)kotlinPushDownContext, kotlinPushDownContext2, ktNamedDeclaration, multiMap, p0);
                }
            }
        });
    }

    private static final void checkVisibility$reportConflictIfAny(ClassDescriptor $targetClassDescriptor, KotlinPushDownContext $context, KtNamedDeclaration $member, MultiMap<PsiElement, String> $conflicts, DeclarationDescriptor targetDescriptor) {
        DeclarationDescriptorWithSource declarationDescriptorWithSource = targetDescriptor instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)targetDescriptor : null;
        if (declarationDescriptorWithSource == null || (declarationDescriptorWithSource = declarationDescriptorWithSource.getSource()) == null || (declarationDescriptorWithSource = PsiSourceElementKt.getPsi((SourceElement)declarationDescriptorWithSource)) == null) {
            return;
        }
        DeclarationDescriptorWithSource target2 = declarationDescriptorWithSource;
        if (targetDescriptor instanceof DeclarationDescriptorWithVisibility && !DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((DeclarationDescriptorWithVisibility)targetDescriptor), (DeclarationDescriptor)((DeclarationDescriptor)$targetClassDescriptor), (LanguageVersionSettings)ResolutionFacadeKt.getLanguageVersionSettings($context.getResolutionFacade()))) {
            Object[] objectArray = new Object[3];
            Object object = MapsKt.getValue($context.getMemberDescriptors(), (Object)$member);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.memberDescriptors.getValue(member)");
            objectArray[0] = PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)object);
            objectArray[1] = PullUpConflictsUtilsKt.renderForConflicts(targetDescriptor);
            objectArray[2] = PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)$targetClassDescriptor);
            String message2 = KotlinBundle.message("text.0.uses.1.which.is.not.accessible.from.2", objectArray);
            $conflicts.putValue((Object)target2, (Object)StringsKt.capitalize((String)message2));
        }
    }

    public static final /* synthetic */ void access$checkVisibility$reportConflictIfAny(ClassDescriptor $targetClassDescriptor, KotlinPushDownContext $context, KtNamedDeclaration $member, MultiMap $conflicts, DeclarationDescriptor targetDescriptor) {
        PushDownConflictsUtilsKt.checkVisibility$reportConflictIfAny($targetClassDescriptor, $context, $member, (MultiMap<PsiElement, String>)$conflicts, targetDescriptor);
    }
}

