/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.kdoc.KDocElementFactory;
import org.jetbrains.kotlin.idea.refactoring.intentions.OperatorToFunctionConverter;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.KtArrayAccessReference;
import org.jetbrains.kotlin.idea.references.KtDefaultAnnotationArgumentReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceMutateService;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.references.SyntheticPropertyAccessorReference;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.plugin.references.SimpleNameReferenceExtension;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H$J\u001c\u0010\u0012\u001a\u00020\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH$J\u0014\u0010\u0015\u001a\u00020\n*\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH$\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "()V", "convertOperatorToFunctionCall", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "opExpression", "Lorg/jetbrains/kotlin/psi/KtOperationExpression;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "ktReference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "newElementName", "", "replaceWithImplicitInvokeInvocation", "newExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "renameImplicitConventionalCall", "Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "newName", "renameTo", "Lorg/jetbrains/kotlin/idea/references/KDocReference;", "Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/idea/references/KtDefaultAnnotationArgumentReference;", "Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/references/SyntheticPropertyAccessorReference;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKtReferenceMutateServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReferenceMutateServiceBase.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n21#2,7:146\n21#2,7:153\n179#3,2:160\n1#4:162\n*S KotlinDebug\n*F\n+ 1 KtReferenceMutateServiceBase.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase\n*L\n75#1:146,7\n78#1:153,7\n100#1:160,2\n*E\n"})
public abstract class KtReferenceMutateServiceBase
implements KtReferenceMutateService {
    @Nullable
    public PsiElement handleElementRename(@NotNull KtReference ktReference, @NotNull String newElementName) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)ktReference, (String)"ktReference");
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        KtReference ktReference2 = ktReference;
        if (ktReference2 instanceof KtArrayAccessReference) {
            psiElement2 = (PsiElement)this.renameTo((KtArrayAccessReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KDocReference) {
            psiElement2 = this.renameTo((KDocReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtInvokeFunctionReference) {
            psiElement2 = this.renameTo((KtInvokeFunctionReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtSimpleNameReference) {
            psiElement2 = (PsiElement)this.renameTo((KtSimpleNameReference)ktReference, newElementName);
        } else if (ktReference2 instanceof SyntheticPropertyAccessorReference) {
            psiElement2 = (PsiElement)this.renameTo((SyntheticPropertyAccessorReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtDefaultAnnotationArgumentReference) {
            psiElement2 = (PsiElement)this.renameTo((KtDefaultAnnotationArgumentReference)ktReference, newElementName);
        } else {
            throw new IncorrectOperationException();
        }
        return psiElement2;
    }

    private final KtExpression renameTo(KtArrayAccessReference $this$renameTo, String newElementName) {
        return this.renameImplicitConventionalCall((AbstractKtReference<? extends KtExpression>)((AbstractKtReference)$this$renameTo), newElementName);
    }

    private final PsiElement renameTo(KDocReference $this$renameTo, String newElementName) {
        TextRange textRange = ((KDocName)$this$renameTo.getElement()).getNameTextRange();
        String string2 = textRange.replace(((KDocName)$this$renameTo.getElement()).getText(), newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"textRange.replace(element.text, newElementName)");
        String newText = string2;
        Project project2 = ((KDocName)$this$renameTo.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KDocName newLink = new KDocElementFactory(project2).createNameFromText(newText);
        return ((KDocName)$this$renameTo.getElement()).replace((PsiElement)newLink);
    }

    private final PsiElement renameTo(KtInvokeFunctionReference $this$renameTo, String newElementName) {
        KtCallExpression callExpression2 = (KtCallExpression)$this$renameTo.getExpression();
        KtExpression fullCallExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)callExpression2));
        if (Intrinsics.areEqual((Object)newElementName, (Object)OperatorNameConventions.GET.asString()) && callExpression2.getTypeArguments().isEmpty()) {
            Project project2 = callExpression2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"callExpression.project");
            KtExpression arrayAccessExpression2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(fullCallExpression, callExpression2){
                final /* synthetic */ KtExpression $fullCallExpression;
                final /* synthetic */ KtCallExpression $callExpression;
                {
                    this.$fullCallExpression = $fullCallExpression;
                    this.$callExpression = $callExpression;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$this$buildExpression");
                    if (this.$fullCallExpression instanceof KtQualifiedExpression) {
                        $this$buildExpression.appendExpression(((KtQualifiedExpression)this.$fullCallExpression).getReceiverExpression());
                        String string2 = ((KtQualifiedExpression)this.$fullCallExpression).getOperationSign().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fullCallExpression.operationSign.value");
                        $this$buildExpression.appendFixedText(string2);
                    }
                    $this$buildExpression.appendExpression(this.$callExpression.getCalleeExpression());
                    $this$buildExpression.appendFixedText("[");
                    List list2 = this.$callExpression.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callExpression.valueArguments");
                    Iterable iterable = list2;
                    BuilderByPattern<KtExpression> builderByPattern = $this$buildExpression;
                    boolean $i$f$map = false;
                    void var4_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getArgumentExpression());
                    }
                    BuilderByPattern.appendExpressions$default(builderByPattern, (Iterable)((List)destination$iv$iv), null, (int)2, null);
                    $this$buildExpression.appendFixedText("]");
                }
            }), (int)1, null);
            PsiElement psiElement2 = fullCallExpression.replace((PsiElement)arrayAccessExpression2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"fullCallExpression.replace(arrayAccessExpression)");
            return psiElement2;
        }
        return (PsiElement)this.renameImplicitConventionalCall((AbstractKtReference<? extends KtExpression>)((AbstractKtReference)$this$renameTo), newElementName);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression renameTo(KtSimpleNameReference $this$renameTo, String newElementName) {
        PsiElement psiElement2;
        Object v10;
        KtPsiFactory psiFactory;
        block24: {
            void $this$firstOrNull$iv;
            if (!$this$renameTo.canRename()) {
                throw new IncorrectOperationException();
            }
            if (Intrinsics.areEqual((Object)KotlinPsiModificationUtils.unquoteKotlinIdentifier(newElementName), (Object)"")) {
                KtExpression ktExpression;
                KtElement qualifiedElement = KtPsiUtilKt.getQualifiedElement((KtSimpleNameExpression)((KtSimpleNameExpression)$this$renameTo.getExpression()));
                if (qualifiedElement instanceof KtQualifiedExpression) {
                    PsiElement psiElement3;
                    void $this$replaced$iv;
                    ((KtSimpleNameExpression)$this$renameTo.getExpression()).replace((PsiElement)((KtQualifiedExpression)qualifiedElement).getReceiverExpression());
                    PsiElement psiElement4 = (PsiElement)qualifiedElement;
                    KtExpression ktExpression2 = ((KtQualifiedExpression)qualifiedElement).getSelectorExpression();
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    PsiElement newElement$iv = (PsiElement)ktExpression2;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement3 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement3 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement3 = (PsiElement)ktExpression3;
                        }
                    }
                    ktExpression = (KtExpression)psiElement3;
                } else if (qualifiedElement instanceof KtUserType) {
                    PsiElement psiElement5;
                    PsiElement $this$replaced$iv = (PsiElement)$this$renameTo.getExpression();
                    KtPsiFactory ktPsiFactory = new KtPsiFactory($this$renameTo.getExpression(), false, 2, null);
                    String string2 = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEFAULT_NAME_FOR_COMPANION_OBJECT.asString()");
                    PsiElement newElement$iv = (PsiElement)ktPsiFactory.createSimpleName(string2);
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement5 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtSimpleNameExpression) {
                            psiElement5 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression4 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
                            }
                            psiElement5 = (PsiElement)((KtSimpleNameExpression)ktExpression4);
                        }
                    }
                    ktExpression = (KtExpression)psiElement5;
                } else {
                    ktExpression = (KtExpression)$this$renameTo.getExpression();
                }
                return ktExpression;
            }
            String expressionText2 = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getText();
            if (expressionText2 != null && Name.isValidIdentifier((String)expressionText2)) {
                Name name2 = Name.identifier((String)expressionText2);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(expressionText)");
                if (DataClassResolver.INSTANCE.isComponentLike(name2) && $this$renameTo.resolve() instanceof KtParameter) {
                    return (KtExpression)$this$renameTo.getExpression();
                }
            }
            psiFactory = new KtPsiFactory($this$renameTo.getExpression(), false, 2, null);
            Object[] objectArray = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getProject().getExtensionArea().getExtensionPoint(SimpleNameReferenceExtension.Companion.getEP_NAME()).getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"expression.project.exten\u2026nsion.EP_NAME).extensions");
            Sequence result$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<SimpleNameReferenceExtension, PsiElement>($this$renameTo, psiFactory, newElementName){
                final /* synthetic */ KtSimpleNameReference $this_renameTo;
                final /* synthetic */ KtPsiFactory $psiFactory;
                final /* synthetic */ String $newElementName;
                {
                    this.$this_renameTo = $receiver;
                    this.$psiFactory = $psiFactory;
                    this.$newElementName = $newElementName;
                    super(1);
                }

                @Nullable
                public final PsiElement invoke(@NotNull SimpleNameReferenceExtension it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.handleElementRename(this.$this_renameTo, this.$psiFactory, this.$newElementName);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v10 = element$iv;
                break block24;
            }
            v10 = null;
        }
        if ((psiElement2 = (PsiElement)v10) == null) {
            psiElement2 = psiFactory.createNameIdentifier(KtPsiUtilKt.quoteIfNeeded((String)newElementName));
        }
        PsiElement element3 = psiElement2;
        PsiElement nameElement = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getReferencedNameElement();
        IElementType iElementType = nameElement.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"nameElement.node.elementType");
        IElementType elementType = iElementType;
        if (elementType instanceof KtToken && OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)elementType)) != null) {
            KtOperationExpression opExpression;
            PsiElement psiElement6 = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getParent();
            KtOperationExpression ktOperationExpression = opExpression = psiElement6 instanceof KtOperationExpression ? (KtOperationExpression)psiElement6 : null;
            if (opExpression != null) {
                psiElement6 = this.convertOperatorToFunctionCall(opExpression);
                KtExpression newExpression2 = (KtExpression)psiElement6.component1();
                KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)psiElement6.component2();
                newNameElement.replace(element3);
                return newExpression2;
            }
        }
        if (Intrinsics.areEqual((Object)element3.getNode().getElementType(), (Object)KtTokens.IDENTIFIER)) {
            KtPsiUtilKt.astReplace((PsiElement)nameElement, (PsiElement)element3);
        } else {
            nameElement.replace(element3);
        }
        return (KtExpression)$this$renameTo.getExpression();
    }

    @Nullable
    protected abstract KtElement renameTo(@NotNull SyntheticPropertyAccessorReference var1, @NotNull String var2);

    @NotNull
    protected abstract KtValueArgument renameTo(@NotNull KtDefaultAnnotationArgumentReference var1, @NotNull String var2);

    private final Pair<KtExpression, KtSimpleNameExpression> convertOperatorToFunctionCall(KtOperationExpression opExpression) {
        return OperatorToFunctionConverter.INSTANCE.convert((KtExpression)opExpression);
    }

    @Nullable
    protected abstract KtExpression replaceWithImplicitInvokeInvocation(@NotNull KtDotQualifiedExpression var1);

    private final KtExpression renameImplicitConventionalCall(AbstractKtReference<? extends KtExpression> $this$renameImplicitConventionalCall, String newName2) {
        KtExpression ktExpression;
        Pair<KtExpression, KtSimpleNameExpression> pair = OperatorToFunctionConverter.INSTANCE.convert((KtExpression)$this$renameImplicitConventionalCall.getExpression());
        KtExpression newExpression2 = (KtExpression)pair.component1();
        KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)pair.component2();
        if (Intrinsics.areEqual((Object)OperatorNameConventions.INVOKE.asString(), (Object)newName2) && newExpression2 instanceof KtDotQualifiedExpression && (ktExpression = this.replaceWithImplicitInvokeInvocation((KtDotQualifiedExpression)newExpression2)) != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            return it;
        }
        ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)newNameElement).handleElementRename(newName2);
        return newExpression2;
    }
}

