/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "session", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "checkForErrors", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "execute", "", "parseOutput", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "stop", "findExpression", "psiElement", "Lcom/intellij/psi/PsiElement;", "lineStart", "", "lineEnd", "ProcessOutputParser", "kotlin.jvm"})
public final class KtCompilingExecutor
extends ScratchExecutor {
    @Nullable
    private KtScratchExecutionSession session;

    public KtCompilingExecutor(@NotNull ScratchFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(file2);
    }

    @Override
    public void execute() {
        block0: {
            this.getHandler().clear(this.getFile());
            this.getHandler().onStart(this.getFile());
            KtScratchExecutionSession ktScratchExecutionSession = this.session = new KtScratchExecutionSession(this.getFile(), this);
            if (ktScratchExecutionSession == null) break block0;
            ktScratchExecutionSession.execute((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ KtCompilingExecutor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    KtCompilingExecutor.access$getHandler(this.this$0).onFinish(KtCompilingExecutor.access$getFile(this.this$0));
                    KtCompilingExecutor.access$setSession$p(this.this$0, null);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.session == null) {
            return;
        }
        try {
            KtScratchExecutionSession ktScratchExecutionSession = this.session;
            if (ktScratchExecutionSession != null) {
                ktScratchExecutionSession.stop();
            }
        }
        finally {
            this.getHandler().onFinish(this.getFile());
        }
    }

    public final boolean checkForErrors(@NotNull KtFile psiFile2, @NotNull List<ScratchExpression> expressions2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        Project project2 = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        return (Boolean)DumbModeUtils.runReadActionInSmartMode(project2, (Function0)new Function0<Boolean>(psiFile2, this, expressions2){
            final /* synthetic */ KtFile $psiFile;
            final /* synthetic */ KtCompilingExecutor this$0;
            final /* synthetic */ List<ScratchExpression> $expressions;
            {
                this.$psiFile = $psiFile;
                this.this$0 = $receiver;
                this.$expressions = $expressions;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                void $this$filterTo$iv$iv;
                try {
                    AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)this.$psiFile));
                }
                catch (IllegalArgumentException e) {
                    ScratchExecutor scratchExecutor = this.this$0;
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)this.$psiFile.getName(), (String)"psiFile.name");
                        string2 = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                    }
                    ScratchExecutor.errorOccurs$default(scratchExecutor, string2, null, true, 2, null);
                    return false;
                }
                AnalysisResult analysisResult2 = ResolutionUtils.analyzeWithAllCompilerChecks(this.$psiFile, new KtFile[0]);
                if (analysisResult2.isError()) {
                    ScratchExecutor scratchExecutor = this.this$0;
                    String string3 = analysisResult2.getError().getMessage();
                    if (string3 == null) {
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)this.$psiFile.getName(), (String)"psiFile.name");
                        string3 = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                    }
                    ScratchExecutor.errorOccurs$default(scratchExecutor, string3, null, true, 2, null);
                    return false;
                }
                BindingContext bindingContext2 = analysisResult2.getBindingContext();
                Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"bindingContext.diagnostics");
                Iterable $this$filter$iv = (Iterable)diagnostics2;
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Diagnostic it = (Diagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List diagnostics3 = (List)destination$iv$iv;
                if (!((Collection)diagnostics3).isEmpty()) {
                    void $this$forEach$iv;
                    PsiFile scratchPsiFile = KtCompilingExecutor.access$getFile(this.this$0).getPsiFile();
                    Iterable $i$f$filter2 = diagnostics3;
                    iterable = this.$psiFile;
                    KtCompilingExecutor ktCompilingExecutor = this.this$0;
                    List<ScratchExpression> list2 = this.$expressions;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String errorText;
                        Diagnostic diagnostic = (Diagnostic)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic)), (String)"render(diagnostic)");
                        if (Intrinsics.areEqual((Object)iterable, (Object)scratchPsiFile)) {
                            if (Intrinsics.areEqual((Object)diagnostic.getPsiElement().getContainingFile(), (Object)iterable)) {
                                ScratchExpression scratchExpression = KtCompilingExecutor.access$findExpression(ktCompilingExecutor, list2, diagnostic.getPsiElement());
                                if (scratchExpression == null) {
                                    ScratchUtilsKt.getLOG().error("Couldn't find expression to report error: " + PsiUtilsKt.getElementTextWithContext((PsiElement)diagnostic.getPsiElement()));
                                    KtCompilingExecutor.access$getHandler(ktCompilingExecutor).error(KtCompilingExecutor.access$getFile(ktCompilingExecutor), errorText);
                                    continue;
                                }
                                KtCompilingExecutor.access$getHandler(ktCompilingExecutor).handle(KtCompilingExecutor.access$getFile(ktCompilingExecutor), scratchExpression, new ScratchOutput(errorText, ScratchOutputType.ERROR));
                                continue;
                            }
                            KtCompilingExecutor.access$getHandler(ktCompilingExecutor).error(KtCompilingExecutor.access$getFile(ktCompilingExecutor), errorText);
                            continue;
                        }
                        KtCompilingExecutor.access$getHandler(ktCompilingExecutor).error(KtCompilingExecutor.access$getFile(ktCompilingExecutor), errorText);
                    }
                    KtCompilingExecutor.access$getHandler(this.this$0).onFinish(KtCompilingExecutor.access$getFile(this.this$0));
                    return false;
                }
                return true;
            }
        });
    }

    public final void parseOutput(@NotNull ProcessOutput processOutput, @NotNull List<ScratchExpression> expressions2) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        new ProcessOutputParser(expressions2).parse(processOutput);
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, PsiElement psiElement2) {
        int elementLine = PsiLinesUtilsKt.getLineNumber$default(psiElement2, false, 1, null);
        return (ScratchExpression)ActionsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($this$findExpression, elementLine){
            final /* synthetic */ List<ScratchExpression> $this_findExpression;
            final /* synthetic */ int $elementLine;
            {
                this.$this_findExpression = $receiver;
                this.$elementLine = $elementLine;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ScratchExpression invoke() {
                Object v1;
                block1: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = this.$this_findExpression;
                    int n = this.$elementLine;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        int n2 = it.getLineStart();
                        boolean bl2 = n <= it.getLineEnd() ? n2 <= n : false;
                        if (!bl2) continue;
                        v1 = element$iv;
                        break block1;
                    }
                    v1 = null;
                }
                return v1;
            }
        }));
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, int lineStart, int lineEnd) {
        return (ScratchExpression)ActionsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($this$findExpression, lineStart, lineEnd){
            final /* synthetic */ List<ScratchExpression> $this_findExpression;
            final /* synthetic */ int $lineStart;
            final /* synthetic */ int $lineEnd;
            {
                this.$this_findExpression = $receiver;
                this.$lineStart = $lineStart;
                this.$lineEnd = $lineEnd;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = this.$this_findExpression;
                    int n = this.$lineStart;
                    int n2 = this.$lineEnd;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        if (!(it.getLineStart() == n && it.getLineEnd() == n2)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        }));
    }

    public static final /* synthetic */ void access$setSession$p(KtCompilingExecutor $this, KtScratchExecutionSession ktScratchExecutionSession) {
        $this.session = ktScratchExecutionSession;
    }

    public static final /* synthetic */ ScratchExpression access$findExpression(KtCompilingExecutor $this, List $receiver, PsiElement psiElement2) {
        return $this.findExpression($receiver, psiElement2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser;", "", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "(Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;Ljava/util/List;)V", "extractLineInfoFrom", "Lkotlin/Pair;", "", "encoded", "", "isGeneratedOutput", "", "line", "isOutputEnd", "isResultEnd", "parse", "", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "parseStdOut", "out", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nKtCompilingExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1855#2,2:183\n1855#2,2:185\n*S KotlinDebug\n*F\n+ 1 KtCompilingExecutor.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser\n*L\n141#1:183,2\n145#1:185,2\n*E\n"})
    private final class ProcessOutputParser {
        @NotNull
        private final List<ScratchExpression> expressions;

        public ProcessOutputParser(List<ScratchExpression> expressions2) {
            Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
            this.expressions = expressions2;
        }

        public final void parse(@NotNull ProcessOutput processOutput) {
            Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
            String string2 = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processOutput.stdout");
            String out = string2;
            String string3 = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"processOutput.stderr");
            String err = string3;
            if (!StringsKt.isBlank((CharSequence)err)) {
                KtCompilingExecutor.this.getHandler().error(KtCompilingExecutor.this.getFile(), err);
            }
            if (!StringsKt.isBlank((CharSequence)out)) {
                this.parseStdOut(out);
            }
        }

        private final void parseStdOut(String out) {
            ArrayList<String> results2 = new ArrayList<String>();
            ArrayList<String> userOutput = new ArrayList<String>();
            String[] stringArray = new String[]{"\n"};
            for (String line : StringsKt.split$default((CharSequence)out, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Compiling executor output: " + line);
                if (this.isOutputEnd(line)) {
                    return;
                }
                if (this.isGeneratedOutput(line)) {
                    String lineWoPrefix = StringsKt.removePrefix((String)line, (CharSequence)"##scratch##generated##");
                    if (this.isResultEnd(lineWoPrefix)) {
                        int endLine;
                        Pair<Integer, Integer> extractedLineInfo;
                        if (this.extractLineInfoFrom(lineWoPrefix) == null) {
                            Object[] objectArray = new Object[]{lineWoPrefix};
                            ScratchExecutor.errorOccurs$default(KtCompilingExecutor.this, KotlinJvmBundle.message("couldn.t.extract.line.info.from.line.0", objectArray), null, true, 2, null);
                            return;
                        }
                        int startLine = ((Number)extractedLineInfo.component1()).intValue();
                        ScratchExpression scratchExpression = KtCompilingExecutor.this.findExpression(this.expressions, startLine, endLine = ((Number)extractedLineInfo.component2()).intValue());
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression with start line = " + startLine + ", end line = " + endLine + ".\n" + CollectionsKt.joinToString$default((Iterable)this.expressions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                        } else {
                            Iterable $this$forEach$iv;
                            Iterable iterable = userOutput;
                            KtCompilingExecutor ktCompilingExecutor = KtCompilingExecutor.this;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String output = (String)element$iv;
                                boolean bl = false;
                                ktCompilingExecutor.getHandler().handle(ktCompilingExecutor.getFile(), scratchExpression, new ScratchOutput(output, ScratchOutputType.OUTPUT));
                            }
                            $this$forEach$iv = results2;
                            ktCompilingExecutor = KtCompilingExecutor.this;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String result2 = (String)element$iv;
                                boolean bl = false;
                                ktCompilingExecutor.getHandler().handle(ktCompilingExecutor.getFile(), scratchExpression, new ScratchOutput(result2, ScratchOutputType.RESULT));
                            }
                        }
                        results2 = new ArrayList();
                        userOutput = new ArrayList();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)lineWoPrefix, (Object)Unit.INSTANCE.toString())) continue;
                    results2.add(lineWoPrefix);
                    continue;
                }
                userOutput.add(line);
            }
        }

        private final boolean isOutputEnd(String line) {
            return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)line, (CharSequence)"\n"), (Object)"end##!@#%^&*");
        }

        private final boolean isResultEnd(String line) {
            return StringsKt.startsWith$default((String)line, (String)"end##", (boolean)false, (int)2, null);
        }

        private final boolean isGeneratedOutput(String line) {
            return StringsKt.startsWith$default((String)line, (String)"##scratch##generated##", (boolean)false, (int)2, null);
        }

        private final Pair<Integer, Integer> extractLineInfoFrom(String encoded) {
            Object object = new char[]{'|'};
            List lineInfo = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)encoded, (CharSequence)"end##"), (CharSequence)"\n"), (char[])object, (boolean)false, (int)0, (int)6, null);
            if (lineInfo.size() == 2) {
                try {
                    object = TuplesKt.to((Object)Integer.parseInt((String)lineInfo.get(0)), (Object)Integer.parseInt((String)lineInfo.get(1)));
                    int a = ((Number)object.component1()).intValue();
                    int b = ((Number)object.component2()).intValue();
                    if (a > -1 && b > -1) {
                        return TuplesKt.to((Object)a, (Object)b);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

