/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.idea.slicer.OutflowSlicer;
import org.jetbrains.kotlin.idea.slicer.SliceProducer;
import org.jetbrains.kotlin.idea.slicer.SliceProducerKt;
import org.jetbrains.kotlin.idea.slicer.SlicerKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/LambdaCallsBehaviour;", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$Behaviour;", "sliceProducer", "Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;", "(Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;)V", "slicePresentationPrefix", "", "getSlicePresentationPrefix", "()Ljava/lang/String;", "testPresentationPrefix", "getTestPresentationPrefix", "component1", "copy", "equals", "", "other", "", "hashCode", "", "processUsages", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "parent", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage;", "uniqueProcessor", "Lcom/intellij/util/Processor;", "Lcom/intellij/slicer/SliceUsage;", "toString", "kotlin.idea"})
public final class LambdaCallsBehaviour
implements KotlinSliceAnalysisMode.Behaviour {
    @NotNull
    private final SliceProducer sliceProducer;

    public LambdaCallsBehaviour(@NotNull SliceProducer sliceProducer) {
        Intrinsics.checkNotNullParameter((Object)sliceProducer, (String)"sliceProducer");
        this.sliceProducer = sliceProducer;
    }

    @Override
    public void processUsages(@NotNull KtElement element3, @NotNull KotlinSliceUsage parent2, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)parent2), (String)"parent");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        Processor<SliceUsage> processor2 = new Processor<SliceUsage>(this, parent2, uniqueProcessor){
            final /* synthetic */ LambdaCallsBehaviour this$0;
            final /* synthetic */ KotlinSliceUsage $parent;
            final /* synthetic */ Processor<? super SliceUsage> $uniqueProcessor;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
                this.$uniqueProcessor = $uniqueProcessor;
            }

            public boolean process(@NotNull SliceUsage sliceUsage) {
                Intrinsics.checkNotNullParameter((Object)sliceUsage, (String)"sliceUsage");
                if (sliceUsage instanceof KotlinSliceUsage && ((KotlinSliceUsage)sliceUsage).getMode().getCurrentBehaviour() == this.this$0) {
                    ResolvedCall resolvedCall2;
                    PsiElement psiElement2 = ((KotlinSliceUsage)sliceUsage).getElement();
                    if (psiElement2 == null) {
                        return true;
                    }
                    PsiElement sliceElement = psiElement2;
                    KtElement ktElement = sliceElement instanceof KtElement ? (KtElement)sliceElement : null;
                    ResolvedCall resolvedCall3 = resolvedCall2 = ktElement != null ? ResolutionUtils.resolveToCall$default(ktElement, null, 1, null) : null;
                    if (resolvedCall2 != null && SlicerKt.isImplicitInvokeFunction(resolvedCall2.getResultingDescriptor())) {
                        KotlinSliceAnalysisMode originalMode = ((KotlinSliceUsage)sliceUsage).getMode().dropBehaviour();
                        KtElement ktElement2 = resolvedCall2.getCall().getCallElement();
                        Intrinsics.checkNotNullExpressionValue((Object)ktElement2, (String)"resolvedCall.call.callElement");
                        KotlinSliceUsage newSliceUsage = new KotlinSliceUsage((PsiElement)ktElement2, this.$parent, originalMode, true);
                        return SliceProducerKt.produceAndProcess(LambdaCallsBehaviour.access$getSliceProducer$p(this.this$0), newSliceUsage, originalMode, this.$parent, this.$uniqueProcessor);
                    }
                }
                return this.$uniqueProcessor.process((Object)sliceUsage);
            }
        };
        new OutflowSlicer(element3, (Processor<? super SliceUsage>)((Processor)processor2), parent2).processChildren(parent2.getForcedExpressionMode());
    }

    @Override
    @NotNull
    public String getSlicePresentationPrefix() {
        return KotlinBundle.message("slicer.text.tracking.lambda.calls", new Object[0]);
    }

    @Override
    @NotNull
    public String getTestPresentationPrefix() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_testPresentationPrefix__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_testPresentationPrefix__u24lambda_u241.append("[LAMBDA CALLS");
        String string2 = this.sliceProducer.getTestPresentation();
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$_get_testPresentationPrefix__u24lambda_u241.append(" ");
            $this$_get_testPresentationPrefix__u24lambda_u241.append(it);
        }
        $this$_get_testPresentationPrefix__u24lambda_u241.append("] ");
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private final SliceProducer component1() {
        return this.sliceProducer;
    }

    @NotNull
    public final LambdaCallsBehaviour copy(@NotNull SliceProducer sliceProducer) {
        Intrinsics.checkNotNullParameter((Object)sliceProducer, (String)"sliceProducer");
        return new LambdaCallsBehaviour(sliceProducer);
    }

    public static /* synthetic */ LambdaCallsBehaviour copy$default(LambdaCallsBehaviour lambdaCallsBehaviour, SliceProducer sliceProducer, int n, Object object) {
        if ((n & 1) != 0) {
            sliceProducer = lambdaCallsBehaviour.sliceProducer;
        }
        return lambdaCallsBehaviour.copy(sliceProducer);
    }

    @NotNull
    public String toString() {
        return "LambdaCallsBehaviour(sliceProducer=" + this.sliceProducer + ")";
    }

    @Override
    public int hashCode() {
        return ((Object)this.sliceProducer).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof LambdaCallsBehaviour)) {
            return false;
        }
        LambdaCallsBehaviour lambdaCallsBehaviour = (LambdaCallsBehaviour)other2;
        return Intrinsics.areEqual((Object)this.sliceProducer, (Object)lambdaCallsBehaviour.sliceProducer);
    }

    public static final /* synthetic */ SliceProducer access$getSliceProducer$p(LambdaCallsBehaviour $this) {
        return $this.sliceProducer;
    }
}

