/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.EmptyJavaToKotlinServices;
import org.jetbrains.kotlin.j2k.OldJavaToKotlinConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/JavaToKotlinTranslator;", "", "()V", "createFile", "Lcom/intellij/psi/PsiFile;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "generateKotlinCode", "javaCode", "prettify", "code", "kotlin.j2k.old"})
public final class JavaToKotlinTranslator {
    @NotNull
    public static final JavaToKotlinTranslator INSTANCE = new JavaToKotlinTranslator();

    private JavaToKotlinTranslator() {
    }

    private final PsiFile createFile(String text2, Project project2) {
        return PsiFileFactory.getInstance((Project)project2).createFileFromText("test.java", (Language)JavaLanguage.INSTANCE, (CharSequence)text2);
    }

    private final String prettify(String code) {
        if (code == null) {
            return "";
        }
        CharSequence charSequence2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)code)).toString(), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)" \n", (String)"\n", (boolean)false, (int)4, null), (String)"\n ", (String)"\n", (boolean)false, (int)4, null);
        Regex regex = new Regex("\n+");
        String string2 = "\n";
        charSequence2 = regex.replace(charSequence2, string2);
        regex = new Regex(" +");
        string2 = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence2, string2))).toString();
    }

    @NotNull
    public final String generateKotlinCode(@NotNull String javaCode, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)javaCode, (String)"javaCode");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiFile file2 = this.createFile(javaCode, project2);
        if (file2 instanceof PsiJavaFile) {
            Project project3 = ((PsiJavaFile)file2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
            OldJavaToKotlinConverter converter = new OldJavaToKotlinConverter(project3, ConverterSettings.Companion.getDefaultSettings(), EmptyJavaToKotlinServices.INSTANCE);
            Object object = CollectionsKt.single(converter.elementsToKotlin(CollectionsKt.listOf((Object)file2)).getResults());
            Intrinsics.checkNotNull((Object)object);
            return this.prettify(((ElementResult)object).getText());
        }
        return "";
    }
}

