/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/AssignmentExpression;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "left", "right", "op", "Lorg/jetbrains/kotlin/j2k/ast/Operator;", "(Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Operator;)V", "getLeft", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "getOp", "()Lorg/jetbrains/kotlin/j2k/ast/Operator;", "getRight", "appendAssignment", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "generateCode", "isMultiAssignment", "", "kotlin.j2k.old"})
public class AssignmentExpression
extends Expression {
    @NotNull
    private final Expression left;
    @NotNull
    private final Expression right;
    @NotNull
    private final Operator op;

    public AssignmentExpression(@NotNull Expression left, @NotNull Expression right2, @NotNull Operator op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right2, (String)"right");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        this.left = left;
        this.right = right2;
        this.op = op;
    }

    @NotNull
    public final Expression getLeft() {
        return this.left;
    }

    @NotNull
    public final Expression getRight() {
        return this.right;
    }

    @NotNull
    public final Operator getOp() {
        return this.op;
    }

    public final boolean isMultiAssignment() {
        return this.right instanceof AssignmentExpression;
    }

    private final void appendAssignment(CodeBuilder builder2, Expression left, Expression right2) {
        UtilKt.appendOperand$default(UtilKt.appendOperand$default(builder2, this, left, false, 4, null).append(" ").append(this.op).append(" "), this, right2, false, 4, null);
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        if (!(this.right instanceof AssignmentExpression)) {
            this.appendAssignment(builder2, this.left, this.right);
        } else {
            this.right.generateCode(builder2);
            builder2.append("\n");
            this.appendAssignment(builder2, this.left, ((AssignmentExpression)this.right).left);
        }
    }
}

